/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.catalog;

import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.FunctionIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogColumn;
import org.apache.spark.sql.catalyst.catalog.CatalogDatabase;
import org.apache.spark.sql.catalyst.catalog.CatalogFunction;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalog;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\tee\u0001B\u0001\u0003\u0001=\u0011q\"\u00138NK6|'/_\"bi\u0006dwn\u001a\u0006\u0003\u0007\u0011\tqaY1uC2|wM\u0003\u0002\u0006\r\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001!A\u0011\u0011CE\u0007\u0002\u0005%\u00111C\u0001\u0002\u0010\u000bb$XM\u001d8bY\u000e\u000bG/\u00197pO\")Q\u0003\u0001C\u0001-\u00051A(\u001b8jiz\"\u0012a\u0006\t\u0003#\u00011A!\u0007\u0001\u00055\tIA+\u00192mK\u0012+7oY\n\u00031m\u0001\"\u0001H\u0010\u000e\u0003uQ\u0011AH\u0001\u0006g\u000e\fG.Y\u0005\u0003Au\u0011a!\u00118z%\u00164\u0007\u0002\u0003\u0012\u0019\u0005\u0003\u0007I\u0011A\u0012\u0002\u000bQ\f'\r\\3\u0016\u0003\u0011\u0002\"!E\u0013\n\u0005\u0019\u0012!\u0001D\"bi\u0006dwn\u001a+bE2,\u0007\u0002\u0003\u0015\u0019\u0005\u0003\u0007I\u0011A\u0015\u0002\u0013Q\f'\r\\3`I\u0015\fHC\u0001\u0016.!\ta2&\u0003\u0002-;\t!QK\\5u\u0011\u001dqs%!AA\u0002\u0011\n1\u0001\u001f\u00132\u0011!\u0001\u0004D!A!B\u0013!\u0013A\u0002;bE2,\u0007\u0005C\u0003\u00161\u0011\u0005!\u0007\u0006\u00024kA\u0011A\u0007G\u0007\u0002\u0001!)!%\ra\u0001I!9q\u0007\u0007b\u0001\n\u0003A\u0014A\u00039beRLG/[8ogV\t\u0011\b\u0005\u0003;\u007f\u0005CU\"A\u001e\u000b\u0005qj\u0014aB7vi\u0006\u0014G.\u001a\u0006\u0003}u\t!bY8mY\u0016\u001cG/[8o\u0013\t\u00015HA\u0004ICNDW*\u00199\u0011\u0005\t+eBA\tD\u0013\t!%!A\bFqR,'O\\1m\u0007\u0006$\u0018\r\\8h\u0013\t1uI\u0001\nUC\ndW\rU1si&$\u0018n\u001c8Ta\u0016\u001c'B\u0001#\u0003!\t\t\u0012*\u0003\u0002K\u0005\t)2)\u0019;bY><G+\u00192mKB\u000b'\u000f^5uS>t\u0007B\u0002'\u0019A\u0003%\u0011(A\u0006qCJ$\u0018\u000e^5p]N\u0004c\u0001\u0002(\u0001\t=\u0013A\u0002R1uC\n\f7/\u001a#fg\u000e\u001c\"!T\u000e\t\u0011Ek%\u00111A\u0005\u0002I\u000b!\u0001\u001a2\u0016\u0003M\u0003\"!\u0005+\n\u0005U\u0013!aD\"bi\u0006dwn\u001a#bi\u0006\u0014\u0017m]3\t\u0011]k%\u00111A\u0005\u0002a\u000ba\u0001\u001a2`I\u0015\fHC\u0001\u0016Z\u0011\u001dqc+!AA\u0002MC\u0001bW'\u0003\u0002\u0003\u0006KaU\u0001\u0004I\n\u0004\u0003\"B\u000bN\t\u0003iFC\u00010`!\t!T\nC\u0003R9\u0002\u00071\u000bC\u0004b\u001b\n\u0007I\u0011\u00012\u0002\rQ\f'\r\\3t+\u0005\u0019\u0007\u0003\u0002\u001e@IN\u0002\"!\u001a5\u000f\u0005q1\u0017BA4\u001e\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011N\u001b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u001dl\u0002B\u00027NA\u0003%1-A\u0004uC\ndWm\u001d\u0011\t\u000f9l%\u0019!C\u0001_\u0006Ia-\u001e8di&|gn]\u000b\u0002aB!!h\u00103r!\t\t\"/\u0003\u0002t\u0005\ty1)\u0019;bY><g)\u001e8di&|g\u000e\u0003\u0004v\u001b\u0002\u0006I\u0001]\u0001\u000bMVt7\r^5p]N\u0004\u0003bB\u0002\u0001\u0005\u0004%Ia^\u000b\u0002qB!!h\u00103_\u0011\u0019Q\b\u0001)A\u0005q\u0006A1-\u0019;bY><\u0007\u0005C\u0003}\u0001\u0011%Q0A\u0007gS2$XM\u001d)biR,'O\u001c\u000b\u0006}\u0006U\u0011\u0011\u0004\t\u0005\u007f\u0006=AM\u0004\u0003\u0002\u0002\u0005-a\u0002BA\u0002\u0003\u0013i!!!\u0002\u000b\u0007\u0005\u001da\"\u0001\u0004=e>|GOP\u0005\u0002=%\u0019\u0011QB\u000f\u0002\u000fA\f7m[1hK&!\u0011\u0011CA\n\u0005\r\u0019V-\u001d\u0006\u0004\u0003\u001bi\u0002BBA\fw\u0002\u0007a0A\u0003oC6,7\u000f\u0003\u0004\u0002\u001cm\u0004\r\u0001Z\u0001\ba\u0006$H/\u001a:o\u0011\u001d\ty\u0002\u0001C\u0005\u0003C\taBZ;oGRLwN\\#ySN$8\u000f\u0006\u0004\u0002$\u0005%\u00121\u0006\t\u00049\u0005\u0015\u0012bAA\u0014;\t9!i\\8mK\u0006t\u0007BB)\u0002\u001e\u0001\u0007A\rC\u0004\u0002.\u0005u\u0001\u0019\u00013\u0002\u0011\u0019,hn\u0019(b[\u0016Dq!!\r\u0001\t\u0013\t\u0019$A\bqCJ$\u0018\u000e^5p]\u0016C\u0018n\u001d;t)!\t\u0019#!\u000e\u00028\u0005e\u0002BB)\u00020\u0001\u0007A\r\u0003\u0004#\u0003_\u0001\r\u0001\u001a\u0005\b\u0003w\ty\u00031\u0001B\u0003\u0011\u0019\b/Z2\t\u000f\u0005}\u0002\u0001\"\u0003\u0002B\u0005)\"/Z9vSJ,g)\u001e8di&|g.\u0012=jgR\u001cH#\u0002\u0016\u0002D\u0005\u0015\u0003BB)\u0002>\u0001\u0007A\rC\u0004\u0002.\u0005u\u0002\u0019\u00013\t\u000f\u0005%\u0003\u0001\"\u0003\u0002L\u0005\u0011\"/Z9vSJ,G+\u00192mK\u0016C\u0018n\u001d;t)\u0015Q\u0013QJA(\u0011\u0019\t\u0016q\ta\u0001I\"1!%a\u0012A\u0002\u0011Dq!a\u0015\u0001\t\u0013\t)&\u0001\fsKF,\u0018N]3QCJ$\u0018\u000e^5p]\u0016C\u0018n\u001d;t)\u001dQ\u0013qKA-\u00037Ba!UA)\u0001\u0004!\u0007B\u0002\u0012\u0002R\u0001\u0007A\rC\u0004\u0002<\u0005E\u0003\u0019A!\t\u000f\u0005}\u0003\u0001\"\u0011\u0002b\u0005q1M]3bi\u0016$\u0015\r^1cCN,G#\u0002\u0016\u0002d\u0005\u001d\u0004bBA3\u0003;\u0002\raU\u0001\rI\n$UMZ5oSRLwN\u001c\u0005\t\u0003S\ni\u00061\u0001\u0002$\u0005q\u0011n\u001a8pe\u0016Le-\u0012=jgR\u001c\bbBA7\u0001\u0011\u0005\u0013qN\u0001\rIJ|\u0007\u000fR1uC\n\f7/\u001a\u000b\bU\u0005E\u00141OA<\u0011\u0019\t\u00161\u000ea\u0001I\"A\u0011QOA6\u0001\u0004\t\u0019#A\tjO:|'/Z%g\u001d>$X\t_5tiND\u0001\"!\u001f\u0002l\u0001\u0007\u00111E\u0001\bG\u0006\u001c8-\u00193f\u0011\u001d\ti\b\u0001C!\u0003\u007f\nQ\"\u00197uKJ$\u0015\r^1cCN,Gc\u0001\u0016\u0002\u0002\"9\u0011QMA>\u0001\u0004\u0019\u0006bBAC\u0001\u0011\u0005\u0013qQ\u0001\fO\u0016$H)\u0019;bE\u0006\u001cX\rF\u0002T\u0003\u0013Ca!UAB\u0001\u0004!\u0007bBAG\u0001\u0011\u0005\u0013qR\u0001\u000fI\u0006$\u0018MY1tK\u0016C\u0018n\u001d;t)\u0011\t\u0019#!%\t\rE\u000bY\t1\u0001e\u0011\u001d\t)\n\u0001C!\u0003/\u000bQ\u0002\\5ti\u0012\u000bG/\u00192bg\u0016\u001cH#\u0001@\t\u000f\u0005U\u0005\u0001\"\u0011\u0002\u001cR\u0019a0!(\t\u000f\u0005m\u0011\u0011\u0014a\u0001I\"9\u0011\u0011\u0015\u0001\u0005B\u0005\r\u0016AE:fi\u000e+(O]3oi\u0012\u000bG/\u00192bg\u0016$2AKAS\u0011\u0019\t\u0016q\u0014a\u0001I\"9\u0011\u0011\u0016\u0001\u0005B\u0005-\u0016aC2sK\u0006$X\rV1cY\u0016$rAKAW\u0003_\u000b\u0019\f\u0003\u0004R\u0003O\u0003\r\u0001\u001a\u0005\b\u0003c\u000b9\u000b1\u0001%\u0003=!\u0018M\u00197f\t\u00164\u0017N\\5uS>t\u0007\u0002CA5\u0003O\u0003\r!a\t\t\u000f\u0005]\u0006\u0001\"\u0011\u0002:\u0006IAM]8q)\u0006\u0014G.\u001a\u000b\bU\u0005m\u0016QXA`\u0011\u0019\t\u0016Q\u0017a\u0001I\"1!%!.A\u0002\u0011D\u0001\"!\u001e\u00026\u0002\u0007\u00111\u0005\u0005\b\u0003\u0007\u0004A\u0011IAc\u0003-\u0011XM\\1nKR\u000b'\r\\3\u0015\u000f)\n9-!3\u0002N\"1\u0011+!1A\u0002\u0011Dq!a3\u0002B\u0002\u0007A-A\u0004pY\u0012t\u0015-\\3\t\u000f\u0005=\u0017\u0011\u0019a\u0001I\u00069a.Z<OC6,\u0007bBAj\u0001\u0011\u0005\u0013Q[\u0001\u000bC2$XM\u001d+bE2,G#\u0002\u0016\u0002X\u0006e\u0007BB)\u0002R\u0002\u0007A\rC\u0004\u00022\u0006E\u0007\u0019\u0001\u0013\t\u000f\u0005u\u0007\u0001\"\u0011\u0002`\u0006Aq-\u001a;UC\ndW\rF\u0003%\u0003C\f\u0019\u000f\u0003\u0004R\u00037\u0004\r\u0001\u001a\u0005\u0007E\u0005m\u0007\u0019\u00013\t\u000f\u0005\u001d\b\u0001\"\u0011\u0002j\u0006YA/\u00192mK\u0016C\u0018n\u001d;t)\u0019\t\u0019#a;\u0002n\"1\u0011+!:A\u0002\u0011DaAIAs\u0001\u0004!\u0007bBAy\u0001\u0011\u0005\u00131_\u0001\u000bY&\u001cH\u000fV1cY\u0016\u001cHc\u0001@\u0002v\"1\u0011+a<A\u0002\u0011Dq!!=\u0001\t\u0003\nI\u0010F\u0003\u007f\u0003w\fi\u0010\u0003\u0004R\u0003o\u0004\r\u0001\u001a\u0005\b\u00037\t9\u00101\u0001e\u0011\u001d\u0011\t\u0001\u0001C!\u0005\u0007\t\u0001c\u0019:fCR,\u0007+\u0019:uSRLwN\\:\u0015\u0013)\u0012)Aa\u0002\u0003\n\t=\u0001BB)\u0002\u0000\u0002\u0007A\r\u0003\u0004#\u0003\u007f\u0004\r\u0001\u001a\u0005\t\u0005\u0017\ty\u00101\u0001\u0003\u000e\u0005)\u0001/\u0019:ugB!q0a\u0004I\u0011!\tI'a@A\u0002\u0005\r\u0002b\u0002B\n\u0001\u0011\u0005#QC\u0001\u000fIJ|\u0007\u000fU1si&$\u0018n\u001c8t)%Q#q\u0003B\r\u00057\u0011\t\u0003\u0003\u0004R\u0005#\u0001\r\u0001\u001a\u0005\u0007E\tE\u0001\u0019\u00013\t\u0011\tu!\u0011\u0003a\u0001\u0005?\t\u0011\u0002]1siN\u0003XmY:\u0011\t}\fy!\u0011\u0005\t\u0003k\u0012\t\u00021\u0001\u0002$!9!Q\u0005\u0001\u0005B\t\u001d\u0012\u0001\u0005:f]\u0006lW\rU1si&$\u0018n\u001c8t)%Q#\u0011\u0006B\u0016\u0005[\u0011\t\u0004\u0003\u0004R\u0005G\u0001\r\u0001\u001a\u0005\u0007E\t\r\u0002\u0019\u00013\t\u0011\t=\"1\u0005a\u0001\u0005?\tQa\u001d9fGND\u0001Ba\r\u0003$\u0001\u0007!qD\u0001\t]\u0016<8\u000b]3dg\"9!q\u0007\u0001\u0005B\te\u0012aD1mi\u0016\u0014\b+\u0019:uSRLwN\\:\u0015\u000f)\u0012YD!\u0010\u0003@!1\u0011K!\u000eA\u0002\u0011DaA\tB\u001b\u0001\u0004!\u0007\u0002\u0003B\u0006\u0005k\u0001\rA!\u0004\t\u000f\t\r\u0003\u0001\"\u0011\u0003F\u0005aq-\u001a;QCJ$\u0018\u000e^5p]R9\u0001Ja\u0012\u0003J\t-\u0003BB)\u0003B\u0001\u0007A\r\u0003\u0004#\u0005\u0003\u0002\r\u0001\u001a\u0005\b\u0003w\u0011\t\u00051\u0001B\u0011\u001d\u0011y\u0005\u0001C!\u0005#\na\u0002\\5tiB\u000b'\u000f^5uS>t7\u000f\u0006\u0004\u0003\u000e\tM#Q\u000b\u0005\u0007#\n5\u0003\u0019\u00013\t\r\t\u0012i\u00051\u0001e\u0011\u001d\u0011I\u0006\u0001C!\u00057\nab\u0019:fCR,g)\u001e8di&|g\u000eF\u0003+\u0005;\u0012y\u0006\u0003\u0004R\u0005/\u0002\r\u0001\u001a\u0005\b\u0005C\u00129\u00061\u0001r\u0003\u00111WO\\2\t\u000f\t\u0015\u0004\u0001\"\u0011\u0003h\u0005aAM]8q\rVt7\r^5p]R)!F!\u001b\u0003l!1\u0011Ka\u0019A\u0002\u0011Dq!!\f\u0003d\u0001\u0007A\rC\u0004\u0003p\u0001!\tE!\u001d\u0002\u001dI,g.Y7f\rVt7\r^5p]R9!Fa\u001d\u0003v\t]\u0004BB)\u0003n\u0001\u0007A\rC\u0004\u0002L\n5\u0004\u0019\u00013\t\u000f\u0005='Q\u000ea\u0001I\"9!1\u0010\u0001\u0005B\tu\u0014!D1mi\u0016\u0014h)\u001e8di&|g\u000eF\u0003+\u0005\u007f\u0012\t\t\u0003\u0004R\u0005s\u0002\r\u0001\u001a\u0005\b\u0005\u0007\u0013I\b1\u0001r\u000391WO\\2EK\u001aLg.\u001b;j_:DqAa\"\u0001\t\u0003\u0012I)A\u0006hKR4UO\\2uS>tG#B9\u0003\f\n5\u0005BB)\u0003\u0006\u0002\u0007A\rC\u0004\u0002.\t\u0015\u0005\u0019\u00013\t\u000f\tE\u0005\u0001\"\u0011\u0003\u0014\u0006iA.[:u\rVt7\r^5p]N$RA BK\u0005/Ca!\u0015BH\u0001\u0004!\u0007bBA\u000e\u0005\u001f\u0003\r\u0001\u001a")
public class InMemoryCatalog
extends ExternalCatalog {
    private final HashMap<String, DatabaseDesc> org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog = new HashMap();

    public HashMap<String, DatabaseDesc> org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog() {
        return this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog;
    }

    private Seq<String> filterPattern(Seq<String> names2, String pattern) {
        Regex regex = new StringOps(Predef$.MODULE$.augmentString(pattern.replaceAll("\\*", ".*"))).r();
        return (Seq)names2.filter((Function1)new Serializable(this, regex){
            public static final long serialVersionUID = 0L;
            private final Regex regex$1;

            public final boolean apply(String funcName) {
                return this.regex$1.pattern().matcher(funcName).matches();
            }
            {
                this.regex$1 = regex$1;
            }
        });
    }

    private boolean functionExists(String db, String funcName) {
        this.requireDbExists(db);
        return ((DatabaseDesc)this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().apply((Object)db)).functions().contains((Object)funcName);
    }

    private boolean partitionExists(String db, String table, Map<String, String> spec) {
        this.requireTableExists(db, table);
        return ((TableDesc)((DatabaseDesc)this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().apply((Object)db)).tables().apply((Object)table)).partitions().contains(spec);
    }

    private void requireFunctionExists(String db, String funcName) {
        if (this.functionExists(db, funcName)) {
            return;
        }
        throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Function not found: '", "' does not exist in database '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{funcName, db})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4());
    }

    private void requireTableExists(String db, String table) {
        if (this.tableExists(db, table)) {
            return;
        }
        throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Table not found: '", "' does not exist in database '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table, db})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4());
    }

    public void org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$requirePartitionExists(String db, String table, Map<String, String> spec) {
        if (this.partitionExists(db, table, spec)) {
            return;
        }
        throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition not found: database '", "' table '", "' does not contain: '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{db, table, spec})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void createDatabase(CatalogDatabase dbDefinition, boolean ignoreIfExists) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            BoxedUnit boxedUnit;
            if (this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().contains((Object)dbDefinition.name())) {
                if (!ignoreIfExists) throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Database '", "' already exists."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dbDefinition.name()})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().put((Object)dbDefinition.name(), (Object)new DatabaseDesc(this, dbDefinition));
            }
            return;
        }
    }

    @Override
    public void dropDatabase(String db, boolean ignoreIfNotExists, boolean cascade) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            block11: {
                block10: {
                    BoxedUnit boxedUnit;
                    block9: {
                        if (!this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().contains((Object)db)) break block9;
                        if (!cascade) {
                            if (((DatabaseDesc)this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().apply((Object)db)).tables().nonEmpty()) {
                                throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Database '", "' is not empty. One or more tables exist."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{db})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4());
                            }
                            if (((DatabaseDesc)this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().apply((Object)db)).functions().nonEmpty()) {
                                throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Database '", "' is not empty. One or more functions exist."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{db})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4());
                            }
                        }
                        boxedUnit = this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().remove((Object)db);
                        break block10;
                    }
                    if (!ignoreIfNotExists) break block11;
                    boxedUnit = BoxedUnit.UNIT;
                }
                return;
            }
            throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Database '", "' does not exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{db})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4());
        }
    }

    @Override
    public synchronized void alterDatabase(CatalogDatabase dbDefinition) {
        this.requireDbExists(dbDefinition.name());
        ((DatabaseDesc)this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().apply((Object)dbDefinition.name())).db_$eq(dbDefinition);
    }

    @Override
    public synchronized CatalogDatabase getDatabase(String db) {
        this.requireDbExists(db);
        return ((DatabaseDesc)this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().apply((Object)db)).db();
    }

    @Override
    public synchronized boolean databaseExists(String db) {
        return this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().contains((Object)db);
    }

    @Override
    public synchronized Seq<String> listDatabases() {
        return this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().keySet().toSeq();
    }

    @Override
    public synchronized Seq<String> listDatabases(String pattern) {
        return this.filterPattern(this.listDatabases(), pattern);
    }

    @Override
    public void setCurrentDatabase(String db) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void createTable(String db, CatalogTable tableDefinition, boolean ignoreIfExists) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            BoxedUnit boxedUnit;
            this.requireDbExists(db);
            String table = tableDefinition.identifier().table();
            if (this.tableExists(db, table)) {
                if (!ignoreIfExists) throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Table '", "' already exists in database '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table, db})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = ((DatabaseDesc)this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().apply((Object)db)).tables().put((Object)table, (Object)new TableDesc(this, tableDefinition));
            }
            return;
        }
    }

    @Override
    public void dropTable(String db, String table, boolean ignoreIfNotExists) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            block7: {
                block6: {
                    BoxedUnit boxedUnit;
                    block5: {
                        this.requireDbExists(db);
                        if (!this.tableExists(db, table)) break block5;
                        boxedUnit = ((DatabaseDesc)this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().apply((Object)db)).tables().remove((Object)table);
                        break block6;
                    }
                    if (!ignoreIfNotExists) break block7;
                    boxedUnit = BoxedUnit.UNIT;
                }
                return;
            }
            throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Table '", "' does not exist in database '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table, db})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4());
        }
    }

    @Override
    public void renameTable(String db, String oldName, String newName) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            this.requireTableExists(db, oldName);
            TableDesc oldDesc = (TableDesc)((DatabaseDesc)this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().apply((Object)db)).tables().apply((Object)oldName);
            CatalogTable qual$1 = oldDesc.table();
            TableIdentifier x$1 = new TableIdentifier(newName, (Option<String>)new Some((Object)db));
            CatalogTableType x$2 = qual$1.copy$default$2();
            CatalogStorageFormat x$3 = qual$1.copy$default$3();
            Seq<CatalogColumn> x$4 = qual$1.copy$default$4();
            Seq<CatalogColumn> x$5 = qual$1.copy$default$5();
            Seq<CatalogColumn> x$6 = qual$1.copy$default$6();
            int x$7 = qual$1.copy$default$7();
            long x$8 = qual$1.copy$default$8();
            long x$9 = qual$1.copy$default$9();
            Map<String, String> x$10 = qual$1.copy$default$10();
            Option<String> x$11 = qual$1.copy$default$11();
            Option<String> x$12 = qual$1.copy$default$12();
            oldDesc.table_$eq(qual$1.copy(x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12));
            ((DatabaseDesc)this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().apply((Object)db)).tables().put((Object)newName, (Object)oldDesc);
            ((DatabaseDesc)this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().apply((Object)db)).tables().remove((Object)oldName);
            return;
        }
    }

    @Override
    public synchronized void alterTable(String db, CatalogTable tableDefinition) {
        this.requireTableExists(db, tableDefinition.identifier().table());
        ((TableDesc)((DatabaseDesc)this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().apply((Object)db)).tables().apply((Object)tableDefinition.identifier().table())).table_$eq(tableDefinition);
    }

    @Override
    public synchronized CatalogTable getTable(String db, String table) {
        this.requireTableExists(db, table);
        return ((TableDesc)((DatabaseDesc)this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().apply((Object)db)).tables().apply((Object)table)).table();
    }

    @Override
    public synchronized boolean tableExists(String db, String table) {
        this.requireDbExists(db);
        return ((DatabaseDesc)this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().apply((Object)db)).tables().contains((Object)table);
    }

    @Override
    public synchronized Seq<String> listTables(String db) {
        this.requireDbExists(db);
        return ((DatabaseDesc)this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().apply((Object)db)).tables().keySet().toSeq();
    }

    @Override
    public synchronized Seq<String> listTables(String db, String pattern) {
        return this.filterPattern(this.listTables(db), pattern);
    }

    @Override
    public synchronized void createPartitions(String db, String table, Seq<CatalogTablePartition> parts, boolean ignoreIfExists) {
        Seq dupSpecs;
        this.requireTableExists(db, table);
        HashMap<Map<String, String>, CatalogTablePartition> existingParts = ((TableDesc)((DatabaseDesc)this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().apply((Object)db)).tables().apply((Object)table)).partitions();
        if (!ignoreIfExists && (dupSpecs = (Seq)parts.collect((PartialFunction)new Serializable(this, existingParts){
            public static final long serialVersionUID = 0L;
            private final HashMap existingParts$1;

            public final <A1 extends CatalogTablePartition, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = this.existingParts$1.contains(A1.spec()) ? A1.spec() : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(CatalogTablePartition x1) {
                CatalogTablePartition catalogTablePartition = x1;
                boolean bl = this.existingParts$1.contains(catalogTablePartition.spec());
                return bl;
            }
            {
                this.existingParts$1 = existingParts$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).nonEmpty()) {
            String dupSpecsStr = dupSpecs.mkString("\n===\n");
            throw new AnalysisException(new StringBuilder().append((Object)"The following partitions already exist in database ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "' table '", "':\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{db, table, dupSpecsStr}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4());
        }
        parts.foreach((Function1)new Serializable(this, existingParts){
            public static final long serialVersionUID = 0L;
            private final HashMap existingParts$1;

            public final Option<CatalogTablePartition> apply(CatalogTablePartition p) {
                return this.existingParts$1.put(p.spec(), (Object)p);
            }
            {
                this.existingParts$1 = existingParts$1;
            }
        });
    }

    @Override
    public synchronized void dropPartitions(String db, String table, Seq<Map<String, String>> partSpecs, boolean ignoreIfNotExists) {
        Seq missingSpecs;
        this.requireTableExists(db, table);
        HashMap<Map<String, String>, CatalogTablePartition> existingParts = ((TableDesc)((DatabaseDesc)this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().apply((Object)db)).tables().apply((Object)table)).partitions();
        if (!ignoreIfNotExists && (missingSpecs = (Seq)partSpecs.collect((PartialFunction)new Serializable(this, existingParts){
            public static final long serialVersionUID = 0L;
            private final HashMap existingParts$2;

            public final <A1 extends Map<String, String>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                Object object = this.existingParts$2.contains(A1) ? function1.apply(x2) : A1;
                return (B1)object;
            }

            public final boolean isDefinedAt(Map<String, String> x2) {
                Map<String, String> map2 = x2;
                boolean bl = !this.existingParts$2.contains(map2);
                return bl;
            }
            {
                this.existingParts$2 = existingParts$2;
            }
        }, Seq$.MODULE$.canBuildFrom())).nonEmpty()) {
            String missingSpecsStr = missingSpecs.mkString("\n===\n");
            throw new AnalysisException(new StringBuilder().append((Object)"The following partitions do not exist in database ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "' table '", "':\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{db, table, missingSpecsStr}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4());
        }
        partSpecs.foreach((Function1)new Serializable(this, existingParts){
            public static final long serialVersionUID = 0L;
            private final HashMap existingParts$2;

            public final Option<CatalogTablePartition> apply(Map<String, String> key) {
                return this.existingParts$2.remove(key);
            }
            {
                this.existingParts$2 = existingParts$2;
            }
        });
    }

    @Override
    public synchronized void renamePartitions(String db, String table, Seq<Map<String, String>> specs, Seq<Map<String, String>> newSpecs) {
        Predef$.MODULE$.require(specs.size() == newSpecs.size(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "number of old and new partition specs differ";
            }
        });
        ((IterableLike)specs.zip(newSpecs, Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, db, table){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InMemoryCatalog $outer;
            private final String db$1;
            private final String table$1;

            public final Option<CatalogTablePartition> apply(Tuple2<Map<String, String>, Map<String, String>> x0$1) {
                Tuple2<Map<String, String>, Map<String, String>> tuple2 = x0$1;
                if (tuple2 != null) {
                    Map oldSpec = (Map)tuple2._1();
                    Map newSpec = (Map)tuple2._2();
                    CatalogTablePartition qual$2 = this.$outer.getPartition(this.db$1, this.table$1, (Map<String, String>)oldSpec);
                    Map x$13 = newSpec;
                    CatalogStorageFormat x$14 = qual$2.copy$default$2();
                    CatalogTablePartition newPart = qual$2.copy((Map<String, String>)x$13, x$14);
                    HashMap<Map<String, String>, CatalogTablePartition> existingParts = ((TableDesc)((DatabaseDesc)this.$outer.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().apply((Object)this.db$1)).tables().apply((Object)this.table$1)).partitions();
                    existingParts.remove((Object)oldSpec);
                    Option option = existingParts.put((Object)newSpec, (Object)newPart);
                    return option;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.db$1 = db$1;
                this.table$1 = table$1;
            }
        });
    }

    @Override
    public synchronized void alterPartitions(String db, String table, Seq<CatalogTablePartition> parts) {
        parts.foreach((Function1)new Serializable(this, db, table){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InMemoryCatalog $outer;
            private final String db$2;
            private final String table$2;

            public final Option<CatalogTablePartition> apply(CatalogTablePartition p) {
                this.$outer.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$requirePartitionExists(this.db$2, this.table$2, p.spec());
                return ((TableDesc)((DatabaseDesc)this.$outer.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().apply((Object)this.db$2)).tables().apply((Object)this.table$2)).partitions().put(p.spec(), (Object)p);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.db$2 = db$2;
                this.table$2 = table$2;
            }
        });
    }

    @Override
    public synchronized CatalogTablePartition getPartition(String db, String table, Map<String, String> spec) {
        this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$requirePartitionExists(db, table, spec);
        return (CatalogTablePartition)((TableDesc)((DatabaseDesc)this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().apply((Object)db)).tables().apply((Object)table)).partitions().apply(spec);
    }

    @Override
    public synchronized Seq<CatalogTablePartition> listPartitions(String db, String table) {
        this.requireTableExists(db, table);
        return ((TableDesc)((DatabaseDesc)this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().apply((Object)db)).tables().apply((Object)table)).partitions().values().toSeq();
    }

    @Override
    public void createFunction(String db, CatalogFunction func) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            this.requireDbExists(db);
            if (this.functionExists(db, func.identifier().funcName())) {
                throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Function '", "' already exists in '", "' database"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{func, db})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4());
            }
            ((DatabaseDesc)this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().apply((Object)db)).functions().put((Object)func.identifier().funcName(), (Object)func);
            return;
        }
    }

    @Override
    public void dropFunction(String db, String funcName) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            this.requireFunctionExists(db, funcName);
            ((DatabaseDesc)this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().apply((Object)db)).functions().remove((Object)funcName);
            return;
        }
    }

    @Override
    public void renameFunction(String db, String oldName, String newName) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            this.requireFunctionExists(db, oldName);
            CatalogFunction qual$3 = this.getFunction(db, oldName);
            FunctionIdentifier x$15 = new FunctionIdentifier(newName, (Option<String>)new Some((Object)db));
            String x$16 = qual$3.copy$default$2();
            CatalogFunction newFunc = qual$3.copy(x$15, x$16);
            ((DatabaseDesc)this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().apply((Object)db)).functions().remove((Object)oldName);
            ((DatabaseDesc)this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().apply((Object)db)).functions().put((Object)newName, (Object)newFunc);
            return;
        }
    }

    @Override
    public void alterFunction(String db, CatalogFunction funcDefinition) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            this.requireFunctionExists(db, funcDefinition.identifier().funcName());
            ((DatabaseDesc)this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().apply((Object)db)).functions().put((Object)funcDefinition.identifier().funcName(), (Object)funcDefinition);
            return;
        }
    }

    @Override
    public synchronized CatalogFunction getFunction(String db, String funcName) {
        this.requireFunctionExists(db, funcName);
        return (CatalogFunction)((DatabaseDesc)this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().apply((Object)db)).functions().apply((Object)funcName);
    }

    @Override
    public synchronized Seq<String> listFunctions(String db, String pattern) {
        this.requireDbExists(db);
        return this.filterPattern((Seq<String>)((DatabaseDesc)this.org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$$catalog().apply((Object)db)).functions().keysIterator().toSeq(), pattern);
    }

    public class TableDesc {
        private CatalogTable table;
        private final HashMap<Map<String, String>, CatalogTablePartition> partitions;
        public final /* synthetic */ InMemoryCatalog $outer;

        public CatalogTable table() {
            return this.table;
        }

        public void table_$eq(CatalogTable x$1) {
            this.table = x$1;
        }

        public HashMap<Map<String, String>, CatalogTablePartition> partitions() {
            return this.partitions;
        }

        public /* synthetic */ InMemoryCatalog org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$TableDesc$$$outer() {
            return this.$outer;
        }

        public TableDesc(InMemoryCatalog $outer, CatalogTable table) {
            this.table = table;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.partitions = new HashMap();
        }
    }

    public class DatabaseDesc {
        private CatalogDatabase db;
        private final HashMap<String, TableDesc> tables;
        private final HashMap<String, CatalogFunction> functions;
        public final /* synthetic */ InMemoryCatalog $outer;

        public CatalogDatabase db() {
            return this.db;
        }

        public void db_$eq(CatalogDatabase x$1) {
            this.db = x$1;
        }

        public HashMap<String, TableDesc> tables() {
            return this.tables;
        }

        public HashMap<String, CatalogFunction> functions() {
            return this.functions;
        }

        public /* synthetic */ InMemoryCatalog org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$DatabaseDesc$$$outer() {
            return this.$outer;
        }

        public DatabaseDesc(InMemoryCatalog $outer, CatalogDatabase db) {
            this.db = db;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.tables = new HashMap();
            this.functions = new HashMap();
        }
    }
}

