/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$class;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.aggregate.CountMinSketchAgg$;
import org.apache.spark.sql.catalyst.expressions.aggregate.TypedImperativeAggregate;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.sketch.CountMinSketch;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple6;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(col, eps, confidence, seed) - Returns a count-min sketch of a column with the given esp,\n      confidence and seed. The result is an array of bytes, which can be deserialized to a\n      `CountMinSketch` before usage. Count-min sketch is a probabilistic data structure used for\n      cardinality estimation using sub-linear space.\n  ")
@ScalaSignature(bytes="\u0006\u0001\t\u0015f\u0001B\u0001\u0003\u0001F\u0011\u0011cQ8v]Rl\u0015N\\*lKR\u001c\u0007.Q4h\u0015\t\u0019A!A\u0005bO\u001e\u0014XmZ1uK*\u0011QAB\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\b\u0011\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\n\u0015\u0005\u00191/\u001d7\u000b\u0005-a\u0011!B:qCJ\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c\u0001aE\u0003\u0001%y\u0011\u0003\u0006E\u0002\u0014)Yi\u0011AA\u0005\u0003+\t\u0011\u0001\u0004V=qK\u0012LU\u000e]3sCRLg/Z!hOJ,w-\u0019;f!\t9B$D\u0001\u0019\u0015\tI\"$\u0001\u0004tW\u0016$8\r\u001b\u0006\u00037)\tA!\u001e;jY&\u0011Q\u0004\u0007\u0002\u000f\u0007>,h\u000e^'j]N[W\r^2i!\ty\u0002%D\u0001\u0005\u0013\t\tCAA\tFqB,7\r^:J]B,H\u000fV=qKN\u0004\"a\t\u0014\u000e\u0003\u0011R\u0011!J\u0001\u0006g\u000e\fG.Y\u0005\u0003O\u0011\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002$S%\u0011!\u0006\n\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\tY\u0001\u0011)\u001a!C\u0001[\u0005)1\r[5mIV\ta\u0006\u0005\u0002 _%\u0011\u0001\u0007\u0002\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007\u0002\u0003\u001a\u0001\u0005#\u0005\u000b\u0011\u0002\u0018\u0002\r\rD\u0017\u000e\u001c3!\u0011!!\u0004A!f\u0001\n\u0003i\u0013!D3qg\u0016C\bO]3tg&|g\u000e\u0003\u00057\u0001\tE\t\u0015!\u0003/\u00039)\u0007o]#yaJ,7o]5p]\u0002B\u0001\u0002\u000f\u0001\u0003\u0016\u0004%\t!L\u0001\u0015G>tg-\u001b3f]\u000e,W\t\u001f9sKN\u001c\u0018n\u001c8\t\u0011i\u0002!\u0011#Q\u0001\n9\nQcY8oM&$WM\\2f\u000bb\u0004(/Z:tS>t\u0007\u0005\u0003\u0005=\u0001\tU\r\u0011\"\u0001.\u00039\u0019X-\u001a3FqB\u0014Xm]:j_:D\u0001B\u0010\u0001\u0003\u0012\u0003\u0006IAL\u0001\u0010g\u0016,G-\u0012=qe\u0016\u001c8/[8oA!A\u0001\t\u0001BK\u0002\u0013\u0005\u0013)\u0001\fnkR\f'\r\\3BO\u001e\u0014UO\u001a4fe>3gm]3u+\u0005\u0011\u0005CA\u0012D\u0013\t!EEA\u0002J]RD\u0001B\u0012\u0001\u0003\u0012\u0003\u0006IAQ\u0001\u0018[V$\u0018M\u00197f\u0003\u001e<')\u001e4gKJ|eMZ:fi\u0002B\u0001\u0002\u0013\u0001\u0003\u0016\u0004%\t%Q\u0001\u0015S:\u0004X\u000f^!hO\n+hMZ3s\u001f\u001a47/\u001a;\t\u0011)\u0003!\u0011#Q\u0001\n\t\u000bQ#\u001b8qkR\fum\u001a\"vM\u001a,'o\u00144gg\u0016$\b\u0005C\u0003M\u0001\u0011\u0005Q*\u0001\u0004=S:LGO\u0010\u000b\b\u001d>\u0003\u0016KU*U!\t\u0019\u0002\u0001C\u0003-\u0017\u0002\u0007a\u0006C\u00035\u0017\u0002\u0007a\u0006C\u00039\u0017\u0002\u0007a\u0006C\u0003=\u0017\u0002\u0007a\u0006C\u0003A\u0017\u0002\u0007!\tC\u0003I\u0017\u0002\u0007!\tC\u0003M\u0001\u0011\u0005a\u000bF\u0003O/bK&\fC\u0003-+\u0002\u0007a\u0006C\u00035+\u0002\u0007a\u0006C\u00039+\u0002\u0007a\u0006C\u0003=+\u0002\u0007a\u0006\u0003\u0005]\u0001!\u0015\r\u0011\"\u0003^\u0003\r)\u0007o]\u000b\u0002=B\u00111eX\u0005\u0003A\u0012\u0012a\u0001R8vE2,\u0007\u0002\u00032\u0001\u0011\u0003\u0005\u000b\u0015\u00020\u0002\t\u0015\u00048\u000f\t\u0005\tI\u0002A)\u0019!C\u0005;\u0006Q1m\u001c8gS\u0012,gnY3\t\u0011\u0019\u0004\u0001\u0012!Q!\ny\u000b1bY8oM&$WM\\2fA!A\u0001\u000e\u0001EC\u0002\u0013%\u0011)\u0001\u0003tK\u0016$\u0007\u0002\u00036\u0001\u0011\u0003\u0005\u000b\u0015\u0002\"\u0002\u000bM,W\r\u001a\u0011\t\u000b1\u0004A\u0011I7\u0002'\rDWmY6J]B,H\u000fR1uCRK\b/Z:\u0015\u00039\u0004\"a\u001c:\u000e\u0003AT!!\u001d\u0004\u0002\u0011\u0005t\u0017\r\\=tSNL!a\u001d9\u0003\u001fQK\b/Z\"iK\u000e\\'+Z:vYRDQ!\u001e\u0001\u0005BY\fqc\u0019:fCR,\u0017iZ4sK\u001e\fG/[8o\u0005V4g-\u001a:\u0015\u0003YAQ\u0001\u001f\u0001\u0005Be\fa!\u001e9eCR,Gc\u0001\f{y\")1p\u001ea\u0001-\u00051!-\u001e4gKJDQ!`<A\u0002y\fQ!\u001b8qkR\u00042a`A\u0001\u001b\u00051\u0011bAA\u0002\r\tY\u0011J\u001c;fe:\fGNU8x\u0011\u001d\t9\u0001\u0001C!\u0003\u0013\tQ!\\3sO\u0016$RAFA\u0006\u0003\u001bAaa_A\u0003\u0001\u00041\u0002BB?\u0002\u0006\u0001\u0007a\u0003C\u0004\u0002\u0012\u0001!\t%a\u0005\u0002\t\u00154\u0018\r\u001c\u000b\u0005\u0003+\tY\u0002E\u0002$\u0003/I1!!\u0007%\u0005\r\te.\u001f\u0005\u0007w\u0006=\u0001\u0019\u0001\f\t\u000f\u0005}\u0001\u0001\"\u0011\u0002\"\u0005I1/\u001a:jC2L'0\u001a\u000b\u0005\u0003G\ty\u0003E\u0003$\u0003K\tI#C\u0002\u0002(\u0011\u0012Q!\u0011:sCf\u00042aIA\u0016\u0013\r\ti\u0003\n\u0002\u0005\u0005f$X\r\u0003\u0004|\u0003;\u0001\rA\u0006\u0005\b\u0003g\u0001A\u0011IA\u001b\u0003-!Wm]3sS\u0006d\u0017N_3\u0015\u0007Y\t9\u0004\u0003\u0005\u0002:\u0005E\u0002\u0019AA\u0012\u00035\u0019Ho\u001c:bO\u00164uN]7bi\"9\u0011Q\b\u0001\u0005B\u0005}\u0012!H<ji\"tUm^'vi\u0006\u0014G.Z!hO\n+hMZ3s\u001f\u001a47/\u001a;\u0015\u00079\u000b\t\u0005C\u0004\u0002D\u0005m\u0002\u0019\u0001\"\u000239,w/T;uC\ndW-Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r\u001e\u0005\b\u0003\u000f\u0002A\u0011IA%\u0003m9\u0018\u000e\u001e5OK^Le\u000e];u\u0003\u001e<')\u001e4gKJ|eMZ:fiR\u0019a*a\u0013\t\u000f\u00055\u0013Q\ta\u0001\u0005\u00069b.Z<J]B,H/Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r\u001e\u0005\b\u0003#\u0002A\u0011IA*\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u0003\u0003+\u0002b!a\u0016\u0002h\u00055d\u0002BA-\u0003GrA!a\u0017\u0002b5\u0011\u0011Q\f\u0006\u0004\u0003?\u0002\u0012A\u0002\u001fs_>$h(C\u0001&\u0013\r\t)\u0007J\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tI'a\u001b\u0003\u0007M+\u0017OC\u0002\u0002f\u0011\u0002B!a\u001c\u0002v5\u0011\u0011\u0011\u000f\u0006\u0004\u0003gB\u0011!\u0002;za\u0016\u001c\u0018\u0002BA<\u0003c\u0012\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\t\u000f\u0005m\u0004\u0001\"\u0011\u0002~\u0005Aa.\u001e7mC\ndW-\u0006\u0002\u0002\u0000A\u00191%!!\n\u0007\u0005\rEEA\u0004C_>dW-\u00198\t\u000f\u0005\u001d\u0005\u0001\"\u0011\u0002\n\u0006AA-\u0019;b)f\u0004X-\u0006\u0002\u0002\fB!\u0011qNAG\u0013\u0011\ty)!\u001d\u0003\u0011\u0011\u000bG/\u0019+za\u0016Dq!a%\u0001\t\u0003\n)*A\u0007eK\u001a\fW\u000f\u001c;SKN,H\u000e^\u000b\u0003\u0003/\u0003RaIAM\u0003;K1!a'%\u0005\u0019y\u0005\u000f^5p]B\u0019q$a(\n\u0007\u0005\u0005FAA\u0004MSR,'/\u00197\t\u000f\u0005\u0015\u0006\u0001\"\u0011\u0002(\u0006A1\r[5mIJ,g.\u0006\u0002\u0002*B)\u0011qKA4]!9\u0011Q\u0016\u0001\u0005B\u0005=\u0016A\u00039sKR$\u0018PT1nKV\u0011\u0011\u0011\u0017\t\u0005\u0003g\u000bILD\u0002$\u0003kK1!a.%\u0003\u0019\u0001&/\u001a3fM&!\u00111XA_\u0005\u0019\u0019FO]5oO*\u0019\u0011q\u0017\u0013\t\u0013\u0005\u0005\u0007!!A\u0005\u0002\u0005\r\u0017\u0001B2paf$RBTAc\u0003\u000f\fI-a3\u0002N\u0006=\u0007\u0002\u0003\u0017\u0002@B\u0005\t\u0019\u0001\u0018\t\u0011Q\ny\f%AA\u00029B\u0001\u0002OA`!\u0003\u0005\rA\f\u0005\ty\u0005}\u0006\u0013!a\u0001]!A\u0001)a0\u0011\u0002\u0003\u0007!\t\u0003\u0005I\u0003\u007f\u0003\n\u00111\u0001C\u0011%\t\u0019\u000eAI\u0001\n\u0003\t).\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005]'f\u0001\u0018\u0002Z.\u0012\u00111\u001c\t\u0005\u0003;\f9/\u0004\u0002\u0002`*!\u0011\u0011]Ar\u0003%)hn\u00195fG.,GMC\u0002\u0002f\u0012\n!\"\u00198o_R\fG/[8o\u0013\u0011\tI/a8\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0002n\u0002\t\n\u0011\"\u0001\u0002V\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0004\"CAy\u0001E\u0005I\u0011AAk\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIMB\u0011\"!>\u0001#\u0003%\t!!6\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%i!I\u0011\u0011 \u0001\u0012\u0002\u0013\u0005\u00111`\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00136+\t\tiPK\u0002C\u00033D\u0011B!\u0001\u0001#\u0003%\t!a?\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%m!I!Q\u0001\u0001\u0002\u0002\u0013\u0005#qA\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\t%\u0001\u0003\u0002B\u0006\u0005+i!A!\u0004\u000b\t\t=!\u0011C\u0001\u0005Y\u0006twM\u0003\u0002\u0003\u0014\u0005!!.\u0019<b\u0013\u0011\tYL!\u0004\t\u0011\te\u0001!!A\u0005\u0002\u0005\u000bA\u0002\u001d:pIV\u001cG/\u0011:jifD\u0011B!\b\u0001\u0003\u0003%\tAa\b\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011Q\u0003B\u0011\u0011%\u0011\u0019Ca\u0007\u0002\u0002\u0003\u0007!)A\u0002yIEB\u0011Ba\n\u0001\u0003\u0003%\tE!\u000b\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"Aa\u000b\u0011\r\t5\"1GA\u000b\u001b\t\u0011yCC\u0002\u00032\u0011\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011)Da\f\u0003\u0011%#XM]1u_JD\u0011B!\u000f\u0001\u0003\u0003%\tAa\u000f\u0002\u0011\r\fg.R9vC2$B!a \u0003>!Q!1\u0005B\u001c\u0003\u0003\u0005\r!!\u0006\t\u0013\t\u0005\u0003!!A\u0005B\t\r\u0013AB3rk\u0006d7\u000f\u0006\u0003\u0002\u0000\t\u0015\u0003B\u0003B\u0012\u0005\u007f\t\t\u00111\u0001\u0002\u0016!:\u0001A!\u0013\u0003P\tE\u0003cA\u0010\u0003L%\u0019!Q\n\u0003\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012!1K\u0001\u00032*\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015d_2d\u0003%\u001a9tY\u0001\u001awN\u001c4jI\u0016t7-\u001a\u0017!g\u0016,G-\u000b\u0011.AI+G/\u001e:og\u0002\n\u0007eY8v]RlS.\u001b8!g.,Go\u00195!_\u001a\u0004\u0013\rI2pYVlg\u000eI<ji\"\u0004C\u000f[3!O&4XM\u001c\u0011fgBd#\u0002\t\u0011!A\u0001\u00023m\u001c8gS\u0012,gnY3!C:$\u0007e]3fI:\u0002C\u000b[3!e\u0016\u001cX\u000f\u001c;!SN\u0004\u0013M\u001c\u0011beJ\f\u0017\u0010I8gA\tLH/Z:-A]D\u0017n\u00195!G\u0006t\u0007EY3!I\u0016\u001cXM]5bY&TX\r\u001a\u0011u_\u0002\n'\u0002\t\u0011!A\u0001\u0002\u0003mQ8v]Rl\u0015N\\*lKR\u001c\u0007\u000e\u0019\u0011cK\u001a|'/\u001a\u0011vg\u0006<WM\f\u0011D_VtG/L7j]\u0002\u001a8.\u001a;dQ\u0002J7\u000fI1!aJ|'-\u00192jY&\u001cH/[2!I\u0006$\u0018\rI:ueV\u001cG/\u001e:fAU\u001cX\r\u001a\u0011g_JT\u0001\u0005\t\u0011!A\u0001\u001a\u0017M\u001d3j]\u0006d\u0017\u000e^=!KN$\u0018.\\1uS>t\u0007%^:j]\u001e\u00043/\u001e2.Y&tW-\u0019:!gB\f7-\u001a\u0018\u000bA\u0001:\u0011Ba\u0016\u0003\u0003\u0003E\tA!\u0017\u0002#\r{WO\u001c;NS:\u001c6.\u001a;dQ\u0006;w\rE\u0002\u0014\u000572\u0001\"\u0001\u0002\u0002\u0002#\u0005!QL\n\u0006\u00057\u0012y\u0006\u000b\t\f\u0005C\u00129G\f\u0018/]\t\u0013e*\u0004\u0002\u0003d)\u0019!Q\r\u0013\u0002\u000fI,h\u000e^5nK&!!\u0011\u000eB2\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\u000e\u0005\b\u0019\nmC\u0011\u0001B7)\t\u0011I\u0006\u0003\u0006\u0003r\tm\u0013\u0011!C#\u0005g\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0005\u0013A!Ba\u001e\u0003\\\u0005\u0005I\u0011\u0011B=\u0003\u0015\t\u0007\u000f\u001d7z)5q%1\u0010B?\u0005\u007f\u0012\tIa!\u0003\u0006\"1AF!\u001eA\u00029Ba\u0001\u000eB;\u0001\u0004q\u0003B\u0002\u001d\u0003v\u0001\u0007a\u0006\u0003\u0004=\u0005k\u0002\rA\f\u0005\u0007\u0001\nU\u0004\u0019\u0001\"\t\r!\u0013)\b1\u0001C\u0011)\u0011IIa\u0017\u0002\u0002\u0013\u0005%1R\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011iI!&\u0011\u000b\r\nIJa$\u0011\u0013\r\u0012\tJ\f\u0018/]\t\u0013\u0015b\u0001BJI\t1A+\u001e9mKZB\u0011Ba&\u0003\b\u0006\u0005\t\u0019\u0001(\u0002\u0007a$\u0003\u0007\u0003\u0006\u0003\u001c\nm\u0013\u0011!C\u0005\u0005;\u000b1B]3bIJ+7o\u001c7wKR\u0011!q\u0014\t\u0005\u0005\u0017\u0011\t+\u0003\u0003\u0003$\n5!AB(cU\u0016\u001cG\u000f")
public class CountMinSketchAgg
extends TypedImperativeAggregate<CountMinSketch>
implements ExpectsInputTypes,
Serializable {
    private final Expression child;
    private final Expression epsExpression;
    private final Expression confidenceExpression;
    private final Expression seedExpression;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private double eps;
    private double confidence;
    private int seed;
    private volatile byte bitmap$0;

    public static Option<Tuple6<Expression, Expression, Expression, Expression, Object, Object>> unapply(CountMinSketchAgg countMinSketchAgg) {
        return CountMinSketchAgg$.MODULE$.unapply(countMinSketchAgg);
    }

    public static Function1<Tuple6<Expression, Expression, Expression, Expression, Object, Object>, CountMinSketchAgg> tupled() {
        return CountMinSketchAgg$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, Function1<Object, Function1<Object, CountMinSketchAgg>>>>>> curried() {
        return CountMinSketchAgg$.MODULE$.curried();
    }

    private double eps$lzycompute() {
        CountMinSketchAgg countMinSketchAgg = this;
        synchronized (countMinSketchAgg) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.eps = BoxesRunTime.unboxToDouble((Object)this.epsExpression().eval(this.epsExpression().eval$default$1()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.eps;
        }
    }

    private double confidence$lzycompute() {
        CountMinSketchAgg countMinSketchAgg = this;
        synchronized (countMinSketchAgg) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.confidence = BoxesRunTime.unboxToDouble((Object)this.confidenceExpression().eval(this.confidenceExpression().eval$default$1()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.confidence;
        }
    }

    private int seed$lzycompute() {
        CountMinSketchAgg countMinSketchAgg = this;
        synchronized (countMinSketchAgg) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.seed = BoxesRunTime.unboxToInt((Object)this.seedExpression().eval(this.seedExpression().eval$default$1()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.seed;
        }
    }

    public Expression child() {
        return this.child;
    }

    public Expression epsExpression() {
        return this.epsExpression;
    }

    public Expression confidenceExpression() {
        return this.confidenceExpression;
    }

    public Expression seedExpression() {
        return this.seedExpression;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    private double eps() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.eps$lzycompute() : this.eps;
    }

    private double confidence() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.confidence$lzycompute() : this.confidence;
    }

    private int seed() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.seed$lzycompute() : this.seed;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult defaultCheck = ExpectsInputTypes$class.checkInputDataTypes(this);
        return defaultCheck.isFailure() ? defaultCheck : (this.epsExpression().foldable() && this.confidenceExpression().foldable() && this.seedExpression().foldable() ? (this.epsExpression().eval(this.epsExpression().eval$default$1()) == null || this.confidenceExpression().eval(this.confidenceExpression().eval$default$1()) == null || this.seedExpression().eval(this.seedExpression().eval$default$1()) == null ? new TypeCheckResult.TypeCheckFailure("The eps, confidence or seed provided should not be null") : (this.eps() <= 0.0 ? new TypeCheckResult.TypeCheckFailure(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Relative error must be positive (current value = ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.eps())}))) : (this.confidence() <= 0.0 || this.confidence() >= 1.0 ? new TypeCheckResult.TypeCheckFailure(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Confidence must be within range (0.0, 1.0) (current value = ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.confidence())}))) : TypeCheckResult$TypeCheckSuccess$.MODULE$))) : new TypeCheckResult.TypeCheckFailure("The eps, confidence or seed provided must be a literal or foldable"));
    }

    @Override
    public CountMinSketch createAggregationBuffer() {
        return CountMinSketch.create((double)this.eps(), (double)this.confidence(), (int)this.seed());
    }

    @Override
    public CountMinSketch update(CountMinSketch buffer, InternalRow input) {
        Object value2 = this.child().eval(input);
        if (value2 != null) {
            DataType dataType2 = this.child().dataType();
            if (StringType$.MODULE$.equals(dataType2)) {
                buffer.addBinary(((UTF8String)value2).getBytes());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                buffer.add(value2);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
        return buffer;
    }

    @Override
    public CountMinSketch merge(CountMinSketch buffer, CountMinSketch input) {
        buffer.mergeInPlace(input);
        return buffer;
    }

    @Override
    public Object eval(CountMinSketch buffer) {
        return this.serialize(buffer);
    }

    @Override
    public byte[] serialize(CountMinSketch buffer) {
        return buffer.toByteArray();
    }

    @Override
    public CountMinSketch deserialize(byte[] storageFormat) {
        return CountMinSketch.readFrom((byte[])storageFormat);
    }

    @Override
    public CountMinSketchAgg withNewMutableAggBufferOffset(int newMutableAggBufferOffset) {
        int x$1 = newMutableAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        Expression x$5 = this.copy$default$4();
        int x$6 = this.copy$default$6();
        return this.copy(x$2, x$3, x$4, x$5, x$1, x$6);
    }

    @Override
    public CountMinSketchAgg withNewInputAggBufferOffset(int newInputAggBufferOffset) {
        int x$7 = newInputAggBufferOffset;
        Expression x$8 = this.copy$default$1();
        Expression x$9 = this.copy$default$2();
        Expression x$10 = this.copy$default$3();
        Expression x$11 = this.copy$default$4();
        int x$12 = this.copy$default$5();
        return this.copy(x$8, x$9, x$10, x$11, x$12, x$7);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{IntegralType$.MODULE$, StringType$.MODULE$, BinaryType$.MODULE$})), DoubleType$.MODULE$, DoubleType$.MODULE$, IntegerType$.MODULE$}));
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public DataType dataType() {
        return BinaryType$.MODULE$;
    }

    @Override
    public Option<Literal> defaultResult() {
        return Option$.MODULE$.apply((Object)Literal$.MODULE$.create(this.eval(this.createAggregationBuffer()), this.dataType()));
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.child(), this.epsExpression(), this.confidenceExpression(), this.seedExpression()}));
    }

    @Override
    public String prettyName() {
        return "count_min_sketch";
    }

    public CountMinSketchAgg copy(Expression child, Expression epsExpression, Expression confidenceExpression, Expression seedExpression, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new CountMinSketchAgg(child, epsExpression, confidenceExpression, seedExpression, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Expression copy$default$2() {
        return this.epsExpression();
    }

    public Expression copy$default$3() {
        return this.confidenceExpression();
    }

    public Expression copy$default$4() {
        return this.seedExpression();
    }

    public int copy$default$5() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$6() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "CountMinSketchAgg";
    }

    public int productArity() {
        return 6;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 5: {
                object = BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
                break;
            }
            case 4: {
                object = BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
                break;
            }
            case 3: {
                object = this.seedExpression();
                break;
            }
            case 2: {
                object = this.confidenceExpression();
                break;
            }
            case 1: {
                object = this.epsExpression();
                break;
            }
            case 0: {
                object = this.child();
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CountMinSketchAgg;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CountMinSketchAgg)) return false;
        boolean bl = true;
        if (!bl) return false;
        CountMinSketchAgg countMinSketchAgg = (CountMinSketchAgg)x$1;
        Expression expression = this.child();
        Expression expression2 = countMinSketchAgg.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.epsExpression();
        Expression expression4 = countMinSketchAgg.epsExpression();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.confidenceExpression();
        Expression expression6 = countMinSketchAgg.confidenceExpression();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        Expression expression7 = this.seedExpression();
        Expression expression8 = countMinSketchAgg.seedExpression();
        if (expression7 == null) {
            if (expression8 != null) {
                return false;
            }
        } else if (!expression7.equals(expression8)) return false;
        if (this.mutableAggBufferOffset() != countMinSketchAgg.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != countMinSketchAgg.inputAggBufferOffset()) return false;
        if (!countMinSketchAgg.canEqual(this)) return false;
        return true;
    }

    public CountMinSketchAgg(Expression child, Expression epsExpression, Expression confidenceExpression, Expression seedExpression, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.child = child;
        this.epsExpression = epsExpression;
        this.confidenceExpression = confidenceExpression;
        this.seedExpression = seedExpression;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
        ExpectsInputTypes$class.$init$(this);
    }

    public CountMinSketchAgg(Expression child, Expression epsExpression, Expression confidenceExpression, Expression seedExpression) {
        this(child, epsExpression, confidenceExpression, seedExpression, 0, 0);
    }
}

