/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.csv;

import com.univocity.parsers.csv.CsvParser;
import com.univocity.parsers.csv.CsvParserSettings;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import org.apache.spark.SparkUpgradeException;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.NoopFilters;
import org.apache.spark.sql.catalyst.OrderedFilters;
import org.apache.spark.sql.catalyst.StructFilters;
import org.apache.spark.sql.catalyst.csv.CSVHeaderChecker;
import org.apache.spark.sql.catalyst.csv.CSVOptions;
import org.apache.spark.sql.catalyst.csv.UnivocityParser$;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.package$;
import org.apache.spark.sql.catalyst.util.BadRecordException;
import org.apache.spark.sql.catalyst.util.DateFormatter;
import org.apache.spark.sql.catalyst.util.DateFormatter$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.catalyst.util.LegacyDateFormats$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.unsafe.types.UTF8String;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\tEg\u0001\u0002\u0017.\u0001iB\u0001b\u0012\u0001\u0003\u0002\u0003\u0006I\u0001\u0013\u0005\t\u001d\u0002\u0011\t\u0011)A\u0005\u0011\"Aq\n\u0001BC\u0002\u0013\u0005\u0001\u000b\u0003\u0005V\u0001\t\u0005\t\u0015!\u0003R\u0011!1\u0006A!A!\u0002\u00139\u0006\"B5\u0001\t\u0003Q\u0007\"B5\u0001\t\u0003\u0001\b\"B5\u0001\t\u0003!X\u0001\u0002=\u0001\teD\u0011\"a\u0004\u0001\u0005\u0004%I!!\u0005\t\u0011\u0005%\u0002\u0001)A\u0005\u0003'A\u0011\"a\u000b\u0001\u0005\u0004%I!!\f\t\u000f\u0005=\u0002\u0001)A\u0005\u0011\"I\u0011\u0011\u0007\u0001C\u0002\u0013\u0005\u00111\u0007\u0005\t\u0003\u0017\u0002\u0001\u0015!\u0003\u00026!I\u0011Q\n\u0001C\u0002\u0013%\u0011q\n\u0005\t\u0003G\u0002\u0001\u0015!\u0003\u0002R!I\u0011Q\r\u0001C\u0002\u0013%\u0011q\r\u0005\t\u0003_\u0002\u0001\u0015!\u0003\u0002j!Q\u0011\u0011\u000f\u0001\t\u0006\u0004%I!a\u001d\t\u0015\u0005\u0005\u0005\u0001#b\u0001\n\u0013\t\u0019\tC\u0005\u0002\f\u0002\u0011\r\u0011\"\u0003\u0002\u000e\"A\u0011q\u0013\u0001!\u0002\u0013\ty\tC\u0004\u0002\u001a\u0002!I!a'\t\u0013\u0005-\u0006A1A\u0005\n\u00055\u0006\u0002CA[\u0001\u0001\u0006I!a,\t\u0013\u0005]\u0006A1A\u0005\n\u0005e\u0006\u0002CAe\u0001\u0001\u0006I!a/\t\u000f\u0005-\u0007\u0001\"\u0001\u0002N\"I\u0011q\u001d\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u001e\u0005\b\u0003\u007f\u0004A\u0011\u0002B\u0001\u0011%\u0011\u0019\u0002\u0001b\u0001\n\u0003\u0011)\u0002\u0003\u0005\u0003&\u0001\u0001\u000b\u0011\u0002B\f\u0011%\u00119\u0003\u0001b\u0001\n\u0013\u0011I\u0003\u0003\u0005\u0003:\u0001\u0001\u000b\u0011\u0002B\u0016\u0011\u001d\u0011Y\u0004\u0001C\u0005\u0005{9\u0001Ba\u0011.\u0011\u0003\t$Q\t\u0004\bY5B\t!\rB$\u0011\u0019Ig\u0005\"\u0001\u0003J!9!1\n\u0014\u0005\u0002\t5\u0003b\u0002B8M\u0011\u0005!\u0011\u000f\u0005\b\u0005\u000f3C\u0011\u0002BE\u0011\u001d\u0011\tM\nC\u0001\u0005\u0007\u0014q\"\u00168jm>\u001c\u0017\u000e^=QCJ\u001cXM\u001d\u0006\u0003]=\n1aY:w\u0015\t\u0001\u0014'\u0001\u0005dCR\fG._:u\u0015\t\u00114'A\u0002tc2T!\u0001N\u001b\u0002\u000bM\u0004\u0018M]6\u000b\u0005Y:\u0014AB1qC\u000eDWMC\u00019\u0003\ry'oZ\u0002\u0001'\r\u00011(\u0011\t\u0003y}j\u0011!\u0010\u0006\u0002}\u0005)1oY1mC&\u0011\u0001)\u0010\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\t+U\"A\"\u000b\u0005\u0011\u001b\u0014\u0001C5oi\u0016\u0014h.\u00197\n\u0005\u0019\u001b%a\u0002'pO\u001eLgnZ\u0001\u000bI\u0006$\u0018mU2iK6\f\u0007CA%M\u001b\u0005Q%BA&2\u0003\u0015!\u0018\u0010]3t\u0013\ti%J\u0001\u0006TiJ,8\r\u001e+za\u0016\faB]3rk&\u0014X\rZ*dQ\u0016l\u0017-A\u0004paRLwN\\:\u0016\u0003E\u0003\"AU*\u000e\u00035J!\u0001V\u0017\u0003\u0015\r\u001bfk\u00149uS>t7/\u0001\u0005paRLwN\\:!\u0003\u001d1\u0017\u000e\u001c;feN\u00042\u0001\u00171d\u001d\tIfL\u0004\u0002[;6\t1L\u0003\u0002]s\u00051AH]8pizJ\u0011AP\u0005\u0003?v\nq\u0001]1dW\u0006<W-\u0003\u0002bE\n\u00191+Z9\u000b\u0005}k\u0004C\u00013h\u001b\u0005)'B\u000142\u0003\u001d\u0019x.\u001e:dKNL!\u0001[3\u0003\r\u0019KG\u000e^3s\u0003\u0019a\u0014N\\5u}Q)1\u000e\\7o_B\u0011!\u000b\u0001\u0005\u0006\u000f\u001a\u0001\r\u0001\u0013\u0005\u0006\u001d\u001a\u0001\r\u0001\u0013\u0005\u0006\u001f\u001a\u0001\r!\u0015\u0005\u0006-\u001a\u0001\ra\u0016\u000b\u0005WF\u00148\u000fC\u0003H\u000f\u0001\u0007\u0001\nC\u0003O\u000f\u0001\u0007\u0001\nC\u0003P\u000f\u0001\u0007\u0011\u000bF\u0002lk^DQA\u001e\u0005A\u0002!\u000baa]2iK6\f\u0007\"B(\t\u0001\u0004\t&A\u0004,bYV,7i\u001c8wKJ$XM\u001d\t\u0006yid\u0018\u0011B\u0005\u0003wv\u0012\u0011BR;oGRLwN\\\u0019\u0011\u0007u\f\u0019A\u0004\u0002\u007f\u007fB\u0011!,P\u0005\u0004\u0003\u0003i\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0006\u0005\u001d!AB*ue&twMC\u0002\u0002\u0002u\u00022\u0001PA\u0006\u0013\r\ti!\u0010\u0002\u0004\u0003:L\u0018!\u0004;pW\u0016t\u0017J\u001c3fq\u0006\u0013(/\u0006\u0002\u0002\u0014A)A(!\u0006\u0002\u001a%\u0019\u0011qC\u001f\u0003\u000b\u0005\u0013(/Y=\u0011\t\u0005m\u0011QE\u0007\u0003\u0003;QA!a\b\u0002\"\u0005!A.\u00198h\u0015\t\t\u0019#\u0001\u0003kCZ\f\u0017\u0002BA\u0014\u0003;\u0011q!\u00138uK\u001e,'/\u0001\bu_.,g.\u00138eKb\f%O\u001d\u0011\u0002\u0019A\f'o]3e'\u000eDW-\\1\u0016\u0003!\u000bQ\u0002]1sg\u0016$7k\u00195f[\u0006\u0004\u0013!\u0003;pW\u0016t\u0017N_3s+\t\t)\u0004\u0005\u0003\u00028\u0005\u001dSBAA\u001d\u0015\rq\u00131\b\u0006\u0005\u0003{\ty$A\u0004qCJ\u001cXM]:\u000b\t\u0005\u0005\u00131I\u0001\nk:Lgo\\2jifT!!!\u0012\u0002\u0007\r|W.\u0003\u0003\u0002J\u0005e\"!C\"tmB\u000b'o]3s\u0003)!xn[3oSj,'\u000fI\u0001\fe\u0016\fX/\u001b:fIJ{w/\u0006\u0002\u0002RA)A(a\u0015\u0002X%\u0019\u0011QK\u001f\u0003\tM{W.\u001a\t\u0005\u00033\ny&\u0004\u0002\u0002\\)\u0019\u0011QL\u0018\u0002\u0017\u0015D\bO]3tg&|gn]\u0005\u0005\u0003C\nYF\u0001\nHK:,'/[2J]R,'O\\1m%><\u0018\u0001\u0004:fcVL'/\u001a3S_^\u0004\u0013A\u00028p%><8/\u0006\u0002\u0002j9\u0019A(a\u001b\n\u0007\u00055T(\u0001\u0003O_:,\u0017a\u00028p%><8\u000fI\u0001\u0013i&lWm\u001d;b[B4uN]7biR,'/\u0006\u0002\u0002vA!\u0011qOA?\u001b\t\tIHC\u0002\u0002|=\nA!\u001e;jY&!\u0011qPA=\u0005I!\u0016.\\3ti\u0006l\u0007OR8s[\u0006$H/\u001a:\u0002\u001b\u0011\fG/\u001a$pe6\fG\u000f^3s+\t\t)\t\u0005\u0003\u0002x\u0005\u001d\u0015\u0002BAE\u0003s\u0012Q\u0002R1uK\u001a{'/\\1ui\u0016\u0014\u0018AC2tm\u001aKG\u000e^3sgV\u0011\u0011q\u0012\t\u0005\u0003#\u000b\u0019*D\u00010\u0013\r\t)j\f\u0002\u000e'R\u0014Xo\u0019;GS2$XM]:\u0002\u0017\r\u001chOR5mi\u0016\u00148\u000fI\u0001\u0010O\u0016$8)\u001e:sK:$\u0018J\u001c9viV\u0011\u0011Q\u0014\t\u0005\u0003?\u000b9+\u0004\u0002\u0002\"*\u00191*a)\u000b\u0007\u0005\u00156'\u0001\u0004v]N\fg-Z\u0005\u0005\u0003S\u000b\tK\u0001\u0006V)\u001aC4\u000b\u001e:j]\u001e\fqB^1mk\u0016\u001cuN\u001c<feR,'o]\u000b\u0003\u0003_\u0003R\u0001PA\u000b\u0003c\u00032!a-\n\u001b\u0005\u0001\u0011\u0001\u0005<bYV,7i\u001c8wKJ$XM]:!\u00035!WmY5nC2\u0004\u0016M]:feV\u0011\u00111\u0018\t\u0006yid\u0018Q\u0018\t\u0005\u0003\u007f\u000b)-\u0004\u0002\u0002B*!\u00111YA\u0011\u0003\u0011i\u0017\r\u001e5\n\t\u0005\u001d\u0017\u0011\u0019\u0002\u000b\u0005&<G)Z2j[\u0006d\u0017A\u00043fG&l\u0017\r\u001c)beN,'\u000fI\u0001\u000e[\u0006\\WmQ8om\u0016\u0014H/\u001a:\u0015\u0011\u0005E\u0016qZAj\u0003;Da!!5\u001e\u0001\u0004a\u0018\u0001\u00028b[\u0016Dq!!6\u001e\u0001\u0004\t9.\u0001\u0005eCR\fG+\u001f9f!\rI\u0015\u0011\\\u0005\u0004\u00037T%\u0001\u0003#bi\u0006$\u0016\u0010]3\t\u0013\u0005}W\u0004%AA\u0002\u0005\u0005\u0018\u0001\u00038vY2\f'\r\\3\u0011\u0007q\n\u0019/C\u0002\u0002fv\u0012qAQ8pY\u0016\fg.A\fnC.,7i\u001c8wKJ$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u00111\u001e\u0016\u0005\u0003C\fio\u000b\u0002\u0002pB!\u0011\u0011_A~\u001b\t\t\u0019P\u0003\u0003\u0002v\u0006]\u0018!C;oG\",7m[3e\u0015\r\tI0P\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u007f\u0003g\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00035qW\u000f\u001c7TC\u001a,G)\u0019;v[RQ!1\u0001B\u0005\u0005\u001b\u0011yA!\u0005\u0015\t\u0005%!Q\u0001\u0005\b\u0005\u000fy\u0002\u0019AAY\u0003%\u0019wN\u001c<feR,'\u000f\u0003\u0004\u0003\f}\u0001\r\u0001`\u0001\u0006I\u0006$X/\u001c\u0005\u0007\u0003#|\u0002\u0019\u0001?\t\u000f\u0005}w\u00041\u0001\u0002b\")qj\ba\u0001#\u0006)\u0001/\u0019:tKV\u0011!q\u0003\t\u0006yid(\u0011\u0004\t\u0006y\tm!qD\u0005\u0004\u0005;i$AB(qi&|g\u000e\u0005\u0003\u0002\u0012\n\u0005\u0012b\u0001B\u0012_\tY\u0011J\u001c;fe:\fGNU8x\u0003\u0019\u0001\u0018M]:fA\u0005Aq-\u001a;U_.,g.\u0006\u0002\u0003,AAAH!\f\u00032\tMB0C\u0002\u00030u\u0012\u0011BR;oGRLwN\u001c\u001a\u0011\tq\n)\u0002 \t\u0004y\tU\u0012b\u0001B\u001c{\t\u0019\u0011J\u001c;\u0002\u0013\u001d,G\u000fV8lK:\u0004\u0013aB2p]Z,'\u000f\u001e\u000b\u0005\u00053\u0011y\u0004C\u0004\u0003B\u0011\u0002\rA!\r\u0002\rQ|7.\u001a8t\u0003=)f.\u001b<pG&$\u0018\u0010U1sg\u0016\u0014\bC\u0001*''\t13\b\u0006\u0002\u0003F\u0005qAo\\6f]&TXm\u0015;sK\u0006lGC\u0003B(\u0005+\u0012)G!\u001b\u0003lA)\u0001L!\u0015\u00032%\u0019!1\u000b2\u0003\u0011%#XM]1u_JDqAa\u0016)\u0001\u0004\u0011I&A\u0006j]B,Ho\u0015;sK\u0006l\u0007\u0003\u0002B.\u0005Cj!A!\u0018\u000b\t\t}\u0013\u0011E\u0001\u0003S>LAAa\u0019\u0003^\tY\u0011J\u001c9viN#(/Z1n\u0011\u001d\u00119\u0007\u000ba\u0001\u0003C\f\u0001c\u001d5pk2$GI]8q\u0011\u0016\fG-\u001a:\t\u000f\u0005E\u0002\u00061\u0001\u00026!1!Q\u000e\u0015A\u0002q\f\u0001\"\u001a8d_\u0012LgnZ\u0001\fa\u0006\u00148/Z*ue\u0016\fW\u000e\u0006\u0006\u0003t\tU$q\u000fB>\u0005\u000b\u0003R\u0001\u0017B)\u0005?AqAa\u0016*\u0001\u0004\u0011I\u0006\u0003\u0004\u0003z%\u0002\ra[\u0001\u0007a\u0006\u00148/\u001a:\t\u000f\tu\u0014\u00061\u0001\u0003\u0000\u0005i\u0001.Z1eKJ\u001c\u0005.Z2lKJ\u00042A\u0015BA\u0013\r\u0011\u0019)\f\u0002\u0011\u0007N3\u0006*Z1eKJ\u001c\u0005.Z2lKJDQA^\u0015A\u0002!\u000bQbY8om\u0016\u0014Ho\u0015;sK\u0006lW\u0003\u0002BF\u00057#\"B!$\u0003,\n5&q\u0016B`)\u0011\u0011yIa*\u0013\u000b\tE5H!&\u0007\r\tM%\u0006\u0001BH\u00051a$/\u001a4j]\u0016lWM\u001c;?!\u0015A&\u0011\u000bBL!\u0011\u0011IJa'\r\u0001\u00119!Q\u0014\u0016C\u0002\t}%!\u0001+\u0012\t\t\u0005\u0016\u0011\u0002\t\u0004y\t\r\u0016b\u0001BS{\t9aj\u001c;iS:<\u0007b\u0002B\u001eU\u0001\u0007!\u0011\u0016\t\u0007yi\u0014\tDa&\t\u000f\t]#\u00061\u0001\u0003Z!9\u0011\u0011\u0007\u0016A\u0002\u0005U\u0002b\u0002BYU\u0001\u0007!1W\u0001\rQ\u0006tG\r\\3IK\u0006$WM\u001d\t\u0006y\tU&\u0011X\u0005\u0004\u0005ok$!\u0003$v]\u000e$\u0018n\u001c81!\ra$1X\u0005\u0004\u0005{k$\u0001B+oSRDaA!\u001c+\u0001\u0004a\u0018!\u00049beN,\u0017\n^3sCR|'\u000f\u0006\u0006\u0003t\t\u0015'1\u001aBg\u0005\u001fDqAa2,\u0001\u0004\u0011I-A\u0003mS:,7\u000f\u0005\u0003Y\u0005#b\bB\u0002B=W\u0001\u00071\u000eC\u0004\u0003~-\u0002\rAa \t\u000bY\\\u0003\u0019\u0001%")
public class UnivocityParser
implements Logging {
    private TimestampFormatter timestampFormatter;
    private DateFormatter dateFormatter;
    private final StructType dataSchema;
    private final StructType requiredSchema;
    private final CSVOptions options;
    private final Integer[] tokenIndexArr;
    private final StructType parsedSchema;
    private final CsvParser tokenizer;
    private final Some<GenericInternalRow> requiredRow;
    private final None$ noRows;
    private final StructFilters csvFilters;
    private final Function1<String, Object>[] valueConverters;
    private final Function1<String, BigDecimal> decimalParser;
    private final Function1<String, Option<InternalRow>> parse;
    private final Function2<String[], Object, String> getToken;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public static Iterator<InternalRow> parseIterator(Iterator<String> iterator, UnivocityParser univocityParser, CSVHeaderChecker cSVHeaderChecker, StructType structType) {
        return UnivocityParser$.MODULE$.parseIterator(iterator, univocityParser, cSVHeaderChecker, structType);
    }

    public static Iterator<InternalRow> parseStream(InputStream inputStream, UnivocityParser univocityParser, CSVHeaderChecker cSVHeaderChecker, StructType structType) {
        return UnivocityParser$.MODULE$.parseStream(inputStream, univocityParser, cSVHeaderChecker, structType);
    }

    public static Iterator<String[]> tokenizeStream(InputStream inputStream, boolean bl, CsvParser csvParser, String string) {
        return UnivocityParser$.MODULE$.tokenizeStream(inputStream, bl, csvParser, string);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public CSVOptions options() {
        return this.options;
    }

    private Integer[] tokenIndexArr() {
        return this.tokenIndexArr;
    }

    private StructType parsedSchema() {
        return this.parsedSchema;
    }

    public CsvParser tokenizer() {
        return this.tokenizer;
    }

    private Some<GenericInternalRow> requiredRow() {
        return this.requiredRow;
    }

    private None$ noRows() {
        return this.noRows;
    }

    private TimestampFormatter timestampFormatter$lzycompute() {
        UnivocityParser univocityParser = this;
        synchronized (univocityParser) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.timestampFormatter = TimestampFormatter$.MODULE$.apply(this.options().timestampFormat(), this.options().zoneId(), this.options().locale(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), true);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.timestampFormatter;
    }

    private TimestampFormatter timestampFormatter() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.timestampFormatter$lzycompute() : this.timestampFormatter;
    }

    private DateFormatter dateFormatter$lzycompute() {
        UnivocityParser univocityParser = this;
        synchronized (univocityParser) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.dateFormatter = DateFormatter$.MODULE$.apply(this.options().dateFormat(), this.options().locale(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), true);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.dateFormatter;
    }

    private DateFormatter dateFormatter() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.dateFormatter$lzycompute() : this.dateFormatter;
    }

    private StructFilters csvFilters() {
        return this.csvFilters;
    }

    private UTF8String getCurrentInput() {
        String currentContent = this.tokenizer().getContext().currentParsedContent();
        return currentContent == null ? null : UTF8String.fromString((String)new StringOps(Predef$.MODULE$.augmentString(currentContent)).stripLineEnd());
    }

    private Function1<String, Object>[] valueConverters() {
        return this.valueConverters;
    }

    private Function1<String, BigDecimal> decimalParser() {
        return this.decimalParser;
    }

    public Function1<String, Object> makeConverter(String name, DataType dataType, boolean nullable) {
        Function1<String, Object> function1;
        DataType dataType2 = dataType;
        if (dataType2 instanceof ByteType) {
            function1 = d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToByte((byte)UnivocityParser.$anonfun$makeConverter$2(x$1)));
        } else if (dataType2 instanceof ShortType) {
            function1 = d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToShort((short)UnivocityParser.$anonfun$makeConverter$4(x$2)));
        } else if (dataType2 instanceof IntegerType) {
            function1 = d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)UnivocityParser.$anonfun$makeConverter$6(x$3)));
        } else if (dataType2 instanceof LongType) {
            function1 = d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)UnivocityParser.$anonfun$makeConverter$8(x$4)));
        } else if (dataType2 instanceof FloatType) {
            function1 = d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable & scala.Serializable)x0$1 -> {
                Float f;
                String string = x0$1;
                String string2 = this.options().nanValue();
                String string3 = string;
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    f = BoxesRunTime.boxToFloat((float)Float.NaN);
                } else {
                    String string4 = this.options().negativeInf();
                    String string5 = string;
                    if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                        f = BoxesRunTime.boxToFloat((float)Float.NEGATIVE_INFINITY);
                    } else {
                        String string6 = this.options().positiveInf();
                        String string7 = string;
                        f = !(string6 != null ? !string6.equals(string7) : string7 != null) ? BoxesRunTime.boxToFloat((float)Float.POSITIVE_INFINITY) : BoxesRunTime.boxToFloat((float)new StringOps(Predef$.MODULE$.augmentString(string)).toFloat());
                    }
                }
                return f;
            });
        } else if (dataType2 instanceof DoubleType) {
            function1 = d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable & scala.Serializable)x0$2 -> {
                Double d;
                String string = x0$2;
                String string2 = this.options().nanValue();
                String string3 = string;
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    d = BoxesRunTime.boxToDouble((double)Double.NaN);
                } else {
                    String string4 = this.options().negativeInf();
                    String string5 = string;
                    if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                        d = BoxesRunTime.boxToDouble((double)Double.NEGATIVE_INFINITY);
                    } else {
                        String string6 = this.options().positiveInf();
                        String string7 = string;
                        d = !(string6 != null ? !string6.equals(string7) : string7 != null) ? BoxesRunTime.boxToDouble((double)Double.POSITIVE_INFINITY) : BoxesRunTime.boxToDouble((double)new StringOps(Predef$.MODULE$.augmentString(string)).toDouble());
                    }
                }
                return d;
            });
        } else if (dataType2 instanceof BooleanType) {
            function1 = d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)UnivocityParser.$anonfun$makeConverter$14(x$5)));
        } else if (dataType2 instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType2;
            function1 = d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable & scala.Serializable)datum -> Decimal$.MODULE$.apply((BigDecimal)this.decimalParser().apply(datum), decimalType.precision(), decimalType.scale()));
        } else if (dataType2 instanceof TimestampType) {
            function1 = d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable & scala.Serializable)datum -> {
                Object object;
                try {
                    object = BoxesRunTime.boxToLong((long)this.timestampFormatter().parse((String)datum));
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    UTF8String str = DateTimeUtils$.MODULE$.cleanLegacyTimestampStr(UTF8String.fromString((String)datum));
                    Object object2 = DateTimeUtils$.MODULE$.stringToTimestamp(str, this.options().zoneId()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                        throw e;
                    });
                    object = object2;
                }
                return object;
            });
        } else if (dataType2 instanceof DateType) {
            function1 = d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable & scala.Serializable)datum -> {
                Object object;
                try {
                    object = BoxesRunTime.boxToInteger((int)this.dateFormatter().parse((String)datum));
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    UTF8String str = DateTimeUtils$.MODULE$.cleanLegacyTimestampStr(UTF8String.fromString((String)datum));
                    Object object2 = DateTimeUtils$.MODULE$.stringToDate(str).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                        throw e;
                    });
                    object = object2;
                }
                return object;
            });
        } else if (dataType2 instanceof StringType) {
            function1 = d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable & scala.Serializable)x$1 -> UTF8String.fromString((String)x$1));
        } else if (CalendarIntervalType$.MODULE$.equals(dataType2)) {
            function1 = d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable & scala.Serializable)datum -> IntervalUtils$.MODULE$.safeStringToInterval(UTF8String.fromString((String)datum)));
        } else if (dataType2 instanceof YearMonthIntervalType) {
            YearMonthIntervalType yearMonthIntervalType = (YearMonthIntervalType)dataType2;
            function1 = d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable & scala.Serializable)datum -> new Cast(Literal$.MODULE$.apply(datum), yearMonthIntervalType, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4()).eval(package$.MODULE$.EmptyRow()));
        } else if (dataType2 instanceof DayTimeIntervalType) {
            DayTimeIntervalType dayTimeIntervalType = (DayTimeIntervalType)dataType2;
            function1 = d -> this.nullSafeDatum((String)d, name, nullable, this.options(), (Function1<String, Object>)(Function1 & Serializable & scala.Serializable)datum -> new Cast(Literal$.MODULE$.apply(datum), dayTimeIntervalType, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4()).eval(package$.MODULE$.EmptyRow()));
        } else if (dataType2 instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            function1 = this.makeConverter(name, userDefinedType.sqlType(), nullable);
        } else {
            throw QueryExecutionErrors$.MODULE$.unsupportedTypeError(dataType);
        }
        return function1;
    }

    public boolean makeConverter$default$3() {
        return true;
    }

    private Object nullSafeDatum(String datum, String name, boolean nullable, CSVOptions options, Function1<String, Object> converter) {
        Object object;
        String string = datum;
        String string2 = options.nullValue();
        if (!(string == null ? string2 != null : !string.equals(string2)) || datum == null) {
            if (!nullable) {
                throw QueryExecutionErrors$.MODULE$.foundNullValueForNotNullableFieldError(name);
            }
            object = null;
        } else {
            object = converter.apply((Object)datum);
        }
        return object;
    }

    public Function1<String, Option<InternalRow>> parse() {
        return this.parse;
    }

    private Function2<String[], Object, String> getToken() {
        return this.getToken;
    }

    public Option<InternalRow> org$apache$spark$sql$catalyst$csv$UnivocityParser$$convert(String[] tokens) {
        Some<GenericInternalRow> some;
        if (tokens == null) {
            throw new BadRecordException((Function0<UTF8String>)(Function0 & Serializable & scala.Serializable)() -> this.getCurrentInput(), (Function0<Option<InternalRow>>)(Function0 & Serializable & scala.Serializable)() -> None$.MODULE$, QueryExecutionErrors$.MODULE$.malformedCSVRecordError());
        }
        None$ badRecordException = tokens.length != this.parsedSchema().length() ? new Some((Object)QueryExecutionErrors$.MODULE$.malformedCSVRecordError()) : None$.MODULE$;
        GenericInternalRow row = (GenericInternalRow)this.requiredRow().get();
        boolean skipRow = false;
        for (int i = 0; i < this.requiredSchema.length(); ++i) {
            try {
                if (skipRow) {
                    row.setNullAt(i);
                    continue;
                }
                row.update(i, this.valueConverters()[i].apply(this.getToken().apply((Object)tokens, (Object)BoxesRunTime.boxToInteger((int)i))));
                if (!this.csvFilters().skipRow(row, i)) continue;
                skipRow = true;
                continue;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof SparkUpgradeException) {
                    SparkUpgradeException sparkUpgradeException = (SparkUpgradeException)throwable2;
                    throw sparkUpgradeException;
                }
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    badRecordException = badRecordException.orElse((Function0 & Serializable & scala.Serializable)() -> new Some((Object)e));
                    row.setNullAt(i);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                throw throwable;
            }
        }
        if (skipRow) {
            some = this.noRows();
        } else {
            if (badRecordException.isDefined()) {
                throw new BadRecordException((Function0<UTF8String>)(Function0 & Serializable & scala.Serializable)() -> this.getCurrentInput(), (Function0<Option<InternalRow>>)(Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.option2Iterable(this.requiredRow()).headOption(), (Throwable)badRecordException.get());
            }
            some = this.requiredRow();
        }
        return some;
    }

    public static final /* synthetic */ byte $anonfun$makeConverter$2(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toByte();
    }

    public static final /* synthetic */ short $anonfun$makeConverter$4(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).toShort();
    }

    public static final /* synthetic */ int $anonfun$makeConverter$6(String x$3) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3)).toInt();
    }

    public static final /* synthetic */ long $anonfun$makeConverter$8(String x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$4)).toLong();
    }

    public static final /* synthetic */ boolean $anonfun$makeConverter$14(String x$5) {
        return new StringOps(Predef$.MODULE$.augmentString(x$5)).toBoolean();
    }

    public static final /* synthetic */ String $anonfun$getToken$1(String[] tokens, int index) {
        return tokens[index];
    }

    public static final /* synthetic */ String $anonfun$getToken$2(UnivocityParser $this, String[] tokens, int index) {
        return tokens[Predef$.MODULE$.Integer2int($this.tokenIndexArr()[index])];
    }

    public UnivocityParser(StructType dataSchema, StructType requiredSchema, CSVOptions options, Seq<Filter> filters) {
        this.dataSchema = dataSchema;
        this.requiredSchema = requiredSchema;
        this.options = options;
        Logging.$init$((Logging)this);
        Predef$.MODULE$.require(requiredSchema.toSet().subsetOf(dataSchema.toSet()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("requiredSchema (").append($this.requiredSchema.catalogString()).append(") should be the subset of ").append("dataSchema (").append($this.dataSchema.catalogString()).append(").").toString());
        this.tokenIndexArr = (Integer[])((TraversableOnce)requiredSchema.map((Function1 & Serializable & scala.Serializable)f -> $this.dataSchema.indexOf(f), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Integer.class));
        this.parsedSchema = options.columnPruning() ? requiredSchema : dataSchema;
        CsvParserSettings parserSetting = options.asParserSettings();
        Object object = this.parsedSchema().length() < dataSchema.length() ? parserSetting.selectIndexes(this.tokenIndexArr()) : BoxedUnit.UNIT;
        this.tokenizer = new CsvParser(parserSetting);
        this.requiredRow = new Some((Object)new GenericInternalRow(requiredSchema.length()));
        this.noRows = None$.MODULE$;
        this.csvFilters = SQLConf$.MODULE$.get().csvFilterPushDown() ? new OrderedFilters(filters, requiredSchema) : new NoopFilters();
        this.valueConverters = (Function1[])((TraversableOnce)requiredSchema.map((Function1 & Serializable & scala.Serializable)f -> this.makeConverter(f.name(), f.dataType(), f.nullable()), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Function1.class));
        this.decimalParser = ExprUtils$.MODULE$.getDecimalParser(options.locale());
        this.parse = options.columnPruning() && requiredSchema.isEmpty() ? (Function1 & Serializable & scala.Serializable)x$6 -> new Some((Object)InternalRow$.MODULE$.empty()) : (Function1 & Serializable & scala.Serializable)input -> this.org$apache$spark$sql$catalyst$csv$UnivocityParser$$convert(this.tokenizer().parseLine(input));
        this.getToken = options.columnPruning() ? (Function2 & Serializable & scala.Serializable)(tokens, index) -> UnivocityParser.$anonfun$getToken$1(tokens, BoxesRunTime.unboxToInt((Object)index)) : (Function2 & Serializable & scala.Serializable)(tokens, index) -> UnivocityParser.$anonfun$getToken$2(this, tokens, BoxesRunTime.unboxToInt((Object)index));
    }

    public UnivocityParser(StructType dataSchema, StructType requiredSchema, CSVOptions options) {
        this(dataSchema, requiredSchema, options, (Seq<Filter>)((Seq)Nil$.MODULE$));
    }

    public UnivocityParser(StructType schema, CSVOptions options) {
        this(schema, schema, options);
    }
}

