/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.io.Serializable;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.aggregate.HistogramNumeric$;
import org.apache.spark.sql.catalyst.expressions.aggregate.NumericHistogramSerializer$;
import org.apache.spark.sql.catalyst.expressions.aggregate.TypedImperativeAggregate;
import org.apache.spark.sql.catalyst.trees.BinaryLike;
import org.apache.spark.sql.catalyst.trees.SQLQueryContext;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NumericType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import org.apache.spark.sql.util.NumericHistogram;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(expr, nb) - Computes a histogram on numeric 'expr' using nb bins.\n      The return value is an array of (x,y) pairs representing the centers of the\n      histogram's bins. As the value of 'nb' is increased, the histogram approximation\n      gets finer-grained, but may yield artifacts around outliers. In practice, 20-40\n      histogram bins appear to work well, with more bins being required for skewed or\n      smaller datasets. Note that this function creates a histogram with non-uniform\n      bin widths. It offers no guarantees in terms of the mean-squared-error of the\n      histogram, but in practice is comparable to the histograms produced by the R/S-Plus\n      statistical computing packages. Note: the output type of the 'x' field in the return value is\n      propagated from the input value consumed in the aggregate function.\n    ", examples="\n    Examples:\n      > SELECT _FUNC_(col, 5) FROM VALUES (0), (1), (2), (10) AS tab(col);\n       [{\"x\":0,\"y\":1.0},{\"x\":1,\"y\":1.0},{\"x\":2,\"y\":1.0},{\"x\":10,\"y\":1.0}]\n  ", group="agg_funcs", since="3.3.0")
@ScalaSignature(bytes="\u0006\u0001\tEe\u0001B\u00181\u0001~B\u0001B\u001a\u0001\u0003\u0016\u0004%\ta\u001a\u0005\tQ\u0002\u0011\t\u0012)A\u0005)\"A\u0011\u000e\u0001BK\u0002\u0013\u0005q\r\u0003\u0005k\u0001\tE\t\u0015!\u0003U\u0011!Y\u0007A!f\u0001\n\u0003b\u0007\u0002\u00039\u0001\u0005#\u0005\u000b\u0011B7\t\u0011E\u0004!Q3A\u0005B1D\u0001B\u001d\u0001\u0003\u0012\u0003\u0006I!\u001c\u0005\u0006g\u0002!\t\u0001\u001e\u0005\u0006g\u0002!\tA\u001f\u0005\t{\u0002A)\u0019!C\u0005}\"Q\u0011Q\u0001\u0001\t\u0006\u0004%I!a\u0002\t\u000f\u0005=\u0001\u0001\"\u0011\u0002\u0012!9\u0011q\u0007\u0001\u0005B\u0005e\u0002bBA$\u0001\u0011\u0005\u0013\u0011\n\u0005\b\u0003\u0017\u0002A\u0011IA'\u0011\u001d\ty\u0006\u0001C!\u0003CBq!!\u001b\u0001\t\u0003\nY\u0007C\u0004\u0002p\u0001!\t%!\u001d\t\u000f\u0005\r\u0005\u0001\"\u0011\u0002\u0006\"1\u00111\u0012\u0001\u0005B\u001dDa!!$\u0001\t\u0003:\u0007bBAH\u0001\u0011E\u0013\u0011\u0013\u0005\b\u00037\u0003A\u0011IAO\u0011\u001d\t\u0019\u000b\u0001C!\u0003KCq!!+\u0001\t\u0003\n9\u0001C\u0004\u0002,\u0002!\t%!,\t\u000f\u0005U\u0006\u0001\"\u0011\u00028\"I\u0011\u0011\u001a\u0001\u0002\u0002\u0013\u0005\u00111\u001a\u0005\n\u0003+\u0004\u0011\u0013!C\u0001\u0003/D\u0011\"!<\u0001#\u0003%\t!a6\t\u0013\u0005=\b!%A\u0005\u0002\u0005E\b\"CA{\u0001E\u0005I\u0011AAy\u0011%\t9\u0010AA\u0001\n\u0003\nI\u0010\u0003\u0005\u0003\n\u0001\t\t\u0011\"\u0001m\u0011%\u0011Y\u0001AA\u0001\n\u0003\u0011i\u0001C\u0005\u0003\u0014\u0001\t\t\u0011\"\u0011\u0003\u0016!I!1\u0005\u0001\u0002\u0002\u0013\u0005!Q\u0005\u0005\n\u0005S\u0001\u0011\u0011!C!\u0005W9\u0011Ba\u00141\u0003\u0003E\tA!\u0015\u0007\u0011=\u0002\u0014\u0011!E\u0001\u0005'Baa]\u0015\u0005\u0002\t\u0005\u0004\"\u0003B2S\u0005\u0005IQ\tB3\u0011%\u00119'KA\u0001\n\u0003\u0013I\u0007C\u0005\u0003t%\n\t\u0011\"!\u0003v!I!qQ\u0015\u0002\u0002\u0013%!\u0011\u0012\u0002\u0011\u0011&\u001cHo\\4sC6tU/\\3sS\u000eT!!\r\u001a\u0002\u0013\u0005<wM]3hCR,'BA\u001a5\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005U2\u0014\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005]B\u0014aA:rY*\u0011\u0011HO\u0001\u0006gB\f'o\u001b\u0006\u0003wq\na!\u00199bG\",'\"A\u001f\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000f\u0001\u0001%JT,^GB\u0019\u0011I\u0011#\u000e\u0003AJ!a\u0011\u0019\u00031QK\b/\u001a3J[B,'/\u0019;jm\u0016\fum\u001a:fO\u0006$X\r\u0005\u0002F\u00116\taI\u0003\u0002Hm\u0005!Q\u000f^5m\u0013\tIeI\u0001\tOk6,'/[2ISN$xn\u001a:b[B\u00111\nT\u0007\u0002e%\u0011QJ\r\u0002\u0017\u00136\u0004H.[2ji\u000e\u000b7\u000f^%oaV$H+\u001f9fgB\u0019qJ\u0015+\u000e\u0003AS!!\u0015\u001b\u0002\u000bQ\u0014X-Z:\n\u0005M\u0003&A\u0003\"j]\u0006\u0014\u0018\u0010T5lKB\u00111*V\u0005\u0003-J\u0012!\"\u0012=qe\u0016\u001c8/[8o!\tA6,D\u0001Z\u0015\tQf'\u0001\u0004feJ|'o]\u0005\u00039f\u0013q\"U;fef,%O]8sg\n\u000b7/\u001a\t\u0003=\u0006l\u0011a\u0018\u0006\u0002A\u0006)1oY1mC&\u0011!m\u0018\u0002\b!J|G-^2u!\tqF-\u0003\u0002f?\na1+\u001a:jC2L'0\u00192mK\u0006)1\r[5mIV\tA+\u0001\u0004dQ&dG\rI\u0001\u0006]\nKgn]\u0001\u0007]\nKgn\u001d\u0011\u0002-5,H/\u00192mK\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR,\u0012!\u001c\t\u0003=:L!a\\0\u0003\u0007%sG/A\fnkR\f'\r\\3BO\u001e\u0014UO\u001a4fe>3gm]3uA\u0005!\u0012N\u001c9vi\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR\fQ#\u001b8qkR\fum\u001a\"vM\u001a,'o\u00144gg\u0016$\b%\u0001\u0004=S:LGO\u0010\u000b\u0006kZ<\b0\u001f\t\u0003\u0003\u0002AQAZ\u0005A\u0002QCQ![\u0005A\u0002QCQa[\u0005A\u00025DQ!]\u0005A\u00025$2!^>}\u0011\u00151'\u00021\u0001U\u0011\u0015I'\u00021\u0001U\u0003\tq'-F\u0001\u0000!\rq\u0016\u0011A\u0005\u0004\u0003\u0007y&aA!os\u0006\u0011\u0002O]8qC\u001e\fG/Z%oaV$H+\u001f9f+\t\tI\u0001E\u0002_\u0003\u0017I1!!\u0004`\u0005\u001d\u0011un\u001c7fC:\f!\"\u001b8qkR$\u0016\u0010]3t+\t\t\u0019\u0002\u0005\u0004\u0002\u0016\u0005\u0015\u00121\u0006\b\u0005\u0003/\t\tC\u0004\u0003\u0002\u001a\u0005}QBAA\u000e\u0015\r\tiBP\u0001\u0007yI|w\u000e\u001e \n\u0003\u0001L1!a\t`\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\n\u0002*\t\u00191+Z9\u000b\u0007\u0005\rr\f\u0005\u0003\u0002.\u0005MRBAA\u0018\u0015\r\t\tDN\u0001\u0006if\u0004Xm]\u0005\u0005\u0003k\tyC\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006\u00192\r[3dW&s\u0007/\u001e;ECR\fG+\u001f9fgR\u0011\u00111\b\t\u0005\u0003{\t\u0019%\u0004\u0002\u0002@)\u0019\u0011\u0011\t\u001b\u0002\u0011\u0005t\u0017\r\\=tSNLA!!\u0012\u0002@\tyA+\u001f9f\u0007\",7m\u001b*fgVdG/A\fde\u0016\fG/Z!hOJ,w-\u0019;j_:\u0014UO\u001a4feR\tA)\u0001\u0004va\u0012\fG/\u001a\u000b\u0006\t\u0006=\u00131\u000b\u0005\u0007\u0003#\u0002\u0002\u0019\u0001#\u0002\r\t,hMZ3s\u0011\u001d\t)\u0006\u0005a\u0001\u0003/\n\u0001\"\u001b8qkR\u0014vn\u001e\t\u0005\u00033\nY&D\u00015\u0013\r\ti\u0006\u000e\u0002\f\u0013:$XM\u001d8bYJ{w/A\u0003nKJ<W\rF\u0003E\u0003G\n)\u0007\u0003\u0004\u0002RE\u0001\r\u0001\u0012\u0005\u0007\u0003O\n\u0002\u0019\u0001#\u0002\u000b=$\b.\u001a:\u0002\t\u00154\u0018\r\u001c\u000b\u0004\u007f\u00065\u0004BBA)%\u0001\u0007A)A\u0005tKJL\u0017\r\\5{KR!\u00111OA@!\u0015q\u0016QOA=\u0013\r\t9h\u0018\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004=\u0006m\u0014bAA??\n!!)\u001f;f\u0011\u0019\t\ti\u0005a\u0001\t\u0006\u0019qN\u00196\u0002\u0017\u0011,7/\u001a:jC2L'0\u001a\u000b\u0004\t\u0006\u001d\u0005bBAE)\u0001\u0007\u00111O\u0001\u0006Ef$Xm]\u0001\u0005Y\u00164G/A\u0003sS\u001eDG/A\fxSRDg*Z<DQ&dGM]3o\u0013:$XM\u001d8bYR)Q/a%\u0002\u0018\"1\u0011QS\fA\u0002Q\u000bqA\\3x\u0019\u00164G\u000f\u0003\u0004\u0002\u001a^\u0001\r\u0001V\u0001\t]\u0016<(+[4ii\u0006ir/\u001b;i\u001d\u0016<X*\u001e;bE2,\u0017iZ4Ck\u001a4WM](gMN,G\u000fF\u0002v\u0003?Ca!!)\u0019\u0001\u0004i\u0017!\u00038fo>3gm]3u\u0003m9\u0018\u000e\u001e5OK^Le\u000e];u\u0003\u001e<')\u001e4gKJ|eMZ:fiR\u0019Q/a*\t\r\u0005\u0005\u0016\u00041\u0001n\u0003!qW\u000f\u001c7bE2,\u0017\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0005\u0005=\u0006\u0003BA\u0017\u0003cKA!a-\u00020\tAA)\u0019;b)f\u0004X-\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\"!!/\u0011\t\u0005m\u00161\u0019\b\u0005\u0003{\u000by\fE\u0002\u0002\u001a}K1!!1`\u0003\u0019\u0001&/\u001a3fM&!\u0011QYAd\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011Y0\u0002\t\r|\u0007/\u001f\u000b\nk\u00065\u0017qZAi\u0003'DqAZ\u000f\u0011\u0002\u0003\u0007A\u000bC\u0004j;A\u0005\t\u0019\u0001+\t\u000f-l\u0002\u0013!a\u0001[\"9\u0011/\bI\u0001\u0002\u0004i\u0017AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u00033T3\u0001VAnW\t\ti\u000e\u0005\u0003\u0002`\u0006%XBAAq\u0015\u0011\t\u0019/!:\u0002\u0013Ut7\r[3dW\u0016$'bAAt?\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005-\u0018\u0011\u001d\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\t\u0019PK\u0002n\u00037\fabY8qs\u0012\"WMZ1vYR$C'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003w\u0004B!!@\u0003\b5\u0011\u0011q \u0006\u0005\u0005\u0003\u0011\u0019!\u0001\u0003mC:<'B\u0001B\u0003\u0003\u0011Q\u0017M^1\n\t\u0005\u0015\u0017q`\u0001\raJ|G-^2u\u0003JLG/_\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\ry(q\u0002\u0005\t\u0005#!\u0013\u0011!a\u0001[\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"Aa\u0006\u0011\u000b\te!qD@\u000e\u0005\tm!b\u0001B\u000f?\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\t\u0005\"1\u0004\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002\n\t\u001d\u0002\u0002\u0003B\tM\u0005\u0005\t\u0019A@\u0002\r\u0015\fX/\u00197t)\u0011\tIA!\f\t\u0011\tEq%!AA\u0002}D3\u0003\u0001B\u0019\u0005o\u0011ID!\u0010\u0003@\t\r#Q\tB%\u0005\u0017\u00022a\u0013B\u001a\u0013\r\u0011)D\r\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\u0011Y$\u0001DY\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\fK3yaJd\u0003E\u001c2*A5\u00023i\\7qkR,7\u000fI1!Q&\u001cHo\\4sC6\u0004sN\u001c\u0011ok6,'/[2!O\u0015D\bO]\u0014!kNLgn\u001a\u0011oE\u0002\u0012\u0017N\\:/\u0015\u0001\u0002\u0003\u0005\t\u0011!)\",\u0007E]3ukJt\u0007E^1mk\u0016\u0004\u0013n\u001d\u0011b]\u0002\n'O]1zA=4\u0007\u0005\u000b=-s&\u0002\u0003/Y5sg\u0002\u0012X\r\u001d:fg\u0016tG/\u001b8hAQDW\rI2f]R,'o\u001d\u0011pM\u0002\"\b.\u001a\u0006!A\u0001\u0002\u0003\u0005\t5jgR|wM]1nOM\u0004#-\u001b8t]\u0001\n5\u000f\t;iK\u00022\u0018\r\\;fA=4\u0007e\n8cO\u0001J7\u000fI5oGJ,\u0017m]3eY\u0001\"\b.\u001a\u0011iSN$xn\u001a:b[\u0002\n\u0007\u000f\u001d:pq&l\u0017\r^5p]*\u0001\u0003\u0005\t\u0011!A\u001d,Go\u001d\u0011gS:,'/L4sC&tW\r\u001a\u0017!EV$\b%\\1zAeLW\r\u001c3!CJ$\u0018NZ1diN\u0004\u0013M]8v]\u0012\u0004s.\u001e;mS\u0016\u00148O\f\u0011J]\u0002\u0002(/Y2uS\u000e,G\u0006\t\u001a1[Q\u0002$\u0002\t\u0011!A\u0001\u0002\u0003.[:u_\u001e\u0014\u0018-\u001c\u0011cS:\u001c\b%\u00199qK\u0006\u0014\b\u0005^8!o>\u00148\u000eI<fY2d\u0003e^5uQ\u0002jwN]3!E&t7\u000f\t2fS:<\u0007E]3rk&\u0014X\r\u001a\u0011g_J\u00043o[3xK\u0012\u0004sN\u001d\u0006!A\u0001\u0002\u0003\u0005I:nC2dWM\u001d\u0011eCR\f7/\u001a;t]\u0001ru\u000e^3!i\"\fG\u000f\t;iSN\u0004c-\u001e8di&|g\u000eI2sK\u0006$Xm\u001d\u0011bA!L7\u000f^8he\u0006l\u0007e^5uQ\u0002rwN\\\u0017v]&4wN]7\u000bA\u0001\u0002\u0003\u0005\t\u0011cS:\u0004s/\u001b3uQNt\u0003%\u0013;!_\u001a4WM]:!]>\u0004s-^1sC:$X-Z:!S:\u0004C/\u001a:ng\u0002zg\r\t;iK\u0002jW-\u00198.gF,\u0018M]3e[\u0015\u0014(o\u001c:!_\u001a\u0004C\u000f[3\u000bA\u0001\u0002\u0003\u0005\t\u0011iSN$xn\u001a:b[2\u0002#-\u001e;!S:\u0004\u0003O]1di&\u001cW\rI5tA\r|W\u000e]1sC\ndW\r\t;pAQDW\r\t5jgR|wM]1ng\u0002\u0002(o\u001c3vG\u0016$\u0007EY=!i\",\u0007EU\u0018T[AcWo\u001d\u0006!A\u0001\u0002\u0003\u0005I:uCRL7\u000f^5dC2\u00043m\\7qkRLgn\u001a\u0011qC\u000e\\\u0017mZ3t]\u0001ru\u000e^3;AQDW\rI8viB,H\u000f\t;za\u0016\u0004sN\u001a\u0011uQ\u0016\u0004s\u0005_\u0014!M&,G\u000e\u001a\u0011j]\u0002\"\b.\u001a\u0011sKR,(O\u001c\u0011wC2,X\rI5t\u0015\u0001\u0002\u0003\u0005\t\u0011!aJ|\u0007/Y4bi\u0016$\u0007E\u001a:p[\u0002\"\b.\u001a\u0011j]B,H\u000f\t<bYV,\u0007eY8ogVlW\r\u001a\u0011j]\u0002\"\b.\u001a\u0011bO\u001e\u0014XmZ1uK\u00022WO\\2uS>tgF\u0003\u0011!A\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0005\u0003\n\u0011Q\n\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)G>dG\u0006I\u001b*A\u0019\u0013v*\u0014\u0011W\u00032+Vi\u0015\u0011)a%b\u0003\u0005K\u0019*Y\u0001B#'\u000b\u0017!QE\u0002\u0014\u0006I!TAQ\f'\rK2pY&Z$\u0002\t\u0011!A\u0001\u0002\u0003eW>#q\nR\u0004\u0007\f\u0012zEi\nd\u0006M?-w\nB(EO\u0019-Ee\u0014#(\r\u00181{2Z(\u0005\u001f\u0012;e1\u0012\u0013P\t\u001e2]AjHf\u001f\u0012yEi\n\u0004\u0007\f\u0012zEi\nd\u0006M?^\u0015\u0001\u0002\u0013!B4s_V\u0004\u0018E\u0001B$\u0003%\twmZ0gk:\u001c7/A\u0003tS:\u001cW-\t\u0002\u0003N\u0005)1GL\u001a/a\u0005\u0001\u0002*[:u_\u001e\u0014\u0018-\u001c(v[\u0016\u0014\u0018n\u0019\t\u0003\u0003&\u001aB!\u000bB+GBI!q\u000bB/)RkW.^\u0007\u0003\u00053R1Aa\u0017`\u0003\u001d\u0011XO\u001c;j[\u0016LAAa\u0018\u0003Z\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001b\u0015\u0005\tE\u0013\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005m\u0018!B1qa2LH#C;\u0003l\t5$q\u000eB9\u0011\u00151G\u00061\u0001U\u0011\u0015IG\u00061\u0001U\u0011\u0015YG\u00061\u0001n\u0011\u0015\tH\u00061\u0001n\u0003\u001d)h.\u00199qYf$BAa\u001e\u0003\u0004B)aL!\u001f\u0003~%\u0019!1P0\u0003\r=\u0003H/[8o!\u001dq&q\u0010+U[6L1A!!`\u0005\u0019!V\u000f\u001d7fi!A!QQ\u0017\u0002\u0002\u0003\u0007Q/A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011!1\u0012\t\u0005\u0003{\u0014i)\u0003\u0003\u0003\u0010\u0006}(AB(cU\u0016\u001cG\u000f")
public class HistogramNumeric
extends TypedImperativeAggregate<NumericHistogram>
implements ImplicitCastInputTypes,
BinaryLike<Expression>,
QueryErrorsBase,
scala.Serializable {
    private Object nb;
    private boolean propagateInputType;
    private final Expression child;
    private final Expression nBins;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private transient Seq<Expression> children;
    private volatile byte bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple4<Expression, Expression, Object, Object>> unapply(HistogramNumeric histogramNumeric) {
        return HistogramNumeric$.MODULE$.unapply(histogramNumeric);
    }

    public static Function1<Tuple4<Expression, Expression, Object, Object>, HistogramNumeric> tupled() {
        return HistogramNumeric$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Object, Function1<Object, HistogramNumeric>>>> curried() {
        return HistogramNumeric$.MODULE$.curried();
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toDSOption(String option) {
        return QueryErrorsBase.toDSOption$(this, option);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLSchema(String schema) {
        return QueryErrorsBase.toSQLSchema$(this, schema);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    @Override
    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    @Override
    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    @Override
    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    @Override
    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    @Override
    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    @Override
    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    @Override
    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    @Override
    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    @Override
    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    @Override
    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    @Override
    public String getSummary(SQLQueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (SQLQueryContext)sqlContext);
    }

    @Override
    public QueryContext[] getQueryContext(SQLQueryContext sqlContext) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (SQLQueryContext)sqlContext);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return BinaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return BinaryLike.withNewChildrenInternal$(this, newChildren);
    }

    private Seq<Expression> children$lzycompute() {
        HistogramNumeric histogramNumeric = this;
        synchronized (histogramNumeric) {
            if (!this.bitmap$trans$0) {
                this.children = BinaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if (!this.bitmap$trans$0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    public Expression child() {
        return this.child;
    }

    public Expression nBins() {
        return this.nBins;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    private Object nb$lzycompute() {
        HistogramNumeric histogramNumeric = this;
        synchronized (histogramNumeric) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Integer n;
                Object object = this.nBins().eval(this.nBins().eval$default$1());
                if (object == null) {
                    n = null;
                } else if (object instanceof Integer) {
                    int n2 = BoxesRunTime.unboxToInt((Object)object);
                    n = BoxesRunTime.boxToInteger((int)n2);
                } else {
                    throw new MatchError(object);
                }
                this.nb = n;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.nb;
    }

    private Object nb() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.nb$lzycompute();
        }
        return this.nb;
    }

    private boolean propagateInputType$lzycompute() {
        HistogramNumeric histogramNumeric = this;
        synchronized (histogramNumeric) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.propagateInputType = SQLConf$.MODULE$.get().histogramNumericPropagateInputType();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.propagateInputType;
    }

    private boolean propagateInputType() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.propagateInputType$lzycompute();
        }
        return this.propagateInputType;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)new .colon.colon((Object)TypeCollection$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{NumericType$.MODULE$, DateType$.MODULE$, TimestampType$.MODULE$, TimestampNTZType$.MODULE$, YearMonthIntervalType$.MODULE$, DayTimeIntervalType$.MODULE$})), (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$));
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult defaultCheck = ExpectsInputTypes.checkInputDataTypes$(this);
        if (defaultCheck.isFailure()) {
            return defaultCheck;
        }
        if (!this.nBins().foldable()) {
            return new TypeCheckResult.DataTypeMismatch("NON_FOLDABLE_INPUT", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputName"), (Object)"nb"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)this.toSQLType((AbstractDataType)this.nBins().dataType())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputExpr"), (Object)this.toSQLExpr(this.nBins()))}))));
        }
        if (this.nb() == null) {
            return new TypeCheckResult.DataTypeMismatch("UNEXPECTED_NULL", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exprName"), (Object)"nb")}))));
        }
        if (BoxesRunTime.unboxToInt((Object)this.nb()) < 2) {
            return new TypeCheckResult.DataTypeMismatch("VALUE_OUT_OF_RANGE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exprName"), (Object)"nb"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"valueRange"), (Object)new StringBuilder(5).append("[2, ").append(Integer.MAX_VALUE).append("]").toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"currentValue"), (Object)this.toSQLValue(this.nb(), (DataType)IntegerType$.MODULE$))}))));
        }
        return TypeCheckResult$TypeCheckSuccess$.MODULE$;
    }

    @Override
    public NumericHistogram createAggregationBuffer() {
        NumericHistogram buffer = new NumericHistogram();
        buffer.allocate(BoxesRunTime.unboxToInt((Object)this.nb()));
        return buffer;
    }

    @Override
    public NumericHistogram update(NumericHistogram buffer, InternalRow inputRow) {
        block0: {
            Object value = this.child().eval(inputRow);
            if (value == null) break block0;
            double doubleValue = ((Number)value).doubleValue();
            buffer.add(doubleValue);
        }
        return buffer;
    }

    @Override
    public NumericHistogram merge(NumericHistogram buffer, NumericHistogram other) {
        buffer.merge(other);
        return buffer;
    }

    @Override
    public Object eval(NumericHistogram buffer) {
        if (buffer.getUsedBins() < 1) {
            return null;
        }
        scala.collection.immutable.IndexedSeq result = (scala.collection.immutable.IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), buffer.getUsedBins()).map((Function1 & Serializable & scala.Serializable)index -> HistogramNumeric.$anonfun$eval$1(this, buffer, BoxesRunTime.unboxToInt((Object)index)), IndexedSeq$.MODULE$.canBuildFrom());
        return new GenericArrayData((Seq<Object>)result);
    }

    @Override
    public byte[] serialize(NumericHistogram obj) {
        return NumericHistogramSerializer$.MODULE$.serialize(obj);
    }

    @Override
    public NumericHistogram deserialize(byte[] bytes) {
        return NumericHistogramSerializer$.MODULE$.deserialize(bytes);
    }

    @Override
    public Expression left() {
        return this.child();
    }

    @Override
    public Expression right() {
        return this.nBins();
    }

    @Override
    public HistogramNumeric withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3(), this.copy$default$4());
    }

    @Override
    public HistogramNumeric withNewMutableAggBufferOffset(int newOffset) {
        int x$1 = newOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        int x$4 = this.copy$default$4();
        return this.copy(x$2, x$3, x$1, x$4);
    }

    @Override
    public HistogramNumeric withNewInputAggBufferOffset(int newOffset) {
        int x$1 = newOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        int x$4 = this.copy$default$3();
        return this.copy(x$2, x$3, x$4, x$1);
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public DataType dataType() {
        return new ArrayType((DataType)new StructType((StructField[])((Object[])new StructField[]{new StructField("x", (DataType)(this.propagateInputType() ? this.left().dataType() : DoubleType$.MODULE$), true, StructField$.MODULE$.apply$default$4()), new StructField("y", (DataType)DoubleType$.MODULE$, true, StructField$.MODULE$.apply$default$4())})), true);
    }

    @Override
    public String prettyName() {
        return "histogram_numeric";
    }

    public HistogramNumeric copy(Expression child, Expression nBins, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new HistogramNumeric(child, nBins, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Expression copy$default$2() {
        return this.nBins();
    }

    public int copy$default$3() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$4() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "HistogramNumeric";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
            case 1: {
                return this.nBins();
            }
            case 2: {
                return BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
            }
            case 3: {
                return BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof HistogramNumeric;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof HistogramNumeric)) return false;
        boolean bl = true;
        if (!bl) return false;
        HistogramNumeric histogramNumeric = (HistogramNumeric)x$1;
        Expression expression = this.child();
        Expression expression2 = histogramNumeric.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.nBins();
        Expression expression4 = histogramNumeric.nBins();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (this.mutableAggBufferOffset() != histogramNumeric.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != histogramNumeric.inputAggBufferOffset()) return false;
        if (!histogramNumeric.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ InternalRow $anonfun$eval$1(HistogramNumeric $this, NumericHistogram buffer$1, int index) {
        NumericHistogram.Coord coord = buffer$1.getBin(index);
        if ($this.propagateInputType()) {
            DataType dataType = $this.left().dataType();
            Byte result = ByteType$.MODULE$.equals(dataType) ? (Number)BoxesRunTime.boxToByte((byte)((byte)coord.x)) : (Number)((IntegerType$.MODULE$.equals(dataType) ? true : (DateType$.MODULE$.equals(dataType) ? true : dataType instanceof YearMonthIntervalType)) ? (Number)BoxesRunTime.boxToInteger((int)((int)coord.x)) : (Number)(FloatType$.MODULE$.equals(dataType) ? (Number)BoxesRunTime.boxToFloat((float)((float)coord.x)) : (Number)(ShortType$.MODULE$.equals(dataType) ? (Number)BoxesRunTime.boxToShort((short)((short)coord.x)) : (Number)((dataType instanceof DayTimeIntervalType ? true : (LongType$.MODULE$.equals(dataType) ? true : (TimestampType$.MODULE$.equals(dataType) ? true : TimestampNTZType$.MODULE$.equals(dataType)))) ? (Number)BoxesRunTime.boxToLong((long)((long)coord.x)) : (Number)BoxesRunTime.boxToDouble((double)coord.x)))));
            return InternalRow$.MODULE$.apply((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{result, BoxesRunTime.boxToDouble((double)coord.y)}));
        }
        return InternalRow$.MODULE$.apply((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)coord.x), BoxesRunTime.boxToDouble((double)coord.y)}));
    }

    public HistogramNumeric(Expression child, Expression nBins, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.child = child;
        this.nBins = nBins;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
        ExpectsInputTypes.$init$(this);
        BinaryLike.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
    }

    public HistogramNumeric(Expression child, Expression nBins) {
        this(child, nBins, 0, 0);
    }
}

