/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.rules;

import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.rules.QueryExecutionMetrics;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005a\u0001\u0002\u0007\u000e\u0001iAQ\u0001\u000b\u0001\u0005\u0002%BqA\u0011\u0001C\u0002\u0013%1\t\u0003\u0004P\u0001\u0001\u0006I\u0001\u0012\u0005\b!\u0002\u0011\r\u0011\"\u0003R\u0011\u0019q\u0006\u0001)A\u0005%\"9q\f\u0001b\u0001\n\u0013\t\u0006B\u00021\u0001A\u0003%!\u000bC\u0003b\u0001\u0011\u0005!\rC\u0003m\u0001\u0011\u0005Q\u000eC\u0003s\u0001\u0011\u00051\u000fC\u0003z\u0001\u0011%!P\u0001\tQY\u0006t7\t[1oO\u0016dunZ4fe*\u0011abD\u0001\u0006eVdWm\u001d\u0006\u0003!E\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003%M\t1a]9m\u0015\t!R#A\u0003ta\u0006\u00148N\u0003\u0002\u0017/\u00051\u0011\r]1dQ\u0016T\u0011\u0001G\u0001\u0004_J<7\u0001A\u000b\u000379\u001a2\u0001\u0001\u000f#!\ti\u0002%D\u0001\u001f\u0015\u0005y\u0012!B:dC2\f\u0017BA\u0011\u001f\u0005\u0019\te.\u001f*fMB\u00111EJ\u0007\u0002I)\u0011QeE\u0001\tS:$XM\u001d8bY&\u0011q\u0005\n\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\t!\u0006E\u0002,\u00011j\u0011!\u0004\t\u0003[9b\u0001\u0001B\u00030\u0001\t\u0007\u0001G\u0001\u0005Ue\u0016,G+\u001f9f#\t\tD\u0007\u0005\u0002\u001ee%\u00111G\b\u0002\b\u001d>$\b.\u001b8ha\t)D\bE\u00027smj\u0011a\u000e\u0006\u0003q=\tQ\u0001\u001e:fKNL!AO\u001c\u0003\u0011Q\u0013X-\u001a(pI\u0016\u0004\"!\f\u001f\u0005\u0013ur\u0013\u0011!A\u0001\u0006\u0003q$aA0%cE\u0011\u0011g\u0010\t\u0003;\u0001K!!\u0011\u0010\u0003\u0007\u0005s\u00170\u0001\u0005m_\u001edUM^3m+\u0005!\u0005CA#M\u001d\t1%\n\u0005\u0002H=5\t\u0001J\u0003\u0002J3\u00051AH]8pizJ!a\u0013\u0010\u0002\rA\u0013X\rZ3g\u0013\tieJ\u0001\u0004TiJLgn\u001a\u0006\u0003\u0017z\t\u0011\u0002\\8h\u0019\u00164X\r\u001c\u0011\u0002\u00111|wMU;mKN,\u0012A\u0015\t\u0004;M+\u0016B\u0001+\u001f\u0005\u0019y\u0005\u000f^5p]B\u0019ak\u0017#\u000f\u0005]KfBA$Y\u0013\u0005y\u0012B\u0001.\u001f\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001X/\u0003\u0007M+\u0017O\u0003\u0002[=\u0005IAn\\4Sk2,7\u000fI\u0001\u000bY><')\u0019;dQ\u0016\u001c\u0018a\u00037pO\n\u000bGo\u00195fg\u0002\nq\u0001\\8h%VdW\r\u0006\u0003dM\"T\u0007CA\u000fe\u0013\t)gD\u0001\u0003V]&$\b\"B4\t\u0001\u0004!\u0015\u0001\u0003:vY\u0016t\u0015-\\3\t\u000b%D\u0001\u0019\u0001\u0017\u0002\u000f=dG\r\u00157b]\")1\u000e\u0003a\u0001Y\u00059a.Z<QY\u0006t\u0017\u0001\u00037pO\n\u000bGo\u00195\u0015\t\rt\u0007/\u001d\u0005\u0006_&\u0001\r\u0001R\u0001\nE\u0006$8\r\u001b(b[\u0016DQ![\u0005A\u00021BQa[\u0005A\u00021\n!\u0002\\8h\u001b\u0016$(/[2t)\t\u0019G\u000fC\u0003v\u0015\u0001\u0007a/A\u0004nKR\u0014\u0018nY:\u0011\u0005-:\u0018B\u0001=\u000e\u0005U\tV/\u001a:z\u000bb,7-\u001e;j_:lU\r\u001e:jGN\fq\u0002\\8h\u0005\u0006\u001cX\rZ(o\u0019\u00164X\r\u001c\u000b\u0003GnDa\u0001`\u0006\u0005\u0002\u0004i\u0018!\u00014\u0011\u0007uqH)\u0003\u0002\u0000=\tAAHY=oC6,g\b")
public class PlanChangeLogger<TreeType extends TreeNode<?>>
implements Logging {
    private final String logLevel;
    private final Option<Seq<String>> logRules;
    private final Option<Seq<String>> logBatches;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private String logLevel() {
        return this.logLevel;
    }

    private Option<Seq<String>> logRules() {
        return this.logRules;
    }

    private Option<Seq<String>> logBatches() {
        return this.logBatches;
    }

    public void logRule(String ruleName, TreeType oldPlan, TreeType newPlan) {
        if (!((TreeNode)newPlan).fastEquals((TreeNode<?>)oldPlan)) {
            if (this.logRules().isEmpty() || ((SeqLike)this.logRules().get()).contains((Object)ruleName)) {
                this.logBasedOnLevel((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> PlanChangeLogger.message$1(ruleName, oldPlan, newPlan));
                return;
            }
            return;
        }
    }

    public void logBatch(String batchName, TreeType oldPlan, TreeType newPlan) {
        if (this.logBatches().isEmpty() || ((SeqLike)this.logBatches().get()).contains((Object)batchName)) {
            this.logBasedOnLevel((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> PlanChangeLogger.message$2(oldPlan, newPlan, batchName));
            return;
        }
    }

    public void logMetrics(QueryExecutionMetrics metrics) {
        double totalTime = (double)metrics.time() / (double)1000000000L;
        double totalTimeEffective = (double)metrics.timeEffective() / (double)1000000000L;
        String message = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(207).append("\n         |=== Metrics of Executed Rules ===\n         |Total number of runs: ").append(metrics.numRuns()).append("\n         |Total time: ").append(totalTime).append(" seconds\n         |Total number of effective runs: ").append(metrics.numEffectiveRuns()).append("\n         |Total time of effective runs: ").append(totalTimeEffective).append(" seconds\n      ").toString())).stripMargin();
        this.logBasedOnLevel((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> message);
    }

    private void logBasedOnLevel(Function0<String> f) {
        String string = this.logLevel();
        if ("TRACE".equals(string)) {
            this.logTrace(f);
            return;
        }
        if ("DEBUG".equals(string)) {
            this.logDebug(f);
            return;
        }
        if ("INFO".equals(string)) {
            this.logInfo(f);
            return;
        }
        if ("WARN".equals(string)) {
            this.logWarning(f);
            return;
        }
        if ("ERROR".equals(string)) {
            this.logError(f);
            return;
        }
        this.logTrace(f);
    }

    private static final String message$1(String ruleName$1, TreeNode oldPlan$1, TreeNode newPlan$1) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(64).append("\n             |=== Applying Rule ").append(ruleName$1).append(" ===\n             |").append(package$.MODULE$.sideBySide(oldPlan$1.treeString(), newPlan$1.treeString()).mkString("\n")).append("\n           ").toString())).stripMargin();
    }

    private static final String message$2(TreeNode oldPlan$2, TreeNode newPlan$2, String batchName$1) {
        if (!oldPlan$2.fastEquals(newPlan$2)) {
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(65).append("\n             |=== Result of Batch ").append(batchName$1).append(" ===\n             |").append(package$.MODULE$.sideBySide(oldPlan$2.treeString(), newPlan$2.treeString()).mkString("\n")).append("\n          ").toString())).stripMargin();
        }
        return new StringBuilder(21).append("Batch ").append(batchName$1).append(" has no effect.").toString();
    }

    public PlanChangeLogger() {
        Logging.$init$((Logging)this);
        this.logLevel = SQLConf$.MODULE$.get().planChangeLogLevel();
        this.logRules = SQLConf$.MODULE$.get().planChangeRules().map((Function1 & java.io.Serializable & Serializable)str -> Utils$.MODULE$.stringToSeq(str));
        this.logBatches = SQLConf$.MODULE$.get().planChangeBatches().map((Function1 & java.io.Serializable & Serializable)str -> Utils$.MODULE$.stringToSeq(str));
    }
}

