/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.FormatNumber$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NumericType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(expr1, expr2) - Formats the number `expr1` like '#,###,###.##', rounded to `expr2`\n      decimal places. If `expr2` is 0, the result has no decimal point or fractional part.\n      `expr2` also accept a user specified format.\n      This is supposed to function like MySQL's FORMAT.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(12332.123456, 4);\n       12,332.1235\n      > SELECT _FUNC_(12332.123456, '##################.###');\n       12332.123\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\t\u001dd\u0001\u0002\u0016,\u0001bB\u0001\u0002\u0017\u0001\u0003\u0016\u0004%\t!\u0017\u0005\t;\u0002\u0011\t\u0012)A\u00055\"Aa\f\u0001BK\u0002\u0013\u0005\u0011\f\u0003\u0005`\u0001\tE\t\u0015!\u0003[\u0011\u0015\u0001\u0007\u0001\"\u0001b\u0011\u0015)\u0007\u0001\"\u0011Z\u0011\u00151\u0007\u0001\"\u0011Z\u0011\u00159\u0007\u0001\"\u0011i\u0011\u0015y\u0007\u0001\"\u0011q\u0011\u0015!\b\u0001\"\u0011v\u0011\u001da\bA1A\u0005\nuDq!!\u0004\u0001A\u0003%a\u0010C\u0005\u0002\u0010\u0001\u0001\r\u0011\"\u0003\u0002\u0012!I\u0011q\u0004\u0001A\u0002\u0013%\u0011\u0011\u0005\u0005\t\u0003[\u0001\u0001\u0015)\u0003\u0002\u0014!I\u0011q\u0007\u0001A\u0002\u0013%\u0011\u0011\b\u0005\n\u0003\u0017\u0002\u0001\u0019!C\u0005\u0003\u001bB\u0001\"!\u0015\u0001A\u0003&\u00111\b\u0005\u000b\u0003+\u0002\u0001R1A\u0005\n\u0005]\u0003BCA1\u0001!\u0015\r\u0011\"\u0003\u0002d!9\u00111\u000f\u0001\u0005R\u0005U\u0004bBAC\u0001\u0011\u0005\u0013q\u0011\u0005\b\u0003G\u0003A\u0011IAS\u0011\u001d\t9\u000b\u0001C)\u0003SC\u0011\"a-\u0001\u0003\u0003%\t!!.\t\u0013\u0005m\u0006!%A\u0005\u0002\u0005u\u0006\"CAj\u0001E\u0005I\u0011AA_\u0011!\t)\u000eAA\u0001\n\u0003j\b\"CAl\u0001\u0005\u0005I\u0011AAm\u0011%\tY\u000eAA\u0001\n\u0003\ti\u000eC\u0005\u0002b\u0002\t\t\u0011\"\u0011\u0002d\"I\u0011\u0011\u001f\u0001\u0002\u0002\u0013\u0005\u00111\u001f\u0005\n\u0003o\u0004\u0011\u0011!C!\u0003sD\u0011\"!@\u0001\u0003\u0003%\t%a@\b\u0013\t\r2&!A\t\u0002\t\u0015b\u0001\u0003\u0016,\u0003\u0003E\tAa\n\t\r\u0001$C\u0011\u0001B \u0011%\u0011\t\u0005JA\u0001\n\u000b\u0012\u0019\u0005C\u0005\u0003F\u0011\n\t\u0011\"!\u0003H!I!Q\n\u0013\u0002\u0002\u0013\u0005%q\n\u0005\n\u0005;\"\u0013\u0011!C\u0005\u0005?\u0012ABR8s[\u0006$h*^7cKJT!\u0001L\u0017\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003]=\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003aE\n1a]9m\u0015\t\u00114'A\u0003ta\u0006\u00148N\u0003\u00025k\u00051\u0011\r]1dQ\u0016T\u0011AN\u0001\u0004_J<7\u0001A\n\u0007\u0001ej\u0004iR'\u0011\u0005iZT\"A\u0016\n\u0005qZ#\u0001\u0005\"j]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\tQd(\u0003\u0002@W\t\tR\t\u001f9fGR\u001c\u0018J\u001c9viRK\b/Z:\u0011\u0005\u0005#eB\u0001\u001eC\u0013\t\u00195&A\u0004qC\u000e\\\u0017mZ3\n\u0005\u00153%A\u0004(vY2Le\u000e^8mKJ\fg\u000e\u001e\u0006\u0003\u0007.\u0002\"\u0001S&\u000e\u0003%S\u0011AS\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0019&\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002O+:\u0011q\n\u0016\b\u0003!Nk\u0011!\u0015\u0006\u0003%^\na\u0001\u0010:p_Rt\u0014\"\u0001&\n\u0005\rK\u0015B\u0001,X\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\t\u0019\u0015*A\u0001y+\u0005Q\u0006C\u0001\u001e\\\u0013\ta6F\u0001\u0006FqB\u0014Xm]:j_:\f!\u0001\u001f\u0011\u0002\u0003\u0011\f!\u0001\u001a\u0011\u0002\rqJg.\u001b;?)\r\u00117\r\u001a\t\u0003u\u0001AQ\u0001W\u0003A\u0002iCQAX\u0003A\u0002i\u000bA\u0001\\3gi\u0006)!/[4ii\u0006AA-\u0019;b)f\u0004X-F\u0001j!\tQW.D\u0001l\u0015\taw&A\u0003usB,7/\u0003\u0002oW\nAA)\u0019;b)f\u0004X-\u0001\u0005ok2d\u0017M\u00197f+\u0005\t\bC\u0001%s\u0013\t\u0019\u0018JA\u0004C_>dW-\u00198\u0002\u0015%t\u0007/\u001e;UsB,7/F\u0001w!\rqu/_\u0005\u0003q^\u00131aU3r!\tQ'0\u0003\u0002|W\n\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\u000eI\u00164\u0017-\u001e7u\r>\u0014X.\u0019;\u0016\u0003y\u00042a`A\u0005\u001b\t\t\tA\u0003\u0003\u0002\u0004\u0005\u0015\u0011\u0001\u00027b]\u001eT!!a\u0002\u0002\t)\fg/Y\u0005\u0005\u0003\u0017\t\tA\u0001\u0004TiJLgnZ\u0001\u000fI\u00164\u0017-\u001e7u\r>\u0014X.\u0019;!\u00035a\u0017m\u001d;E\u0013:$h+\u00197vKV\u0011\u00111\u0003\t\u0006\u0011\u0006U\u0011\u0011D\u0005\u0004\u0003/I%AB(qi&|g\u000eE\u0002I\u00037I1!!\bJ\u0005\rIe\u000e^\u0001\u0012Y\u0006\u001cH\u000fR%oiZ\u000bG.^3`I\u0015\fH\u0003BA\u0012\u0003S\u00012\u0001SA\u0013\u0013\r\t9#\u0013\u0002\u0005+:LG\u000fC\u0005\u0002,9\t\t\u00111\u0001\u0002\u0014\u0005\u0019\u0001\u0010J\u0019\u0002\u001d1\f7\u000f\u001e#J]R4\u0016\r\\;fA!\u001aq\"!\r\u0011\u0007!\u000b\u0019$C\u0002\u00026%\u0013\u0011\u0002\u001e:b]NLWM\u001c;\u0002!1\f7\u000f\u001e#TiJLgn\u001a,bYV,WCAA\u001e!\u0015A\u0015QCA\u001f!\u0011\ty$a\u0012\u000f\t\u0005\u0005\u00131\t\t\u0003!&K1!!\u0012J\u0003\u0019\u0001&/\u001a3fM&!\u00111BA%\u0015\r\t)%S\u0001\u0015Y\u0006\u001cH\u000fR*ue&twMV1mk\u0016|F%Z9\u0015\t\u0005\r\u0012q\n\u0005\n\u0003W\t\u0012\u0011!a\u0001\u0003w\t\u0011\u0003\\1ti\u0012\u001bFO]5oOZ\u000bG.^3!Q\r\u0011\u0012\u0011G\u0001\ba\u0006$H/\u001a:o+\t\tI\u0006E\u0002\u0000\u00037JA!!\u0018\u0002\u0002\ta1\u000b\u001e:j]\u001e\u0014UO\u001a4fe\"\u001a1#!\r\u0002\u00199,XNY3s\r>\u0014X.\u0019;\u0016\u0005\u0005\u0015\u0004\u0003BA4\u0003[j!!!\u001b\u000b\t\u0005-\u0014QA\u0001\u0005i\u0016DH/\u0003\u0003\u0002p\u0005%$!\u0004#fG&l\u0017\r\u001c$pe6\fG\u000fK\u0002\u0015\u0003c\tAB\\;mYN\u000bg-Z#wC2$b!a\u001e\u0002~\u0005\u0005\u0005c\u0001%\u0002z%\u0019\u00111P%\u0003\u0007\u0005s\u0017\u0010C\u0004\u0002\u0000U\u0001\r!a\u001e\u0002\u000fa|%M[3di\"9\u00111Q\u000bA\u0002\u0005]\u0014a\u00023PE*,7\r^\u0001\nI><UM\\\"pI\u0016$b!!#\u0002\u0016\u0006}\u0005\u0003BAF\u0003#k!!!$\u000b\u0007\u0005=5&A\u0004d_\u0012,w-\u001a8\n\t\u0005M\u0015Q\u0012\u0002\t\u000bb\u0004(oQ8eK\"9\u0011q\u0013\fA\u0002\u0005e\u0015aA2uqB!\u00111RAN\u0013\u0011\ti*!$\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\"9\u0011\u0011\u0015\fA\u0002\u0005%\u0015AA3w\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0003\u0003{\tqc^5uQ:+wo\u00115jY\u0012\u0014XM\\%oi\u0016\u0014h.\u00197\u0015\u000b\t\fY+a,\t\r\u00055\u0006\u00041\u0001[\u0003\u001dqWm\u001e'fMRDa!!-\u0019\u0001\u0004Q\u0016\u0001\u00038foJKw\r\u001b;\u0002\t\r|\u0007/\u001f\u000b\u0006E\u0006]\u0016\u0011\u0018\u0005\b1f\u0001\n\u00111\u0001[\u0011\u001dq\u0016\u0004%AA\u0002i\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002@*\u001a!,!1,\u0005\u0005\r\u0007\u0003BAc\u0003\u001fl!!a2\u000b\t\u0005%\u00171Z\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!4J\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003#\f9MA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u00033\ta\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002x\u0005}\u0007\"CA\u0016=\u0005\u0005\t\u0019AA\r\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAs!\u0019\t9/!<\u0002x5\u0011\u0011\u0011\u001e\u0006\u0004\u0003WL\u0015AC2pY2,7\r^5p]&!\u0011q^Au\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007E\f)\u0010C\u0005\u0002,\u0001\n\t\u00111\u0001\u0002x\u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\rq\u00181 \u0005\n\u0003W\t\u0013\u0011!a\u0001\u00033\ta!Z9vC2\u001cHcA9\u0003\u0002!I\u00111\u0006\u0012\u0002\u0002\u0003\u0007\u0011q\u000f\u0015\u0014\u0001\t\u0015!1\u0002B\u0007\u0005#\u0011\u0019Ba\u0006\u0003\u001a\tu!q\u0004\t\u0004u\t\u001d\u0011b\u0001B\u0005W\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017E\u0001B\b\u0003\t=#\u0002\t\u0011!A}3UKT\"`Q\u0015D\bO]\u0019-A\u0015D\bO\u001d\u001a*A5\u0002ci\u001c:nCR\u001c\b\u0005\u001e5fA9,XNY3sA\u0001,\u0007\u0010\u001d:2A\u0002b\u0017n[3!O\rb3eI\u0012-G\r\u001acfI\u0012(Y\u0001\u0012x.\u001e8eK\u0012\u0004Co\u001c\u0011aKb\u0004(O\r1\u000bA\u0001\u0002\u0003\u0005\t\u0011eK\u000eLW.\u00197!a2\f7-Z:/A%3\u0007\u0005Y3yaJ\u0014\u0004\rI5tAAb\u0003\u0005\u001e5fAI,7/\u001e7uA!\f7\u000f\t8pA\u0011,7-[7bY\u0002\u0002x.\u001b8uA=\u0014\bE\u001a:bGRLwN\\1mAA\f'\u000f\u001e\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011aKb\u0004(O\r1!C2\u001cx\u000eI1dG\u0016\u0004H\u000fI1!kN,'\u000fI:qK\u000eLg-[3eA\u0019|'/\\1u])\u0001\u0003\u0005\t\u0011!AQC\u0017n\u001d\u0011jg\u0002\u001aX\u000f\u001d9pg\u0016$\u0007\u0005^8!MVt7\r^5p]\u0002b\u0017n[3!\u001bf\u001c\u0016\u000bT\u0014tA\u0019{%+T!U])\u0001\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\u0011)\"AA\u001d\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\n$gM\u001a3]E\u00124\u0007N\u001b7Y\u0001\"\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00112e1\u001a4G\r\u00182eM*$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u00193gM\u0012d&\r\u001a4iU2D\u0006I\u0014$G\r\u001a3eI\u0012$G\r\u001a3eI\u0012$G\r\u001acfI\u0012$O%Z$\u0002\t\u0011!A\u0001\u0002\u0003%\r\u001a4gIr\u0013GM\u001a\u000bA\u0001\nQa]5oG\u0016\f#Aa\u0007\u0002\u000bErSG\f\u0019\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\t\u0005\u0012\u0001D:ue&twm\u00184v]\u000e\u001c\u0018\u0001\u0004$pe6\fGOT;nE\u0016\u0014\bC\u0001\u001e%'\u0015!#\u0011\u0006B\u001b!\u001d\u0011YC!\r[5\nl!A!\f\u000b\u0007\t=\u0012*A\u0004sk:$\u0018.\\3\n\t\tM\"Q\u0006\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014\u0004\u0003\u0002B\u001c\u0005{i!A!\u000f\u000b\t\tm\u0012QA\u0001\u0003S>L1A\u0016B\u001d)\t\u0011)#\u0001\u0005u_N#(/\u001b8h)\u0005q\u0018!B1qa2LH#\u00022\u0003J\t-\u0003\"\u0002-(\u0001\u0004Q\u0006\"\u00020(\u0001\u0004Q\u0016aB;oCB\u0004H.\u001f\u000b\u0005\u0005#\u0012I\u0006E\u0003I\u0003+\u0011\u0019\u0006E\u0003I\u0005+R&,C\u0002\u0003X%\u0013a\u0001V;qY\u0016\u0014\u0004\u0002\u0003B.Q\u0005\u0005\t\u0019\u00012\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0003bA\u0019qPa\u0019\n\t\t\u0015\u0014\u0011\u0001\u0002\u0007\u001f\nTWm\u0019;")
public class FormatNumber
extends BinaryExpression
implements ExpectsInputTypes,
package.NullIntolerant,
Serializable {
    private transient StringBuffer pattern;
    private transient DecimalFormat numberFormat;
    private final Expression x;
    private final Expression d;
    private final String defaultFormat;
    private transient Option<Object> lastDIntValue;
    private transient Option<String> lastDStringValue;
    private volatile transient byte bitmap$trans$0;

    public static Option<Tuple2<Expression, Expression>> unapply(FormatNumber x$0) {
        return FormatNumber$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, FormatNumber> tupled() {
        return FormatNumber$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, FormatNumber>> curried() {
        return FormatNumber$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression x() {
        return this.x;
    }

    public Expression d() {
        return this.d;
    }

    @Override
    public Expression left() {
        return this.x();
    }

    @Override
    public Expression right() {
        return this.d();
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{NumericType$.MODULE$, TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{IntegerType$.MODULE$, StringType$.MODULE$}))}));
    }

    private String defaultFormat() {
        return this.defaultFormat;
    }

    private Option<Object> lastDIntValue() {
        return this.lastDIntValue;
    }

    private void lastDIntValue_$eq(Option<Object> x$1) {
        this.lastDIntValue = x$1;
    }

    private Option<String> lastDStringValue() {
        return this.lastDStringValue;
    }

    private void lastDStringValue_$eq(Option<String> x$1) {
        this.lastDStringValue = x$1;
    }

    private StringBuffer pattern$lzycompute() {
        FormatNumber formatNumber = this;
        synchronized (formatNumber) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.pattern = new StringBuffer();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.pattern;
    }

    private StringBuffer pattern() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.pattern$lzycompute() : this.pattern;
    }

    private DecimalFormat numberFormat$lzycompute() {
        FormatNumber formatNumber = this;
        synchronized (formatNumber) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.numberFormat = new DecimalFormat("", new DecimalFormatSymbols(Locale.US));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.numberFormat;
    }

    private DecimalFormat numberFormat() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.numberFormat$lzycompute() : this.numberFormat;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Object nullSafeEval(Object xObject, Object dObject) {
        block24: {
            block25: {
                block23: {
                    var7_3 = this.right().dataType();
                    if (!IntegerType$.MODULE$.equals(var7_3)) break block23;
                    dValue = BoxesRunTime.unboxToInt((Object)dObject);
                    if (dValue < 0) {
                        return null;
                    }
                    var9_5 = this.lastDIntValue();
                    if (var9_5 instanceof Some && (last = BoxesRunTime.unboxToInt((Object)(var10_6 = (Some)var9_5).value())) == dValue) {
                        var6_8 = BoxedUnit.UNIT;
                    } else {
                        this.pattern().delete(0, this.pattern().length());
                        this.pattern().append(this.defaultFormat());
                        if (dValue > 0) {
                            this.pattern().append(".");
                            for (i = 0; i < dValue; ++i) {
                                this.pattern().append("0");
                            }
                        }
                        this.lastDIntValue_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)dValue)));
                        this.numberFormat().applyLocalizedPattern(this.pattern().toString());
                        var6_9 = BoxedUnit.UNIT;
                    }
                    var4_11 = BoxedUnit.UNIT;
                    break block24;
                }
                if (!StringType$.MODULE$.equals(var7_3)) break block25;
                dValue = ((UTF8String)dObject).toString();
                var14_14 = this.lastDStringValue();
                if (!(var14_14 instanceof Some)) ** GOTO lbl-1000
                var15_15 = (Some)var14_14;
                v0 = last = (String)var15_15.value();
                var17_17 = dValue;
                if (!(v0 != null ? v0.equals(var17_17) == false : var17_17 != null)) {
                    var5_18 = BoxedUnit.UNIT;
                } else lbl-1000:
                // 2 sources

                {
                    this.pattern().delete(0, this.pattern().length());
                    this.lastDStringValue_$eq((Option<String>)new Some((Object)dValue));
                    if (dValue.isEmpty()) {
                        this.numberFormat().applyLocalizedPattern(this.defaultFormat());
                        v1 = BoxedUnit.UNIT;
                    } else {
                        this.numberFormat().applyLocalizedPattern(dValue);
                        v1 = BoxedUnit.UNIT;
                    }
                    var5_19 = v1;
                }
                var4_12 = BoxedUnit.UNIT;
                break block24;
            }
            throw new MatchError((Object)var7_3);
        }
        var18_20 = this.x().dataType();
        if (ByteType$.MODULE$.equals(var18_20)) {
            var3_21 = UTF8String.fromString((String)this.numberFormat().format(BoxesRunTime.unboxToByte((Object)xObject)));
        } else if (ShortType$.MODULE$.equals(var18_20)) {
            var3_21 = UTF8String.fromString((String)this.numberFormat().format(BoxesRunTime.unboxToShort((Object)xObject)));
        } else if (FloatType$.MODULE$.equals(var18_20)) {
            var3_21 = UTF8String.fromString((String)this.numberFormat().format(BoxesRunTime.unboxToFloat((Object)xObject)));
        } else if (IntegerType$.MODULE$.equals(var18_20)) {
            var3_21 = UTF8String.fromString((String)this.numberFormat().format(BoxesRunTime.unboxToInt((Object)xObject)));
        } else if (LongType$.MODULE$.equals(var18_20)) {
            var3_21 = UTF8String.fromString((String)this.numberFormat().format(BoxesRunTime.unboxToLong((Object)xObject)));
        } else if (DoubleType$.MODULE$.equals(var18_20)) {
            var3_21 = UTF8String.fromString((String)this.numberFormat().format(BoxesRunTime.unboxToDouble((Object)xObject)));
        } else if (var18_20 instanceof DecimalType) {
            var3_21 = UTF8String.fromString((String)this.numberFormat().format(((Decimal)xObject).toJavaBigDecimal()));
        } else {
            throw new MatchError((Object)var18_20);
        }
        return var3_21;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(num, d) -> {
            String string;
            String sb = StringBuffer.class.getName();
            String df = DecimalFormat.class.getName();
            String dfs = DecimalFormatSymbols.class.getName();
            String l = Locale.class.getName();
            String usLocale = "US";
            String numberFormat = ctx.addMutableState(df, "numberFormat", (Function1<String, String>)(Function1 & Serializable)v -> new StringBuilder(21).append((String)v).append(" = new ").append(df).append("(\"\", new ").append(dfs).append("(").append(l).append(".").append(usLocale).append("));").toString(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
            DataType dataType = this.right().dataType();
            if (IntegerType$.MODULE$.equals(dataType)) {
                String pattern = ctx.addMutableState(sb, "pattern", (Function1<String, String>)(Function1 & Serializable)v -> new StringBuilder(10).append((String)v).append(" = new ").append(sb).append("();").toString(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
                String i = ctx.freshName("i");
                String lastDValue = ctx.addMutableState("int", "lastDValue", (Function1<String, String>)(Function1 & Serializable)v -> new StringBuilder(8).append((String)v).append(" = -100;").toString(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
                string = new StringBuilder(528).append("\n            if (").append((String)d).append(" >= 0) {\n              ").append(pattern).append(".delete(0, ").append(pattern).append(".length());\n              if (").append((String)d).append(" != ").append(lastDValue).append(") {\n                ").append(pattern).append(".append(\"").append(this.defaultFormat()).append("\");\n\n                if (").append((String)d).append(" > 0) {\n                  ").append(pattern).append(".append(\".\");\n                  for (int ").append(i).append(" = 0; ").append(i).append(" < ").append((String)d).append("; ").append(i).append("++) {\n                    ").append(pattern).append(".append(\"0\");\n                  }\n                }\n                ").append(lastDValue).append(" = ").append((String)d).append(";\n                ").append(numberFormat).append(".applyLocalizedPattern(").append(pattern).append(".toString());\n              }\n              ").append(ev.value()).append(" = UTF8String.fromString(").append(numberFormat).append(".format(").append(this.typeHelper$1((String)num)).append("));\n            } else {\n              ").append(ev.value()).append(" = null;\n              ").append(ev.isNull()).append(" = true;\n            }\n           ").toString();
            } else if (StringType$.MODULE$.equals(dataType)) {
                String lastDValue = ctx.addMutableState("String", "lastDValue", (Function1<String, String>)(Function1 & Serializable)v -> new StringBuilder(8).append((String)v).append(" = null;").toString(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
                String dValue = ctx.freshName("dValue");
                string = new StringBuilder(316).append("\n            String ").append(dValue).append(" = ").append((String)d).append(".toString();\n            if (!").append(dValue).append(".equals(").append(lastDValue).append(")) {\n              ").append(lastDValue).append(" = ").append(dValue).append(";\n              if (").append(dValue).append(".isEmpty()) {\n                ").append(numberFormat).append(".applyLocalizedPattern(\"").append(this.defaultFormat()).append("\");\n              } else {\n                ").append(numberFormat).append(".applyLocalizedPattern(").append(dValue).append(");\n              }\n            }\n            ").append(ev.value()).append(" = UTF8String.fromString(").append(numberFormat).append(".format(").append(this.typeHelper$1((String)num)).append("));\n           ").toString();
            } else {
                throw new MatchError((Object)dataType);
            }
            return string;
        });
    }

    @Override
    public String prettyName() {
        return "format_number";
    }

    @Override
    public FormatNumber withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public FormatNumber copy(Expression x, Expression d) {
        return new FormatNumber(x, d);
    }

    public Expression copy$default$1() {
        return this.x();
    }

    public Expression copy$default$2() {
        return this.d();
    }

    @Override
    public String productPrefix() {
        return "FormatNumber";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.x();
                break;
            }
            case 1: {
                object = this.d();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof FormatNumber;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "x";
                break;
            }
            case 1: {
                string = "d";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof FormatNumber)) return false;
        boolean bl = true;
        if (!bl) return false;
        FormatNumber formatNumber = (FormatNumber)x$1;
        Expression expression = this.x();
        Expression expression2 = formatNumber.x();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.d();
        Expression expression4 = formatNumber.d();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!formatNumber.canEqual(this)) return false;
        return true;
    }

    private final String typeHelper$1(String p) {
        DataType dataType = this.x().dataType();
        String string = dataType instanceof DecimalType ? new StringBuilder(19).append(p).append(".toJavaBigDecimal()").toString() : String.valueOf(p);
        return string;
    }

    public FormatNumber(Expression x, Expression d) {
        this.x = x;
        this.d = d;
        ExpectsInputTypes.$init$(this);
        this.defaultFormat = "#,###,###,###,###,###,##0";
        this.lastDIntValue = None$.MODULE$;
        this.lastDStringValue = None$.MODULE$;
    }
}

