/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.DateTimeException;
import java.time.LocalDate;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.MakeDate$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.IntegerType$;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(year, month, day) - Create date from year, month and day fields. If the configuration `spark.sql.ansi.enabled` is false, the function returns NULL on invalid inputs. Otherwise, it will throw an error instead.", arguments="\n    Arguments:\n      * year - the year to represent, from 1 to 9999\n      * month - the month-of-year to represent, from 1 (January) to 12 (December)\n      * day - the day-of-month to represent, from 1 to 31\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(2013, 7, 15);\n       2013-07-15\n      > SELECT _FUNC_(2019, 7, NULL);\n       NULL\n  ", group="datetime_funcs", since="3.0.0")
@ScalaSignature(bytes="\u0006\u0005\t-c\u0001\u0002\u0016,\u0001bB\u0001\u0002\u0017\u0001\u0003\u0016\u0004%\t!\u0017\u0005\t;\u0002\u0011\t\u0012)A\u00055\"Aa\f\u0001BK\u0002\u0013\u0005\u0011\f\u0003\u0005`\u0001\tE\t\u0015!\u0003[\u0011!\u0001\u0007A!f\u0001\n\u0003I\u0006\u0002C1\u0001\u0005#\u0005\u000b\u0011\u0002.\t\u0011\t\u0004!Q3A\u0005\u0002\rD\u0001b\u001a\u0001\u0003\u0012\u0003\u0006I\u0001\u001a\u0005\u0006Q\u0002!\t!\u001b\u0005\u0006Q\u0002!\ta\u001c\u0005\u0006g\u0002!\t%\u0017\u0005\u0006i\u0002!\t%\u0017\u0005\u0006k\u0002!\t%\u0017\u0005\u0006m\u0002!\te\u001e\u0005\b\u0003\u0007\u0001A\u0011IA\u0003\u0011\u0019\ti\u0001\u0001C!G\"9\u0011q\u0002\u0001\u0005B\u0005E\u0001bBA\u0010\u0001\u0011\u0005\u0013\u0011\u0005\u0005\b\u0003{\u0001A\u0011IA \u0011\u001d\t\t\u0006\u0001C)\u0003'B\u0011\"!\u0019\u0001\u0003\u0003%\t!a\u0019\t\u0013\u00055\u0004!%A\u0005\u0002\u0005=\u0004\"CAC\u0001E\u0005I\u0011AA8\u0011%\t9\tAI\u0001\n\u0003\ty\u0007C\u0005\u0002\n\u0002\t\n\u0011\"\u0001\u0002\f\"I\u0011q\u0012\u0001\u0002\u0002\u0013\u0005\u0013\u0011\u0013\u0005\n\u0003C\u0003\u0011\u0011!C\u0001\u0003GC\u0011\"a+\u0001\u0003\u0003%\t!!,\t\u0013\u0005M\u0006!!A\u0005B\u0005U\u0006\"CAb\u0001\u0005\u0005I\u0011AAc\u0011%\tI\rAA\u0001\n\u0003\nY\rC\u0005\u0002P\u0002\t\t\u0011\"\u0011\u0002R\u001eI\u00111`\u0016\u0002\u0002#\u0005\u0011Q \u0004\tU-\n\t\u0011#\u0001\u0002\u0000\"1\u0001N\tC\u0001\u0005/A\u0011B!\u0007#\u0003\u0003%)Ea\u0007\t\u0013\tu!%!A\u0005\u0002\n}\u0001\"\u0003B\u0015EE\u0005I\u0011AAF\u0011%\u0011YCIA\u0001\n\u0003\u0013i\u0003C\u0005\u0003@\t\n\n\u0011\"\u0001\u0002\f\"I!\u0011\t\u0012\u0002\u0002\u0013%!1\t\u0002\t\u001b\u0006\\W\rR1uK*\u0011A&L\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002/_\u0005A1-\u0019;bYf\u001cHO\u0003\u00021c\u0005\u00191/\u001d7\u000b\u0005I\u001a\u0014!B:qCJ\\'B\u0001\u001b6\u0003\u0019\t\u0007/Y2iK*\ta'A\u0002pe\u001e\u001c\u0001a\u0005\u0004\u0001su\u0002u)\u0014\t\u0003umj\u0011aK\u0005\u0003y-\u0012\u0011\u0003V3s]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\tQd(\u0003\u0002@W\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000f\u0005\u0002B\t:\u0011!HQ\u0005\u0003\u0007.\nq\u0001]1dW\u0006<W-\u0003\u0002F\r\nqa*\u001e7m\u0013:$x\u000e\\3sC:$(BA\",!\tA5*D\u0001J\u0015\u0005Q\u0015!B:dC2\f\u0017B\u0001'J\u0005\u001d\u0001&o\u001c3vGR\u0004\"AT+\u000f\u0005=#fB\u0001)T\u001b\u0005\t&B\u0001*8\u0003\u0019a$o\\8u}%\t!*\u0003\u0002D\u0013&\u0011ak\u0016\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003\u0007&\u000bA!_3beV\t!\f\u0005\u0002;7&\u0011Al\u000b\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017!B=fCJ\u0004\u0013!B7p]RD\u0017AB7p]RD\u0007%A\u0002eCf\fA\u0001Z1zA\u0005Ya-Y5m\u001f:,%O]8s+\u0005!\u0007C\u0001%f\u0013\t1\u0017JA\u0004C_>dW-\u00198\u0002\u0019\u0019\f\u0017\u000e\\(o\u000bJ\u0014xN\u001d\u0011\u0002\rqJg.\u001b;?)\u0015Q7\u000e\\7o!\tQ\u0004\u0001C\u0003Y\u0013\u0001\u0007!\fC\u0003_\u0013\u0001\u0007!\fC\u0003a\u0013\u0001\u0007!\fC\u0004c\u0013A\u0005\t\u0019\u00013\u0015\t)\u0004\u0018O\u001d\u0005\u00061*\u0001\rA\u0017\u0005\u0006=*\u0001\rA\u0017\u0005\u0006A*\u0001\rAW\u0001\u0006M&\u00148\u000f^\u0001\u0007g\u0016\u001cwN\u001c3\u0002\u000bQD\u0017N\u001d3\u0002\u0015%t\u0007/\u001e;UsB,7/F\u0001y!\rq\u0015p_\u0005\u0003u^\u00131aU3r!\tax0D\u0001~\u0015\tqx&A\u0003usB,7/C\u0002\u0002\u0002u\u0014\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002\u0011\u0011\fG/\u0019+za\u0016,\"!a\u0002\u0011\u0007q\fI!C\u0002\u0002\fu\u0014\u0001\u0002R1uCRK\b/Z\u0001\t]VdG.\u00192mK\u0006aa.\u001e7m'\u00064W-\u0012<bYRA\u00111CA\r\u00037\ti\u0002E\u0002I\u0003+I1!a\u0006J\u0005\r\te.\u001f\u0005\u00071F\u0001\r!a\u0005\t\ry\u000b\u0002\u0019AA\n\u0011\u0019\u0001\u0017\u00031\u0001\u0002\u0014\u0005IAm\\$f]\u000e{G-\u001a\u000b\u0007\u0003G\ty#!\u000f\u0011\t\u0005\u0015\u00121F\u0007\u0003\u0003OQ1!!\u000b,\u0003\u001d\u0019w\u000eZ3hK:LA!!\f\u0002(\tAQ\t\u001f9s\u0007>$W\rC\u0004\u00022I\u0001\r!a\r\u0002\u0007\r$\b\u0010\u0005\u0003\u0002&\u0005U\u0012\u0002BA\u001c\u0003O\u0011abQ8eK\u001e,gnQ8oi\u0016DH\u000fC\u0004\u0002<I\u0001\r!a\t\u0002\u0005\u00154\u0018A\u00039sKR$\u0018PT1nKV\u0011\u0011\u0011\t\t\u0005\u0003\u0007\nYE\u0004\u0003\u0002F\u0005\u001d\u0003C\u0001)J\u0013\r\tI%S\u0001\u0007!J,G-\u001a4\n\t\u00055\u0013q\n\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005%\u0013*A\fxSRDg*Z<DQ&dGM]3o\u0013:$XM\u001d8bYR9!.!\u0016\u0002Z\u0005u\u0003BBA,)\u0001\u0007!,\u0001\u0005oK^4\u0015N]:u\u0011\u0019\tY\u0006\u0006a\u00015\u0006Ia.Z<TK\u000e|g\u000e\u001a\u0005\u0007\u0003?\"\u0002\u0019\u0001.\u0002\u00119,w\u000f\u00165je\u0012\fAaY8qsRI!.!\u001a\u0002h\u0005%\u00141\u000e\u0005\b1V\u0001\n\u00111\u0001[\u0011\u001dqV\u0003%AA\u0002iCq\u0001Y\u000b\u0011\u0002\u0003\u0007!\fC\u0004c+A\u0005\t\u0019\u00013\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011\u0011\u000f\u0016\u00045\u0006M4FAA;!\u0011\t9(!!\u000e\u0005\u0005e$\u0002BA>\u0003{\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005}\u0014*\u0001\u0006b]:|G/\u0019;j_:LA!a!\u0002z\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0014AD2paf$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003\u001bS3\u0001ZA:\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u00111\u0013\t\u0005\u0003+\u000by*\u0004\u0002\u0002\u0018*!\u0011\u0011TAN\u0003\u0011a\u0017M\\4\u000b\u0005\u0005u\u0015\u0001\u00026bm\u0006LA!!\u0014\u0002\u0018\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011Q\u0015\t\u0004\u0011\u0006\u001d\u0016bAAU\u0013\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u00111CAX\u0011%\t\t\fHA\u0001\u0002\u0004\t)+A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003o\u0003b!!/\u0002@\u0006MQBAA^\u0015\r\ti,S\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAa\u0003w\u0013\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR\u0019A-a2\t\u0013\u0005Ef$!AA\u0002\u0005M\u0011A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!a%\u0002N\"I\u0011\u0011W\u0010\u0002\u0002\u0003\u0007\u0011QU\u0001\u0007KF,\u0018\r\\:\u0015\u0007\u0011\f\u0019\u000eC\u0005\u00022\u0002\n\t\u00111\u0001\u0002\u0014!:\u0002!a6\u0002^\u0006}\u00171]As\u0003S\fY/a<\u0002r\u0006U\u0018q\u001f\t\u0004u\u0005e\u0017bAAnW\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAAq\u0003\u0005=vLR+O\u0007~C\u00130Z1sY\u0001jwN\u001c;iY\u0001\"\u0017-_\u0015![\u0001\u001a%/Z1uK\u0002\"\u0017\r^3!MJ|W\u000eI=fCJd\u0003%\\8oi\"\u0004\u0013M\u001c3!I\u0006L\bEZ5fY\u0012\u001ch\u0006I%gAQDW\rI2p]\u001aLw-\u001e:bi&|g\u000e\t1ta\u0006\u00148NL:rY:\ngn]5/K:\f'\r\\3eA\u0002J7\u000f\t4bYN,G\u0006\t;iK\u00022WO\\2uS>t\u0007E]3ukJt7\u000f\t(V\u00192\u0003sN\u001c\u0011j]Z\fG.\u001b3!S:\u0004X\u000f^:/A=#\b.\u001a:xSN,G\u0006I5uA]LG\u000e\u001c\u0011uQJ|w\u000fI1oA\u0015\u0014(o\u001c:!S:\u001cH/Z1e]\u0005I\u0011M]4v[\u0016tGo]\u0011\u0003\u0003O\f\u0011q\u0015\u0006!A\u0001\u0002\u0013I]4v[\u0016tGo\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011+Ae,\u0017M\u001d\u0011.AQDW\rI=fCJ\u0004Co\u001c\u0011sKB\u0014Xm]3oi2\u0002cM]8nAE\u0002Co\u001c\u0011:seJ$\u0002\t\u0011!A\u0001\u0002#\u0006I7p]RD\u0007%\f\u0011uQ\u0016\u0004Sn\u001c8uQ6zg-L=fCJ\u0004Co\u001c\u0011sKB\u0014Xm]3oi2\u0002cM]8nAE\u0002\u0003FS1ok\u0006\u0014\u00180\u000b\u0011u_\u0002\n$\u0007\t\u0015EK\u000e,WNY3sS)\u0001\u0003\u0005\t\u0011!A)\u0002C-Y=![\u0001\"\b.\u001a\u0011eCflsNZ\u0017n_:$\b\u000e\t;pAI,\u0007O]3tK:$H\u0006\t4s_6\u0004\u0013\u0007\t;pAM\n$\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!!<\u0002s*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C#\u0007M\u00194Y\u0001:D\u0006I\u00196SmR\u0001\u0005\t\u0011!A\u0001\u0002#\u0007M\u00194[A:T&M\u001b\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`QI\u0002\u0014'\u000f\u0017!o1\u0002c*\u0016'MSmR\u0001\u0005\t\u0011!A\u0001\u0002c*\u0016'M\u0015\u0001\u0002\u0013!B4s_V\u0004\u0018EAAz\u00039!\u0017\r^3uS6,wLZ;oGN\fQa]5oG\u0016\f#!!?\u0002\u000bMr\u0003G\f\u0019\u0002\u00115\u000b7.\u001a#bi\u0016\u0004\"A\u000f\u0012\u0014\u000b\t\u0012\tA!\u0004\u0011\u0013\t\r!\u0011\u0002.[5\u0012TWB\u0001B\u0003\u0015\r\u00119!S\u0001\beVtG/[7f\u0013\u0011\u0011YA!\u0002\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>tG\u0007\u0005\u0003\u0003\u0010\tUQB\u0001B\t\u0015\u0011\u0011\u0019\"a'\u0002\u0005%|\u0017b\u0001,\u0003\u0012Q\u0011\u0011Q`\u0001\ti>\u001cFO]5oOR\u0011\u00111S\u0001\u0006CB\u0004H.\u001f\u000b\nU\n\u0005\"1\u0005B\u0013\u0005OAQ\u0001W\u0013A\u0002iCQAX\u0013A\u0002iCQ\u0001Y\u0013A\u0002iCqAY\u0013\u0011\u0002\u0003\u0007A-A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00135\u0003\u001d)h.\u00199qYf$BAa\f\u0003<A)\u0001J!\r\u00036%\u0019!1G%\u0003\r=\u0003H/[8o!\u001dA%q\u0007.[5\u0012L1A!\u000fJ\u0005\u0019!V\u000f\u001d7fi!A!QH\u0014\u0002\u0002\u0003\u0007!.A\u0002yIA\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"\u0014\u0001D<sSR,'+\u001a9mC\u000e,GC\u0001B#!\u0011\t)Ja\u0012\n\t\t%\u0013q\u0013\u0002\u0007\u001f\nTWm\u0019;")
public class MakeDate
extends TernaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
Serializable {
    private final Expression year;
    private final Expression month;
    private final Expression day;
    private final boolean failOnError;

    public static boolean $lessinit$greater$default$4() {
        return MakeDate$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple4<Expression, Expression, Expression, Object>> unapply(MakeDate x$0) {
        return MakeDate$.MODULE$.unapply(x$0);
    }

    public static boolean apply$default$4() {
        return MakeDate$.MODULE$.apply$default$4();
    }

    public static Function1<Tuple4<Expression, Expression, Expression, Object>, MakeDate> tupled() {
        return MakeDate$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Function1<Object, MakeDate>>>> curried() {
        return MakeDate$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression year() {
        return this.year;
    }

    public Expression month() {
        return this.month;
    }

    public Expression day() {
        return this.day;
    }

    public boolean failOnError() {
        return this.failOnError;
    }

    @Override
    public Expression first() {
        return this.year();
    }

    @Override
    public Expression second() {
        return this.month();
    }

    @Override
    public Expression third() {
        return this.day();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new IntegerType$[]{IntegerType$.MODULE$, IntegerType$.MODULE$, IntegerType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return DateType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return this.failOnError() ? this.children().exists((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.nullable())) : true;
    }

    @Override
    public Object nullSafeEval(Object year, Object month, Object day) {
        Integer n;
        try {
            LocalDate ld = LocalDate.of(BoxesRunTime.unboxToInt((Object)year), BoxesRunTime.unboxToInt((Object)month), BoxesRunTime.unboxToInt((Object)day));
            n = BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.localDateToDays(ld));
        }
        catch (DateTimeException e) {
            if (this.failOnError()) {
                throw QueryExecutionErrors$.MODULE$.ansiDateTimeError(e);
            }
            n = null;
        }
        return n;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String dtu = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName()), "$");
        String failOnErrorBranch = this.failOnError() ? "throw QueryExecutionErrors.ansiDateTimeError(e);" : new StringBuilder(8).append(ev.isNull()).append(" = true;").toString();
        return this.nullSafeCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable)(year, month, day) -> new StringBuilder(136).append("\n      try {\n        ").append(ev.value()).append(" = ").append(dtu).append(".localDateToDays(java.time.LocalDate.of(").append((String)year).append(", ").append((String)month).append(", ").append((String)day).append("));\n      } catch (java.time.DateTimeException e) {\n        ").append(failOnErrorBranch).append("\n      }").toString());
    }

    @Override
    public String prettyName() {
        return "make_date";
    }

    @Override
    public MakeDate withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird, this.copy$default$4());
    }

    public MakeDate copy(Expression year, Expression month, Expression day, boolean failOnError) {
        return new MakeDate(year, month, day, failOnError);
    }

    public Expression copy$default$1() {
        return this.year();
    }

    public Expression copy$default$2() {
        return this.month();
    }

    public Expression copy$default$3() {
        return this.day();
    }

    public boolean copy$default$4() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "MakeDate";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.year();
                break;
            }
            case 1: {
                object = this.month();
                break;
            }
            case 2: {
                object = this.day();
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToBoolean((boolean)this.failOnError());
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MakeDate;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "year";
                break;
            }
            case 1: {
                string = "month";
                break;
            }
            case 2: {
                string = "day";
                break;
            }
            case 3: {
                string = "failOnError";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MakeDate)) return false;
        boolean bl = true;
        if (!bl) return false;
        MakeDate makeDate = (MakeDate)x$1;
        if (this.failOnError() != makeDate.failOnError()) return false;
        Expression expression = this.year();
        Expression expression2 = makeDate.year();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.month();
        Expression expression4 = makeDate.month();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.day();
        Expression expression6 = makeDate.day();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!makeDate.canEqual(this)) return false;
        return true;
    }

    public MakeDate(Expression year, Expression month, Expression day, boolean failOnError) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.failOnError = failOnError;
        ExpectsInputTypes.$init$(this);
    }

    public MakeDate(Expression year, Expression month, Expression day) {
        this(year, month, day, SQLConf$.MODULE$.get().ansiEnabled());
    }
}

