/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.feature;

import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.mllib.feature.Word2VecModel;
import org.apache.spark.mllib.feature.Word2VecModel$SaveLoadV1_0$;
import org.apache.spark.mllib.util.Loader;
import org.apache.spark.mllib.util.Loader$;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.package$;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class Word2VecModel$
implements Loader<Word2VecModel>,
Serializable {
    public static final Word2VecModel$ MODULE$ = new Word2VecModel$();

    public Map<String, Object> org$apache$spark$mllib$feature$Word2VecModel$$buildWordIndex(Map<String, float[]> model) {
        return ((IterableOnceOps)model.keys().zipWithIndex()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public float[] org$apache$spark$mllib$feature$Word2VecModel$$buildWordVectors(Map<String, float[]> model) {
        Predef$.MODULE$.require(model.nonEmpty(), (Function0 & Serializable)() -> "Word2VecMap should be non-empty");
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(((float[])((Tuple2)model.head())._2()).length, model.size());
        if (sp2 == null) {
            throw new MatchError((Object)sp2);
        }
        int vectorSize = sp2._1$mcI$sp();
        int numWords = sp2._2$mcI$sp();
        Tuple2.mcII.sp sp3 = new Tuple2.mcII.sp(vectorSize, numWords);
        Tuple2.mcII.sp sp4 = sp3;
        int vectorSize2 = sp4._1$mcI$sp();
        int numWords2 = sp4._2$mcI$sp();
        String[] wordList = (String[])model.keys().toArray(ClassTag$.MODULE$.apply(String.class));
        float[] wordVectors = new float[vectorSize2 * numWords2];
        for (int i = 0; i < numWords2; ++i) {
            Array$.MODULE$.copy(model.apply((Object)wordList[i]), 0, (Object)wordVectors, i * vectorSize2, vectorSize2);
        }
        return wordVectors;
    }

    @Override
    public Word2VecModel load(SparkContext sc, String path) {
        String string;
        Tuple3<String, String, JsonAST.JValue> tuple3 = Loader$.MODULE$.loadMetadata(sc, path);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        String loadedClassName = (String)tuple3._1();
        String loadedVersion = (String)tuple3._2();
        JsonAST.JValue metadata = (JsonAST.JValue)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)loadedClassName, (Object)loadedVersion, (Object)metadata);
        Tuple3 tuple33 = tuple32;
        String loadedClassName2 = (String)tuple33._1();
        String loadedVersion2 = (String)tuple33._2();
        JsonAST.JValue metadata2 = (JsonAST.JValue)tuple33._3();
        DefaultFormats$ formats = DefaultFormats$.MODULE$;
        int expectedVectorSize = BoxesRunTime.unboxToInt((Object)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(metadata2).$bslash("vectorSize")).extract((Formats)formats, (Manifest)ManifestFactory$.MODULE$.Int()));
        int expectedNumWords = BoxesRunTime.unboxToInt((Object)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(metadata2).$bslash("numWords")).extract((Formats)formats, (Manifest)ManifestFactory$.MODULE$.Int()));
        String classNameV1_0 = Word2VecModel$SaveLoadV1_0$.MODULE$.classNameV1_0();
        Tuple2 tuple2 = new Tuple2((Object)loadedClassName2, (Object)loadedVersion2);
        if (tuple2 == null || !"1.0".equals(string = (String)tuple2._2())) {
            throw new Exception(new StringBuilder(0).append("Word2VecModel.load did not recognize model with (className, format version):").append(new StringBuilder(18).append("(").append(loadedClassName2).append(", ").append(loadedVersion2).append(").  Supported:\n").toString()).append(new StringBuilder(9).append("  (").append(classNameV1_0).append(", 1.0)").toString()).toString());
        }
        Word2VecModel model = Word2VecModel$SaveLoadV1_0$.MODULE$.load(sc, path);
        int vectorSize = ((float[])model.getVectors().values().head()).length;
        int numWords = model.getVectors().size();
        Predef$.MODULE$.require(expectedVectorSize == vectorSize, (Function0 & Serializable)() -> new StringBuilder(0).append("Word2VecModel requires each word to be mapped to a vector of size ").append(new StringBuilder(21).append(expectedVectorSize).append(", got vector of size ").append(vectorSize).toString()).toString());
        Predef$.MODULE$.require(expectedNumWords == numWords, (Function0 & Serializable)() -> new StringBuilder(39).append("Word2VecModel requires ").append(expectedNumWords).append(" words, but got ").append(numWords).toString());
        Word2VecModel word2VecModel = model;
        return word2VecModel;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Word2VecModel$.class);
    }

    private Word2VecModel$() {
    }
}

