/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.scp;

import java.io.IOException;
import java.util.Collections;
import org.apache.sshd.common.scp.ScpException;
import org.apache.sshd.common.scp.ScpFileOpener;
import org.apache.sshd.common.scp.ScpHelper;
import org.apache.sshd.common.scp.ScpTransferEventListener;
import org.apache.sshd.common.scp.helpers.DefaultScpFileOpener;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.threads.CloseableExecutorService;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.command.AbstractFileSystemCommand;
import org.apache.sshd.server.session.ServerSession;

public class ScpCommand
extends AbstractFileSystemCommand {
    protected final int sendBufferSize;
    protected final int receiveBufferSize;
    protected final ScpFileOpener opener;
    protected boolean optR;
    protected boolean optT;
    protected boolean optF;
    protected boolean optD;
    protected boolean optP;
    protected String path;
    protected IOException error;
    protected ScpTransferEventListener listener;

    public ScpCommand(String command, CloseableExecutorService executorService, int sendSize, int receiveSize, ScpFileOpener fileOpener, ScpTransferEventListener eventListener) {
        super(command, executorService);
        if (sendSize < 127) {
            throw new IllegalArgumentException("<ScpCommmand>(" + command + ") send buffer size (" + sendSize + ") below minimum required (" + 127 + ")");
        }
        this.sendBufferSize = sendSize;
        if (receiveSize < 127) {
            throw new IllegalArgumentException("<ScpCommmand>(" + command + ") receive buffer size (" + sendSize + ") below minimum required (" + 127 + ")");
        }
        this.receiveBufferSize = receiveSize;
        this.opener = fileOpener == null ? DefaultScpFileOpener.INSTANCE : fileOpener;
        this.listener = eventListener == null ? ScpTransferEventListener.EMPTY : eventListener;
        boolean debugEnabled = this.log.isDebugEnabled();
        if (debugEnabled) {
            this.log.debug("Executing command {}", (Object)command);
        }
        Object[] args = GenericUtils.split((String)command, (char)' ');
        int numArgs = GenericUtils.length((Object[])args);
        for (int i = 1; i < numArgs; ++i) {
            char endDelim;
            Object argVal = args[i];
            if (((String)argVal).charAt(0) == '-') {
                block8: for (int j = 1; j < ((String)argVal).length(); ++j) {
                    char option = ((String)argVal).charAt(j);
                    switch (option) {
                        case 'f': {
                            this.optF = true;
                            continue block8;
                        }
                        case 'p': {
                            this.optP = true;
                            continue block8;
                        }
                        case 'r': {
                            this.optR = true;
                            continue block8;
                        }
                        case 't': {
                            this.optT = true;
                            continue block8;
                        }
                        case 'd': {
                            this.optD = true;
                            continue block8;
                        }
                        default: {
                            if (!debugEnabled) continue block8;
                            this.log.debug("Unknown flag ('{}') in command={}", (Object)Character.valueOf(option), (Object)command);
                        }
                    }
                }
                continue;
            }
            Object prevArg = args[i - 1];
            this.path = command.substring(command.indexOf((String)prevArg) + ((String)prevArg).length() + 1);
            int pathLen = this.path.length();
            char startDelim = this.path.charAt(0);
            char c = endDelim = pathLen > 2 ? this.path.charAt(pathLen - 1) : (char)'\u0000';
            if (pathLen <= 2 || startDelim != endDelim || startDelim != '\'' && startDelim != '\"') break;
            this.path = this.path.substring(1, pathLen - 1);
            break;
        }
        if (!this.optF && !this.optT) {
            this.error = new IOException("Either -f or -t option should be set for " + command);
        }
    }

    public void start(Environment env) throws IOException {
        if (this.error != null) {
            throw this.error;
        }
        super.start(env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        int exitValue = 0;
        String exitMessage = null;
        ScpHelper helper = new ScpHelper((Session)this.getServerSession(), this.in, this.out, this.fileSystem, this.opener, this.listener);
        try {
            if (this.optT) {
                helper.receive(helper.resolveLocalPath(this.path), this.optR, this.optD, this.optP, this.receiveBufferSize);
            } else {
                if (!this.optF) throw new IOException("Unsupported mode");
                helper.send(Collections.singletonList(this.path), this.optR, this.optP, this.sendBufferSize);
            }
            if (this.callback == null) return;
        }
        catch (IOException e) {
            try {
                boolean debugEnabled;
                ServerSession session;
                block14: {
                    session = this.getServerSession();
                    debugEnabled = this.log.isDebugEnabled();
                    try {
                        Integer statusCode = null;
                        if (e instanceof ScpException) {
                            statusCode = ((ScpException)e).getExitStatus();
                        }
                        int n = exitValue = statusCode == null ? 2 : statusCode;
                        if (exitValue == 0 || exitValue == 1) {
                            if (debugEnabled) {
                                this.log.debug("run({})[{}] normalize status code={}", new Object[]{session, this.command, exitValue});
                            }
                            exitValue = 2;
                        }
                        exitMessage = GenericUtils.trimToEmpty((String)e.getMessage());
                        this.writeCommandResponseMessage(this.command, exitValue, exitMessage);
                    }
                    catch (IOException e2) {
                        if (debugEnabled) {
                            this.log.debug("run({})[{}] Failed ({}) to send error response: {}", new Object[]{session, this.command, e.getClass().getSimpleName(), e.getMessage()});
                        }
                        if (!this.log.isTraceEnabled()) break block14;
                        this.log.trace("run(" + session + ")[" + this.command + "] error response failure details", (Throwable)e2);
                    }
                }
                if (debugEnabled) {
                    this.log.debug("run({})[{}] Failed ({}) to run command: {}", new Object[]{session, this.command, e.getClass().getSimpleName(), e.getMessage()});
                }
                if (this.log.isTraceEnabled()) {
                    this.log.trace("run(" + session + ")[" + this.command + "] command execution failure details", (Throwable)e);
                }
                if (this.callback == null) return;
            }
            catch (Throwable throwable) {
                if (this.callback == null) throw throwable;
                this.callback.onExit(exitValue, GenericUtils.trimToEmpty(exitMessage));
                throw throwable;
            }
            this.callback.onExit(exitValue, GenericUtils.trimToEmpty((String)exitMessage));
            return;
        }
        this.callback.onExit(exitValue, GenericUtils.trimToEmpty(exitMessage));
        return;
    }

    protected void writeCommandResponseMessage(String command, int exitValue, String exitMessage) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("writeCommandResponseMessage({}) command='{}', exit-status={}: {}", new Object[]{this.getServerSession(), command, exitValue, exitMessage});
        }
        ScpHelper.sendResponseMessage(this.out, exitValue, exitMessage);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "(" + this.getSession() + ") " + this.command;
    }
}

