/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hbase.security;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.security.token.TokenUtil;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.storm.common.AbstractAutoCreds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoHBase
extends AbstractAutoCreds {
    private static final Logger LOG = LoggerFactory.getLogger(AutoHBase.class);
    public static final String HBASE_CREDENTIALS = "HBASE_CREDENTIALS";
    public static final String HBASE_KEYTAB_FILE_KEY = "hbase.keytab.file";
    public static final String HBASE_PRINCIPAL_KEY = "hbase.kerberos.principal";
    public String hbaseKeytab;
    public String hbasePrincipal;

    @Override
    public void doPrepare(Map<String, Object> conf) {
        if (conf.containsKey(HBASE_KEYTAB_FILE_KEY) && conf.containsKey(HBASE_PRINCIPAL_KEY)) {
            this.hbaseKeytab = (String)conf.get(HBASE_KEYTAB_FILE_KEY);
            this.hbasePrincipal = (String)conf.get(HBASE_PRINCIPAL_KEY);
        }
    }

    @Override
    protected String getConfigKeyString() {
        return "hbaseCredentialsConfigKeys";
    }

    public void shutdown() {
    }

    @Override
    protected byte[] getHadoopCredentials(Map<String, Object> conf, String configKey) {
        Configuration configuration = this.getHadoopConfiguration(conf, configKey);
        return this.getHadoopCredentials(conf, configuration);
    }

    @Override
    protected byte[] getHadoopCredentials(Map<String, Object> conf) {
        return this.getHadoopCredentials(conf, HBaseConfiguration.create());
    }

    private Configuration getHadoopConfiguration(Map<String, Object> topoConf, String configKey) {
        Configuration configuration = HBaseConfiguration.create();
        this.fillHadoopConfiguration(topoConf, configKey, configuration);
        return configuration;
    }

    protected byte[] getHadoopCredentials(Map<String, Object> conf, Configuration hbaseConf) {
        try {
            if (UserGroupInformation.isSecurityEnabled()) {
                String topologySubmitterUser = (String)conf.get("topology.submitter.principal");
                UserProvider provider = UserProvider.instantiate((Configuration)hbaseConf);
                if (hbaseConf.get(HBASE_KEYTAB_FILE_KEY) == null) {
                    hbaseConf.set(HBASE_KEYTAB_FILE_KEY, this.hbaseKeytab);
                }
                if (hbaseConf.get(HBASE_PRINCIPAL_KEY) == null) {
                    hbaseConf.set(HBASE_PRINCIPAL_KEY, this.hbasePrincipal);
                }
                provider.login(HBASE_KEYTAB_FILE_KEY, HBASE_PRINCIPAL_KEY, InetAddress.getLocalHost().getCanonicalHostName());
                LOG.info("Logged into Hbase as principal = " + conf.get(HBASE_PRINCIPAL_KEY));
                UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
                UserGroupInformation proxyUser = UserGroupInformation.createProxyUser((String)topologySubmitterUser, (UserGroupInformation)ugi);
                User user = User.create((UserGroupInformation)ugi);
                if (User.isHBaseSecurityEnabled((Configuration)hbaseConf)) {
                    TokenUtil.obtainAndCacheToken((Configuration)hbaseConf, (UserGroupInformation)proxyUser);
                    LOG.info("Obtained HBase tokens, adding to user credentials.");
                    Credentials credential = proxyUser.getCredentials();
                    ByteArrayOutputStream bao = new ByteArrayOutputStream();
                    ObjectOutputStream out = new ObjectOutputStream(bao);
                    credential.write((DataOutput)out);
                    out.flush();
                    out.close();
                    return bao.toByteArray();
                }
                throw new RuntimeException("Security is not enabled for HBase.");
            }
            throw new RuntimeException("Security is not enabled for Hadoop");
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to get delegation tokens.", ex);
        }
    }

    @Override
    public void doRenew(Map<String, String> credentials, Map<String, Object> topologyConf) {
        this.populateCredentials(credentials, topologyConf);
    }

    @Override
    protected String getCredentialKey(String configKey) {
        return HBASE_CREDENTIALS + configKey;
    }

    public static void main(String[] args) throws Exception {
        HashMap<String, Object> conf = new HashMap<String, Object>();
        conf.put("topology.submitter.principal", args[0]);
        conf.put(HBASE_PRINCIPAL_KEY, args[1]);
        conf.put(HBASE_KEYTAB_FILE_KEY, args[2]);
        AutoHBase autoHBase = new AutoHBase();
        autoHBase.prepare(conf);
        HashMap<String, String> creds = new HashMap<String, String>();
        autoHBase.populateCredentials(creds, conf);
        LOG.info("Got HBase credentials" + autoHBase.getCredentials(creds));
        Subject s = new Subject();
        autoHBase.populateSubject(s, creds);
        LOG.info("Got a Subject " + s);
        autoHBase.renew(creds, conf);
        LOG.info("renewed credentials" + autoHBase.getCredentials(creds));
    }
}

