/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.storm.cluster.PaceMakerStateStorage;
import org.apache.storm.generated.ClusterWorkerHeartbeat;
import org.apache.storm.generated.HBMessage;
import org.apache.storm.generated.HBMessageData;
import org.apache.storm.generated.HBNodes;
import org.apache.storm.generated.HBPulse;
import org.apache.storm.generated.HBServerMessageType;
import org.apache.storm.pacemaker.PacemakerClient;
import org.apache.storm.pacemaker.PacemakerClientPool;
import org.apache.storm.utils.Utils;
import org.junit.Assert;
import org.junit.Test;

public class PaceMakerStateStorageFactoryTest {
    private PaceMakerClientProxy clientProxy;
    private PacemakerClientPoolProxy clientPoolProxy;
    private PaceMakerStateStorage stateStorage;

    public void createPaceMakerStateStorage(HBServerMessageType messageType, HBMessageData messageData) throws Exception {
        HBMessage response = new HBMessage(messageType, messageData);
        this.clientProxy = new PaceMakerClientProxy(response, null);
        this.clientPoolProxy = new PacemakerClientPoolProxy();
        this.stateStorage = new PaceMakerStateStorage((PacemakerClientPool)this.clientPoolProxy, null);
    }

    @Test
    public void testSetWorkerHb() throws Exception {
        this.createPaceMakerStateStorage(HBServerMessageType.SEND_PULSE_RESPONSE, null);
        this.stateStorage.set_worker_hb("/foo", Utils.javaSerialize((Object)"data"), null);
        HBMessage sent = this.clientProxy.checkCaptured();
        HBPulse pulse = sent.get_data().get_pulse();
        Assert.assertEquals((Object)HBServerMessageType.SEND_PULSE, (Object)sent.get_type());
        Assert.assertEquals((Object)"/foo", (Object)pulse.get_id());
        Assert.assertEquals((Object)"data", (Object)Utils.javaDeserialize((byte[])pulse.get_details(), String.class));
    }

    @Test(expected=RuntimeException.class)
    public void testSetWorkerHbResponseType() throws Exception {
        this.createPaceMakerStateStorage(HBServerMessageType.SEND_PULSE, null);
        this.stateStorage.set_worker_hb("/foo", Utils.javaSerialize((Object)"data"), null);
    }

    @Test
    public void testDeleteWorkerHb() throws Exception {
        this.createPaceMakerStateStorage(HBServerMessageType.DELETE_PATH_RESPONSE, null);
        this.stateStorage.delete_worker_hb("/foo/bar");
        HBMessage sent = this.clientProxy.checkCaptured();
        Assert.assertEquals((Object)HBServerMessageType.DELETE_PATH, (Object)sent.get_type());
        Assert.assertEquals((Object)"/foo/bar", (Object)sent.get_data().get_path());
    }

    @Test(expected=RuntimeException.class)
    public void testDeleteWorkerHbResponseType() throws Exception {
        this.createPaceMakerStateStorage(HBServerMessageType.DELETE_PATH, null);
        this.stateStorage.delete_worker_hb("/foo/bar");
    }

    @Test
    public void testGetWorkerHb() throws Exception {
        HBPulse hbPulse = new HBPulse();
        hbPulse.set_id("/foo");
        ClusterWorkerHeartbeat cwh = new ClusterWorkerHeartbeat("some-storm-id", new HashMap(), 1, 1);
        hbPulse.set_details(Utils.serialize((Object)cwh));
        this.createPaceMakerStateStorage(HBServerMessageType.GET_PULSE_RESPONSE, HBMessageData.pulse((HBPulse)hbPulse));
        this.stateStorage.get_worker_hb("/foo", false);
        HBMessage sent = this.clientProxy.checkCaptured();
        Assert.assertEquals((Object)HBServerMessageType.GET_PULSE, (Object)sent.get_type());
        Assert.assertEquals((Object)"/foo", (Object)sent.get_data().get_path());
    }

    @Test(expected=RuntimeException.class)
    public void testGetWorkerHbBadResponse() throws Exception {
        this.createPaceMakerStateStorage(HBServerMessageType.GET_PULSE, null);
        this.stateStorage.get_worker_hb("/foo", false);
    }

    @Test(expected=RuntimeException.class)
    public void testGetWorkerHbBadData() throws Exception {
        this.createPaceMakerStateStorage(HBServerMessageType.GET_PULSE_RESPONSE, null);
        this.stateStorage.get_worker_hb("/foo", false);
    }

    @Test
    public void testGetWorkerHbChildren() throws Exception {
        this.createPaceMakerStateStorage(HBServerMessageType.GET_ALL_NODES_FOR_PATH_RESPONSE, HBMessageData.nodes((HBNodes)new HBNodes()));
        this.stateStorage.get_worker_hb_children("/foo", false);
        HBMessage sent = this.clientProxy.checkCaptured();
        Assert.assertEquals((Object)HBServerMessageType.GET_ALL_NODES_FOR_PATH, (Object)sent.get_type());
        Assert.assertEquals((Object)"/foo", (Object)sent.get_data().get_path());
    }

    @Test(expected=RuntimeException.class)
    public void testGetWorkerHbChildrenBadData() throws Exception {
        this.createPaceMakerStateStorage(HBServerMessageType.GET_ALL_NODES_FOR_PATH_RESPONSE, null);
        this.stateStorage.get_worker_hb_children("/foo", false);
    }

    private class PacemakerClientPoolProxy
    extends PacemakerClientPool {
        public PacemakerClientPoolProxy() {
            super(new HashMap());
        }

        public PacemakerClient getWriteClient() {
            return PaceMakerStateStorageFactoryTest.this.clientProxy;
        }

        public HBMessage send(HBMessage m) {
            return PaceMakerStateStorageFactoryTest.this.clientProxy.send(m);
        }

        public List<HBMessage> sendAll(HBMessage m) {
            ArrayList<HBMessage> response = new ArrayList<HBMessage>();
            response.add(PaceMakerStateStorageFactoryTest.this.clientProxy.send(m));
            return response;
        }
    }

    private class PaceMakerClientProxy
    extends PacemakerClient {
        private HBMessage response;
        private HBMessage captured;

        public PaceMakerClientProxy(HBMessage response, HBMessage captured) {
            this.response = response;
            this.captured = captured;
        }

        public HBMessage send(HBMessage m) {
            this.captured = m;
            return this.response;
        }

        public HBMessage checkCaptured() {
            return this.captured;
        }
    }
}

