/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.bolt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.storm.bolt.JoinBolt;
import org.apache.storm.task.GeneralTopologyContext;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Tuple;
import org.apache.storm.tuple.TupleImpl;
import org.apache.storm.windowing.TupleWindow;
import org.apache.storm.windowing.TupleWindowImpl;
import org.junit.Assert;
import org.junit.Test;

public class TestJoinBolt {
    String[] userFields = new String[]{"userId", "name", "city"};
    Object[][] users = new Object[][]{{1, "roshan", "san jose"}, {2, "harsha", "santa clara"}, {3, "siva", "dublin"}, {4, "hugo", "san mateo"}, {5, "suresh", "sunnyvale"}, {6, "guru", "palo alto"}, {7, "arun", "bengaluru"}, {8, "satish", "mumbai"}, {9, "mani", "bengaluru"}, {10, "priyank", "seattle"}};
    String[] orderFields = new String[]{"orderId", "userId", "itemId", "price"};
    Object[][] orders = new Object[][]{{11, 2, 21, 7}, {12, 2, 22, 3}, {13, 3, 23, 4}, {14, 4, 24, 5}, {15, 5, 25, 2}, {16, 6, 26, 7}, {17, 6, 27, 4}, {18, 7, 28, 2}, {19, 8, 29, 9}};
    String[] storeFields = new String[]{"storeId", "storeName", "city"};
    Object[][] stores = new Object[][]{{1, "store1", "san jose"}, {2, "store2", "santa clara"}, {3, "store3", "dublin"}, {4, "store4", "san mateo"}, {5, "store5", "bengaluru"}};
    String[] cityFields = new String[]{"cityId", "cityName", "country"};
    Object[][] cities = new Object[][]{{1, "san jose", "US"}, {2, "santa clara", "US"}, {3, "dublin", "US"}, {4, "san mateo", "US"}, {5, "sunnyvale", "US"}, {6, "palo alto", "US"}, {7, "bengaluru", "India"}, {8, "mumbai", "India"}, {9, "chennai", "India"}};

    @Test
    public void testTrivial() throws Exception {
        ArrayList<Tuple> orderStream = TestJoinBolt.makeStream("orders", this.orderFields, this.orders);
        TupleWindow window = TestJoinBolt.makeTupleWindow(orderStream);
        JoinBolt bolt = new JoinBolt(JoinBolt.Selector.STREAM, "orders", this.orderFields[0]).select("orderId,userId,itemId,price");
        MockCollector collector = new MockCollector();
        bolt.prepare(null, null, (OutputCollector)collector);
        bolt.execute(window);
        TestJoinBolt.printResults(collector);
        Assert.assertEquals((long)orderStream.size(), (long)collector.actualResults.size());
    }

    @Test
    public void testNestedKeys() throws Exception {
        ArrayList<Tuple> userStream = TestJoinBolt.makeNestedEventsStream("users", this.userFields, this.users);
        TupleWindow window = TestJoinBolt.makeTupleWindow(userStream);
        JoinBolt bolt = new JoinBolt(JoinBolt.Selector.STREAM, "users", "outer.userId").select("outer.name, outer.city");
        MockCollector collector = new MockCollector();
        bolt.prepare(null, null, (OutputCollector)collector);
        bolt.execute(window);
        TestJoinBolt.printResults(collector);
        Assert.assertEquals((long)userStream.size(), (long)collector.actualResults.size());
    }

    @Test
    public void testProjection_FieldsWithStreamName() throws Exception {
        ArrayList<Tuple> userStream = TestJoinBolt.makeStream("users", this.userFields, this.users);
        ArrayList<Tuple> storeStream = TestJoinBolt.makeStream("stores", this.storeFields, this.stores);
        TupleWindow window = TestJoinBolt.makeTupleWindow(storeStream, userStream);
        JoinBolt bolt = new JoinBolt(JoinBolt.Selector.STREAM, "users", this.userFields[2]).join("stores", "city", "users").select("userId,name,storeName,users:city,stores:city");
        MockCollector collector = new MockCollector();
        bolt.prepare(null, null, (OutputCollector)collector);
        bolt.execute(window);
        TestJoinBolt.printResults(collector);
        Assert.assertEquals((long)(storeStream.size() + 1), (long)collector.actualResults.size());
        for (List<Object> tuple : collector.actualResults) {
            Assert.assertEquals((long)5L, (long)tuple.size());
            for (Object o : tuple) {
                Assert.assertNotNull((Object)o);
            }
        }
    }

    @Test
    public void testInnerJoin() throws Exception {
        ArrayList<Tuple> userStream = TestJoinBolt.makeStream("users", this.userFields, this.users);
        ArrayList<Tuple> orderStream = TestJoinBolt.makeStream("orders", this.orderFields, this.orders);
        TupleWindow window = TestJoinBolt.makeTupleWindow(orderStream, userStream);
        JoinBolt bolt = new JoinBolt(JoinBolt.Selector.STREAM, "users", this.userFields[0]).join("orders", "userId", "users").select("userId,name,price");
        MockCollector collector = new MockCollector();
        bolt.prepare(null, null, (OutputCollector)collector);
        bolt.execute(window);
        TestJoinBolt.printResults(collector);
        Assert.assertEquals((long)this.orders.length, (long)collector.actualResults.size());
    }

    @Test
    public void testLeftJoin() throws Exception {
        ArrayList<Tuple> userStream = TestJoinBolt.makeStream("users", this.userFields, this.users);
        ArrayList<Tuple> orderStream = TestJoinBolt.makeStream("orders", this.orderFields, this.orders);
        TupleWindow window = TestJoinBolt.makeTupleWindow(orderStream, userStream);
        JoinBolt bolt = new JoinBolt(JoinBolt.Selector.STREAM, "users", this.userFields[0]).leftJoin("orders", "userId", "users").select("userId,name,price");
        MockCollector collector = new MockCollector();
        bolt.prepare(null, null, (OutputCollector)collector);
        bolt.execute(window);
        TestJoinBolt.printResults(collector);
        Assert.assertEquals((long)12L, (long)collector.actualResults.size());
    }

    @Test
    public void testThreeStreamInnerJoin() throws Exception {
        ArrayList<Tuple> userStream = TestJoinBolt.makeStream("users", this.userFields, this.users);
        ArrayList<Tuple> storesStream = TestJoinBolt.makeStream("stores", this.storeFields, this.stores);
        ArrayList<Tuple> cityStream = TestJoinBolt.makeStream("cities", this.cityFields, this.cities);
        TupleWindow window = TestJoinBolt.makeTupleWindow(userStream, storesStream, cityStream);
        JoinBolt bolt = new JoinBolt(JoinBolt.Selector.STREAM, "users", this.userFields[2]).join("stores", "city", "users").join("cities", "cityName", "stores").select("name,storeName,city,country");
        MockCollector collector = new MockCollector();
        bolt.prepare(null, null, (OutputCollector)collector);
        bolt.execute(window);
        TestJoinBolt.printResults(collector);
        Assert.assertEquals((long)6L, (long)collector.actualResults.size());
    }

    @Test
    public void testThreeStreamLeftJoin_1() throws Exception {
        ArrayList<Tuple> userStream = TestJoinBolt.makeStream("users", this.userFields, this.users);
        ArrayList<Tuple> storesStream = TestJoinBolt.makeStream("stores", this.storeFields, this.stores);
        ArrayList<Tuple> cityStream = TestJoinBolt.makeStream("cities", this.cityFields, this.cities);
        TupleWindow window = TestJoinBolt.makeTupleWindow(userStream, cityStream, storesStream);
        JoinBolt bolt = new JoinBolt(JoinBolt.Selector.STREAM, "users", this.userFields[2]).leftJoin("stores", "city", "users").leftJoin("cities", "cityName", "users").select("name,storeName,city,country");
        MockCollector collector = new MockCollector();
        bolt.prepare(null, null, (OutputCollector)collector);
        bolt.execute(window);
        TestJoinBolt.printResults(collector);
        Assert.assertEquals((long)this.users.length, (long)collector.actualResults.size());
    }

    @Test
    public void testThreeStreamLeftJoin_2() throws Exception {
        ArrayList<Tuple> userStream = TestJoinBolt.makeStream("users", this.userFields, this.users);
        ArrayList<Tuple> storesStream = TestJoinBolt.makeStream("stores", this.storeFields, this.stores);
        ArrayList<Tuple> cityStream = TestJoinBolt.makeStream("cities", this.cityFields, this.cities);
        TupleWindow window = TestJoinBolt.makeTupleWindow(userStream, cityStream, storesStream);
        JoinBolt bolt = new JoinBolt(JoinBolt.Selector.STREAM, "users", "city").leftJoin("stores", "city", "users").leftJoin("cities", "cityName", "stores").select("name,storeName,city,country");
        MockCollector collector = new MockCollector();
        bolt.prepare(null, null, (OutputCollector)collector);
        bolt.execute(window);
        TestJoinBolt.printResults(collector);
        Assert.assertEquals((long)(this.stores.length + 1), (long)collector.actualResults.size());
    }

    @Test
    public void testThreeStreamMixedJoin() throws Exception {
        ArrayList<Tuple> userStream = TestJoinBolt.makeStream("users", this.userFields, this.users);
        ArrayList<Tuple> storesStream = TestJoinBolt.makeStream("stores", this.storeFields, this.stores);
        ArrayList<Tuple> cityStream = TestJoinBolt.makeStream("cities", this.cityFields, this.cities);
        TupleWindow window = TestJoinBolt.makeTupleWindow(userStream, cityStream, storesStream);
        JoinBolt bolt = new JoinBolt(JoinBolt.Selector.STREAM, "users", this.userFields[2]).join("stores", "city", "users").leftJoin("cities", "cityName", "users").select("name,storeName,city,country");
        MockCollector collector = new MockCollector();
        bolt.prepare(null, null, (OutputCollector)collector);
        bolt.execute(window);
        TestJoinBolt.printResults(collector);
        Assert.assertEquals((long)(this.stores.length + 1), (long)collector.actualResults.size());
    }

    private static void printResults(MockCollector collector) {
        int counter = 0;
        for (List<Object> rec : collector.actualResults) {
            System.out.print(++counter + ") ");
            for (Object field : rec) {
                System.out.print(field + ", ");
            }
            System.out.println("");
        }
    }

    private static TupleWindow makeTupleWindow(ArrayList<Tuple> stream) {
        return new TupleWindowImpl(stream, null, null);
    }

    private static TupleWindow makeTupleWindow(ArrayList<Tuple> ... streams) {
        ArrayList<Tuple> combined = null;
        for (int i = 0; i < streams.length; ++i) {
            if (i == 0) {
                combined = new ArrayList<Tuple>(streams[0]);
                continue;
            }
            combined.addAll(streams[i]);
        }
        return new TupleWindowImpl(combined, null, null);
    }

    private static ArrayList<Tuple> makeStream(String streamName, String[] fieldNames, Object[][] data) {
        ArrayList<Tuple> result = new ArrayList<Tuple>();
        MockContext mockContext = new MockContext(fieldNames);
        for (Object[] record : data) {
            TupleImpl rec = new TupleImpl((GeneralTopologyContext)mockContext, Arrays.asList(record), 0, streamName);
            result.add((Tuple)rec);
        }
        return result;
    }

    private static ArrayList<Tuple> makeNestedEventsStream(String streamName, String[] fieldNames, Object[][] records) {
        MockContext mockContext = new MockContext(new String[]{"outer"});
        ArrayList<Tuple> result = new ArrayList<Tuple>(records.length);
        for (Object[] record : records) {
            HashMap<String, Object> recordMap = new HashMap<String, Object>(fieldNames.length);
            for (int i = 0; i < fieldNames.length; ++i) {
                recordMap.put(fieldNames[i], record[i]);
            }
            ArrayList<HashMap<String, Object>> tupleValues = new ArrayList<HashMap<String, Object>>(1);
            tupleValues.add(recordMap);
            TupleImpl tuple = new TupleImpl((GeneralTopologyContext)mockContext, tupleValues, 0, streamName);
            result.add((Tuple)tuple);
        }
        return result;
    }

    static class MockContext
    extends GeneralTopologyContext {
        private final Fields fields;

        public MockContext(String[] fieldNames) {
            super(null, null, null, null, null, null);
            this.fields = new Fields(fieldNames);
        }

        public String getComponentId(int taskId) {
            return "component";
        }

        public Fields getComponentOutputFields(String componentId, String streamId) {
            return this.fields;
        }
    }

    static class MockCollector
    extends OutputCollector {
        public ArrayList<List<Object>> actualResults = new ArrayList();

        public MockCollector() {
            super(null);
        }

        public List<Integer> emit(Collection<Tuple> anchors, List<Object> tuple) {
            this.actualResults.add(tuple);
            return null;
        }
    }
}

