/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.dependency;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.storm.dependency.DependencyPropertiesParser;
import org.json.simple.JSONValue;
import org.junit.Assert;
import org.junit.Test;

public class DependencyPropertiesParserTest {
    private DependencyPropertiesParser sut = new DependencyPropertiesParser();

    @Test
    public void parseJarsProperties() throws Exception {
        List parsed = this.sut.parseJarsProperties("storm-core-1.0.0.jar,json-simple-1.1.jar");
        Assert.assertEquals((long)2L, (long)parsed.size());
        Assert.assertEquals((Object)"storm-core-1.0.0.jar", (Object)((File)parsed.get(0)).getName());
        Assert.assertEquals((Object)"json-simple-1.1.jar", (Object)((File)parsed.get(1)).getName());
    }

    @Test
    public void parseEmptyJarsProperties() throws Exception {
        List parsed = this.sut.parseJarsProperties("");
        Assert.assertEquals((long)0L, (long)parsed.size());
    }

    @Test
    public void parsePackagesProperties() throws Exception {
        HashMap<String, String> testInputMap = new HashMap<String, String>();
        testInputMap.put("org.apache.storm:storm-core:1.0.0", "storm-core-1.0.0.jar");
        testInputMap.put("com.googlecode.json-simple:json-simple:1.1", "json-simple-1.1.jar");
        String testJson = JSONValue.toJSONString(testInputMap);
        Map parsed = this.sut.parseArtifactsProperties(testJson);
        Assert.assertEquals((long)2L, (long)parsed.size());
        Assert.assertEquals((Object)"storm-core-1.0.0.jar", (Object)((File)parsed.get("org.apache.storm:storm-core:1.0.0")).getName());
        Assert.assertEquals((Object)"json-simple-1.1.jar", (Object)((File)parsed.get("com.googlecode.json-simple:json-simple:1.1")).getName());
    }

    @Test
    public void parseEmptyPackagesProperties() throws Exception {
        Map parsed = this.sut.parseArtifactsProperties("{}");
        Assert.assertEquals((long)0L, (long)parsed.size());
    }

    @Test(expected=RuntimeException.class)
    public void parsePackagesPropertiesWithBrokenJSON() throws Exception {
        this.sut.parseArtifactsProperties("{\"group:artifact:version\": \"a.jar\"");
    }
}

