/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.dependency;

import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.storm.blobstore.AtomicOutputStream;
import org.apache.storm.blobstore.ClientBlobStore;
import org.apache.storm.dependency.DependencyUploader;
import org.apache.storm.dependency.FileNotAvailableException;
import org.apache.storm.generated.AccessControl;
import org.apache.storm.generated.AccessControlType;
import org.apache.storm.generated.KeyNotFoundException;
import org.apache.storm.generated.ReadableBlobMeta;
import org.apache.storm.generated.SettableBlobMeta;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class DependencyUploaderTest {
    private DependencyUploader sut;
    private ClientBlobStore mockBlobStore;

    @Before
    public void setUp() throws Exception {
        this.sut = new DependencyUploader();
        this.mockBlobStore = (ClientBlobStore)Mockito.mock(ClientBlobStore.class);
        this.sut.setBlobStore(this.mockBlobStore);
        ((ClientBlobStore)Mockito.doNothing().when((Object)this.mockBlobStore)).shutdown();
    }

    @After
    public void tearDown() throws Exception {
        this.sut.shutdown();
    }

    @Test(expected=FileNotAvailableException.class)
    public void uploadFilesWhichOneOfThemIsNotFoundInLocal() throws Exception {
        File mockFile = (File)Mockito.mock(File.class);
        Mockito.when((Object)mockFile.isFile()).thenReturn((Object)true);
        Mockito.when((Object)mockFile.exists()).thenReturn((Object)true);
        File mockFile2 = (File)Mockito.mock(File.class);
        Mockito.when((Object)mockFile.isFile()).thenReturn((Object)true);
        Mockito.when((Object)mockFile.exists()).thenReturn((Object)false);
        ArrayList<File> dependencies = new ArrayList<File>();
        dependencies.add(mockFile);
        dependencies.add(mockFile2);
        this.sut.uploadFiles(dependencies, false);
        Assert.fail((String)"Should throw FileNotAvailableException");
    }

    @Test(expected=FileNotAvailableException.class)
    public void uploadFilesWhichOneOfThemIsNotFile() throws Exception {
        File mockFile = (File)Mockito.mock(File.class);
        Mockito.when((Object)mockFile.isFile()).thenReturn((Object)true);
        Mockito.when((Object)mockFile.exists()).thenReturn((Object)true);
        File mockFile2 = (File)Mockito.mock(File.class);
        Mockito.when((Object)mockFile.isFile()).thenReturn((Object)false);
        Mockito.when((Object)mockFile.exists()).thenReturn((Object)true);
        ArrayList dependencies = Lists.newArrayList((Object[])new File[]{mockFile, mockFile2});
        this.sut.uploadFiles((List)dependencies, false);
        Assert.fail((String)"Should throw FileNotAvailableException");
    }

    @Test
    public void uploadFilesWhichOneOfThemIsFailedToBeUploaded() throws Exception {
        File mockFile = this.createTemporaryDummyFile();
        File mockFile2 = (File)Mockito.mock(File.class);
        Mockito.when((Object)mockFile2.getName()).thenReturn((Object)"dummy.jar");
        Mockito.when((Object)mockFile2.isFile()).thenReturn((Object)true);
        Mockito.when((Object)mockFile2.exists()).thenReturn((Object)true);
        Mockito.when((Object)mockFile2.getPath()).thenThrow(new Throwable[]{new RuntimeException("just for test!")});
        Mockito.when((Object)mockFile2.toPath()).thenThrow(new Throwable[]{new RuntimeException("just for test!")});
        String mockFileFileNameWithoutExtension = Files.getNameWithoutExtension((String)mockFile.getName());
        String mockFile2FileNameWithoutExtension = Files.getNameWithoutExtension((String)mockFile2.getName());
        Mockito.when((Object)this.mockBlobStore.getBlobMeta(Matchers.contains((String)mockFileFileNameWithoutExtension))).thenReturn((Object)new ReadableBlobMeta());
        Mockito.when((Object)this.mockBlobStore.getBlobMeta(Matchers.contains((String)mockFile2FileNameWithoutExtension))).thenThrow(new Throwable[]{new KeyNotFoundException()});
        ArrayList dependencies = Lists.newArrayList((Object[])new File[]{mockFile, mockFile2});
        try {
            this.sut.uploadFiles((List)dependencies, true);
            Assert.fail((String)"Should pass RuntimeException");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        ((ClientBlobStore)Mockito.verify((Object)this.mockBlobStore)).getBlobMeta(Matchers.contains((String)mockFileFileNameWithoutExtension));
        ((ClientBlobStore)Mockito.verify((Object)this.mockBlobStore)).getBlobMeta(Matchers.contains((String)mockFile2FileNameWithoutExtension));
        ((ClientBlobStore)Mockito.verify((Object)this.mockBlobStore)).deleteBlob(Matchers.contains((String)mockFileFileNameWithoutExtension));
        ((ClientBlobStore)Mockito.verify((Object)this.mockBlobStore, (VerificationMode)Mockito.never())).deleteBlob(Matchers.contains((String)mockFile2FileNameWithoutExtension));
    }

    @Test
    public void uploadFiles() throws Exception {
        AtomicOutputStream mockOutputStream = (AtomicOutputStream)Mockito.mock(AtomicOutputStream.class);
        ((AtomicOutputStream)Mockito.doNothing().when((Object)mockOutputStream)).cancel();
        final AtomicInteger counter = new AtomicInteger();
        Answer incrementCounter = new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                counter.addAndGet(1);
                return null;
            }
        };
        ((AtomicOutputStream)Mockito.doAnswer((Answer)incrementCounter).when((Object)mockOutputStream)).write(Matchers.anyInt());
        ((AtomicOutputStream)Mockito.doAnswer((Answer)incrementCounter).when((Object)mockOutputStream)).write((byte[])Matchers.any(byte[].class));
        ((AtomicOutputStream)Mockito.doAnswer((Answer)incrementCounter).when((Object)mockOutputStream)).write((byte[])Matchers.any(byte[].class), Matchers.anyInt(), Matchers.anyInt());
        ((AtomicOutputStream)Mockito.doNothing().when((Object)mockOutputStream)).close();
        Mockito.when((Object)this.mockBlobStore.getBlobMeta(Matchers.anyString())).thenThrow(new Throwable[]{new KeyNotFoundException()});
        Mockito.when((Object)this.mockBlobStore.createBlob(Matchers.anyString(), (SettableBlobMeta)Matchers.any(SettableBlobMeta.class))).thenReturn((Object)mockOutputStream);
        File mockFile = this.createTemporaryDummyFile();
        String mockFileFileNameWithoutExtension = Files.getNameWithoutExtension((String)mockFile.getName());
        List keys = this.sut.uploadFiles((List)Lists.newArrayList((Object[])new File[]{mockFile}), false);
        Assert.assertEquals((long)1L, (long)keys.size());
        Assert.assertTrue((boolean)((String)keys.get(0)).contains(mockFileFileNameWithoutExtension));
        Assert.assertTrue((counter.get() > 0 ? 1 : 0) != 0);
        ((AtomicOutputStream)Mockito.verify((Object)mockOutputStream)).close();
        ArgumentCaptor blobMetaArgumentCaptor = ArgumentCaptor.forClass(SettableBlobMeta.class);
        ((ClientBlobStore)Mockito.verify((Object)this.mockBlobStore)).createBlob(Matchers.anyString(), (SettableBlobMeta)blobMetaArgumentCaptor.capture());
        SettableBlobMeta actualBlobMeta = (SettableBlobMeta)blobMetaArgumentCaptor.getValue();
        List actualAcls = actualBlobMeta.get_acl();
        Assert.assertTrue((boolean)actualAcls.contains(new AccessControl(AccessControlType.USER, 7)));
        Assert.assertTrue((boolean)actualAcls.contains(new AccessControl(AccessControlType.OTHER, 1)));
    }

    @Test(expected=FileNotAvailableException.class)
    public void uploadArtifactsWhichOneOfThemIsNotFoundInLocal() throws Exception {
        File mockFile = (File)Mockito.mock(File.class);
        Mockito.when((Object)mockFile.isFile()).thenReturn((Object)true);
        Mockito.when((Object)mockFile.exists()).thenReturn((Object)true);
        File mockFile2 = (File)Mockito.mock(File.class);
        Mockito.when((Object)mockFile.isFile()).thenReturn((Object)true);
        Mockito.when((Object)mockFile.exists()).thenReturn((Object)false);
        LinkedHashMap<String, File> artifacts = new LinkedHashMap<String, File>();
        artifacts.put("group:artifact:1.0.0", mockFile);
        artifacts.put("group:artifact:1.1.0", mockFile2);
        this.sut.uploadArtifacts(artifacts);
        Assert.fail((String)"Should throw FileNotAvailableException");
    }

    @Test(expected=FileNotAvailableException.class)
    public void uploadArtifactsWhichOneOfThemIsNotFile() throws Exception {
        File mockFile = (File)Mockito.mock(File.class);
        Mockito.when((Object)mockFile.isFile()).thenReturn((Object)true);
        Mockito.when((Object)mockFile.exists()).thenReturn((Object)true);
        File mockFile2 = (File)Mockito.mock(File.class);
        Mockito.when((Object)mockFile.isFile()).thenReturn((Object)false);
        Mockito.when((Object)mockFile.exists()).thenReturn((Object)true);
        LinkedHashMap<String, File> artifacts = new LinkedHashMap<String, File>();
        artifacts.put("group:artifact:1.0.0", mockFile);
        artifacts.put("group:artifact:1.1.0", mockFile2);
        this.sut.uploadArtifacts(artifacts);
        Assert.fail((String)"Should throw FileNotAvailableException");
    }

    @Test
    public void uploadArtifactsWhichOneOfThemIsFailedToBeUploaded() throws Exception {
        String artifact = "group:artifact:1.0.0";
        String expectedBlobKeyForArtifact = "group-artifact-1.0.0.jar";
        File mockFile = this.createTemporaryDummyFile();
        String artifact2 = "group:artifact2:2.0.0";
        String expectedBlobKeyForArtifact2 = "group-artifact2-2.0.0.jar";
        File mockFile2 = (File)Mockito.mock(File.class);
        Mockito.when((Object)mockFile2.getName()).thenReturn((Object)"dummy.jar");
        Mockito.when((Object)mockFile2.isFile()).thenReturn((Object)true);
        Mockito.when((Object)mockFile2.exists()).thenReturn((Object)true);
        Mockito.when((Object)mockFile2.getPath()).thenThrow(new Throwable[]{new RuntimeException("just for test!")});
        Mockito.when((Object)mockFile2.toPath()).thenThrow(new Throwable[]{new RuntimeException("just for test!")});
        Mockito.when((Object)this.mockBlobStore.getBlobMeta(Matchers.contains((String)expectedBlobKeyForArtifact))).thenReturn((Object)new ReadableBlobMeta());
        Mockito.when((Object)this.mockBlobStore.getBlobMeta(Matchers.contains((String)expectedBlobKeyForArtifact2))).thenThrow(new Throwable[]{new KeyNotFoundException()});
        LinkedHashMap<String, File> artifacts = new LinkedHashMap<String, File>();
        artifacts.put(artifact, mockFile);
        artifacts.put(artifact2, mockFile2);
        try {
            this.sut.uploadArtifacts(artifacts);
            Assert.fail((String)"Should pass RuntimeException");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        ((ClientBlobStore)Mockito.verify((Object)this.mockBlobStore)).getBlobMeta(Matchers.contains((String)expectedBlobKeyForArtifact));
        ((ClientBlobStore)Mockito.verify((Object)this.mockBlobStore)).getBlobMeta(Matchers.contains((String)expectedBlobKeyForArtifact2));
        ((ClientBlobStore)Mockito.verify((Object)this.mockBlobStore, (VerificationMode)Mockito.never())).deleteBlob(Matchers.contains((String)expectedBlobKeyForArtifact));
        ((ClientBlobStore)Mockito.verify((Object)this.mockBlobStore, (VerificationMode)Mockito.never())).deleteBlob(Matchers.contains((String)expectedBlobKeyForArtifact2));
    }

    @Test
    public void uploadArtifacts() throws Exception {
        AtomicOutputStream mockOutputStream = (AtomicOutputStream)Mockito.mock(AtomicOutputStream.class);
        ((AtomicOutputStream)Mockito.doNothing().when((Object)mockOutputStream)).cancel();
        final AtomicInteger counter = new AtomicInteger();
        Answer incrementCounter = new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                counter.addAndGet(1);
                return null;
            }
        };
        ((AtomicOutputStream)Mockito.doAnswer((Answer)incrementCounter).when((Object)mockOutputStream)).write(Matchers.anyInt());
        ((AtomicOutputStream)Mockito.doAnswer((Answer)incrementCounter).when((Object)mockOutputStream)).write((byte[])Matchers.any(byte[].class));
        ((AtomicOutputStream)Mockito.doAnswer((Answer)incrementCounter).when((Object)mockOutputStream)).write((byte[])Matchers.any(byte[].class), Matchers.anyInt(), Matchers.anyInt());
        ((AtomicOutputStream)Mockito.doNothing().when((Object)mockOutputStream)).close();
        Mockito.when((Object)this.mockBlobStore.getBlobMeta(Matchers.anyString())).thenThrow(new Throwable[]{new KeyNotFoundException()});
        Mockito.when((Object)this.mockBlobStore.createBlob(Matchers.anyString(), (SettableBlobMeta)Matchers.any(SettableBlobMeta.class))).thenReturn((Object)mockOutputStream);
        String artifact = "group:artifact:1.0.0";
        String expectedBlobKeyForArtifact = "group-artifact-1.0.0.jar";
        File mockFile = this.createTemporaryDummyFile();
        LinkedHashMap<String, File> artifacts = new LinkedHashMap<String, File>();
        artifacts.put(artifact, mockFile);
        List keys = this.sut.uploadArtifacts(artifacts);
        Assert.assertEquals((long)1L, (long)keys.size());
        Assert.assertTrue((boolean)((String)keys.get(0)).contains(expectedBlobKeyForArtifact));
        Assert.assertTrue((counter.get() > 0 ? 1 : 0) != 0);
        ((AtomicOutputStream)Mockito.verify((Object)mockOutputStream)).close();
    }

    private File createTemporaryDummyFile() throws IOException {
        File tempFile = File.createTempFile("tempfile", ".tmp");
        BufferedWriter bw = new BufferedWriter(new FileWriter(tempFile));
        bw.write("This is the temporary file content");
        bw.close();
        return tempFile;
    }
}

