/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.executor.error;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.storm.cluster.IStormClusterState;
import org.apache.storm.executor.error.ReportError;
import org.apache.storm.task.WorkerTopologyContext;
import org.apache.storm.utils.Time;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class ReportErrorTest {
    @Test
    public void testReport() {
        String topo = "topology";
        String comp = "component";
        Long port = new Long(8080L);
        AtomicLong errorCount = new AtomicLong(0L);
        WorkerTopologyContext context = (WorkerTopologyContext)Mockito.mock(WorkerTopologyContext.class);
        Mockito.when((Object)context.getThisWorkerPort()).thenReturn((Object)port.intValue());
        IStormClusterState state = (IStormClusterState)Mockito.mock(IStormClusterState.class);
        ((IStormClusterState)Mockito.doAnswer(invocation -> errorCount.incrementAndGet()).when((Object)state)).reportError((String)Mockito.eq((Object)"topology"), (String)Mockito.eq((Object)"component"), (String)Mockito.any(String.class), (Long)Mockito.eq((Object)port), (Throwable)Mockito.any(Throwable.class));
        HashMap<String, Integer> conf = new HashMap<String, Integer>();
        conf.put("topology.error.throttle.interval.secs", 10);
        conf.put("topology.max.error.report.per.interval", 4);
        try (Time.SimulatedTime t = new Time.SimulatedTime();){
            ReportError report = new ReportError(conf, state, "topology", "component", context);
            report.report((Throwable)new RuntimeException("ERROR-1"));
            Assert.assertEquals((long)1L, (long)errorCount.get());
            report.report((Throwable)new RuntimeException("ERROR-2"));
            Assert.assertEquals((long)2L, (long)errorCount.get());
            report.report((Throwable)new RuntimeException("ERROR-3"));
            Assert.assertEquals((long)3L, (long)errorCount.get());
            report.report((Throwable)new RuntimeException("ERROR-4"));
            Assert.assertEquals((long)4L, (long)errorCount.get());
            report.report((Throwable)new RuntimeException("ERROR-5"));
            Assert.assertEquals((long)4L, (long)errorCount.get());
            Time.advanceTime((long)9000L);
            report.report((Throwable)new RuntimeException("ERROR-6"));
            Assert.assertEquals((long)4L, (long)errorCount.get());
            Time.advanceTime((long)2000L);
            report.report((Throwable)new RuntimeException("ERROR-7"));
            Assert.assertEquals((long)5L, (long)errorCount.get());
        }
    }
}

