/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.metric.internal;

import java.util.HashMap;
import junit.framework.TestCase;
import org.apache.storm.metric.internal.CountStatAndMetric;
import org.junit.Test;

public class CountStatAndMetricTest
extends TestCase {
    final long TEN_MIN = 600000L;
    final long THIRTY_SEC = 30000L;
    final long THREE_HOUR = 10800000L;
    final long ONE_DAY = 86400000L;

    @Test
    public void testBasic() {
        long time = 0L;
        CountStatAndMetric count = new CountStatAndMetric(10, time);
        while (time < 600000L) {
            count.incBy(50L);
            count.rotateSched(time += 15000L);
            count.incBy(50L);
            CountStatAndMetricTest.assertEquals((long)100L, (long)((Long)count.getValueAndReset(time += 15000L)));
        }
        long val = 2000L;
        HashMap<String, Long> expected = new HashMap<String, Long>();
        expected.put("600", val);
        expected.put("10800", val);
        expected.put("86400", val);
        expected.put(":all-time", val);
        CountStatAndMetricTest.assertEquals(expected, (Object)count.getTimeCounts(time));
        while (time < 10800000L) {
            count.incBy(100L);
            CountStatAndMetricTest.assertEquals((long)100L, (long)((Long)count.getValueAndReset(time += 30000L)));
        }
        val = 36000L;
        expected = new HashMap();
        expected.put("600", 2000L);
        expected.put("10800", val);
        expected.put("86400", val);
        expected.put(":all-time", val);
        CountStatAndMetricTest.assertEquals(expected, (Object)count.getTimeCounts(time));
        while (time < 86400000L) {
            count.incBy(100L);
            CountStatAndMetricTest.assertEquals((long)100L, (long)((Long)count.getValueAndReset(time += 30000L)));
        }
        val = 288000L;
        expected = new HashMap();
        expected.put("600", 2000L);
        expected.put("10800", 36000L);
        expected.put("86400", val);
        expected.put(":all-time", val);
        CountStatAndMetricTest.assertEquals(expected, (Object)count.getTimeCounts(time));
    }
}

