/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.metric.internal;

import java.util.Map;
import junit.framework.TestCase;
import org.apache.storm.metric.internal.LatencyStatAndMetric;
import org.junit.Test;

public class LatencyStatAndMetricTest
extends TestCase {
    final long TEN_MIN = 600000L;
    final long THIRTY_SEC = 30000L;
    final long THREE_HOUR = 10800000L;
    final long ONE_DAY = 86400000L;

    @Test
    public void testBasic() {
        long time = 0L;
        LatencyStatAndMetric lat = new LatencyStatAndMetric(10, time);
        while (time < 600000L) {
            lat.record(100L);
            LatencyStatAndMetricTest.assertEquals((double)100.0, (double)((Double)lat.getValueAndReset(time += 30000L)), (double)0.01);
        }
        Map found = lat.getTimeLatAvg(time);
        LatencyStatAndMetricTest.assertEquals((int)4, (int)found.size());
        LatencyStatAndMetricTest.assertEquals((double)100.0, (double)((Double)found.get("600")), (double)0.01);
        LatencyStatAndMetricTest.assertEquals((double)100.0, (double)((Double)found.get("10800")), (double)0.01);
        LatencyStatAndMetricTest.assertEquals((double)100.0, (double)((Double)found.get("86400")), (double)0.01);
        LatencyStatAndMetricTest.assertEquals((double)100.0, (double)((Double)found.get(":all-time")), (double)0.01);
        while (time < 10800000L) {
            lat.record(200L);
            LatencyStatAndMetricTest.assertEquals((double)200.0, (double)((Double)lat.getValueAndReset(time += 30000L)), (double)0.01);
        }
        double expected = 194.44444444444446;
        found = lat.getTimeLatAvg(time);
        LatencyStatAndMetricTest.assertEquals((int)4, (int)found.size());
        LatencyStatAndMetricTest.assertEquals((double)200.0, (double)((Double)found.get("600")), (double)0.01);
        LatencyStatAndMetricTest.assertEquals((double)expected, (double)((Double)found.get("10800")), (double)0.01);
        LatencyStatAndMetricTest.assertEquals((double)expected, (double)((Double)found.get("86400")), (double)0.01);
        LatencyStatAndMetricTest.assertEquals((double)expected, (double)((Double)found.get(":all-time")), (double)0.01);
        while (time < 86400000L) {
            lat.record(300L);
            LatencyStatAndMetricTest.assertEquals((double)300.0, (double)((Double)lat.getValueAndReset(time += 30000L)), (double)0.01);
        }
        expected = 286.80555555555554;
        found = lat.getTimeLatAvg(time);
        LatencyStatAndMetricTest.assertEquals((int)4, (int)found.size());
        LatencyStatAndMetricTest.assertEquals((double)300.0, (double)((Double)found.get("600")), (double)0.01);
        LatencyStatAndMetricTest.assertEquals((double)300.0, (double)((Double)found.get("10800")), (double)0.01);
        LatencyStatAndMetricTest.assertEquals((double)expected, (double)((Double)found.get("86400")), (double)0.01);
        LatencyStatAndMetricTest.assertEquals((double)expected, (double)((Double)found.get(":all-time")), (double)0.01);
    }
}

