/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.metric.internal;

import junit.framework.TestCase;
import org.apache.storm.metric.internal.RateTracker;
import org.junit.Test;

public class RateTrackerTest
extends TestCase {
    @Test
    public void testExactRate() {
        double actual;
        double exp;
        int i;
        long interval = 1000L;
        long time = 0L;
        RateTracker rt = new RateTracker(10000, 10, time);
        double[] expected = new double[]{10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0};
        for (i = 0; i < expected.length; ++i) {
            exp = expected[i];
            rt.notify(10L);
            actual = rt.reportRate(time += 1000L);
            rt.forceRotate(1, 1000L);
            RateTrackerTest.assertEquals((String)("Expected rate on iteration " + i + " is wrong."), (double)exp, (double)actual, (double)1.0E-5);
        }
        expected = new double[]{11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0};
        for (i = 0; i < expected.length; ++i) {
            exp = expected[i];
            rt.notify(20L);
            actual = rt.reportRate(time += 1000L);
            rt.forceRotate(1, 1000L);
            RateTrackerTest.assertEquals((String)("Expected rate on iteration " + i + " is wrong."), (double)exp, (double)actual, (double)1.0E-5);
        }
    }

    @Test
    public void testEclipsedAllWindows() {
        long time = 0L;
        RateTracker rt = new RateTracker(10000, 10, time);
        rt.notify(10L);
        rt.forceRotate(10, 1000L);
        RateTrackerTest.assertEquals((double)0.0, (double)rt.reportRate(10000L), (double)1.0E-5);
    }

    @Test
    public void testEclipsedOneWindow() {
        long time = 0L;
        RateTracker rt = new RateTracker(10000, 10, time);
        rt.notify(1L);
        double r1 = rt.reportRate(1000L);
        rt.forceRotate(1, 1000L);
        rt.notify(1L);
        double r2 = rt.reportRate(2000L);
        RateTrackerTest.assertEquals((double)r1, (double)r2, (double)1.0E-5);
    }

    @Test
    public void testEclipsedNineWindows() {
        long time = 0L;
        RateTracker rt = new RateTracker(10000, 10, time);
        rt.notify(1L);
        double r1 = rt.reportRate(1000L);
        rt.forceRotate(9, 1000L);
        rt.notify(9L);
        double r2 = rt.reportRate(10000L);
        RateTrackerTest.assertEquals((double)r1, (double)r2, (double)1.0E-5);
    }
}

