/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.security.auth;

import java.io.File;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.security.auth.Subject;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.apache.commons.codec.binary.Hex;
import org.apache.storm.security.auth.AuthUtils;
import org.apache.storm.security.auth.AuthUtilsTestMock;
import org.apache.storm.security.auth.IAutoCredentials;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class AuthUtilsTest {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();

    @Test(expected=IOException.class)
    public void getOptionsThrowsOnMissingSectionTest() throws IOException {
        Configuration mockConfig = (Configuration)Mockito.mock(Configuration.class);
        AuthUtils.get((Configuration)mockConfig, (String)"bogus-section", (String)"");
    }

    @Test
    public void getNonExistentSectionTest() throws IOException {
        HashMap optionMap = new HashMap();
        AppConfigurationEntry entry = (AppConfigurationEntry)Mockito.mock(AppConfigurationEntry.class);
        Mockito.when(entry.getOptions()).thenReturn(optionMap);
        String section = "bogus-section";
        Configuration mockConfig = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)mockConfig.getAppConfigurationEntry(section)).thenReturn((Object)new AppConfigurationEntry[]{entry});
        Assert.assertNull((Object)AuthUtils.get((Configuration)mockConfig, (String)section, (String)"nonexistent-key"));
    }

    @Test
    public void getFirstValueForValidKeyTest() throws IOException {
        String k = "the-key";
        String expected = "good-value";
        HashMap<String, String> optionMap = new HashMap<String, String>();
        optionMap.put(k, expected);
        HashMap<String, String> badOptionMap = new HashMap<String, String>();
        badOptionMap.put(k, "bad-value");
        AppConfigurationEntry emptyEntry = (AppConfigurationEntry)Mockito.mock(AppConfigurationEntry.class);
        AppConfigurationEntry badEntry = (AppConfigurationEntry)Mockito.mock(AppConfigurationEntry.class);
        AppConfigurationEntry goodEntry = (AppConfigurationEntry)Mockito.mock(AppConfigurationEntry.class);
        Mockito.when(emptyEntry.getOptions()).thenReturn(new HashMap());
        Mockito.when(badEntry.getOptions()).thenReturn(badOptionMap);
        Mockito.when(goodEntry.getOptions()).thenReturn(optionMap);
        String section = "bogus-section";
        Configuration mockConfig = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)mockConfig.getAppConfigurationEntry(section)).thenReturn((Object)new AppConfigurationEntry[]{emptyEntry, goodEntry, badEntry});
        Assert.assertEquals((Object)AuthUtils.get((Configuration)mockConfig, (String)section, (String)k), (Object)expected);
    }

    @Test
    public void objGettersReturnNullWithNullConfigTest() throws IOException {
        Assert.assertNull((Object)AuthUtils.pullConfig(null, (String)"foo"));
        Assert.assertNull((Object)AuthUtils.get(null, (String)"foo", (String)"bar"));
        Assert.assertNull((Object)AuthUtils.GetConfiguration(Collections.emptyMap()));
    }

    @Test
    public void getAutoCredentialsTest() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        map.put("topology.auto-credentials", Arrays.asList("org.apache.storm.security.auth.AuthUtilsTestMock"));
        Assert.assertTrue((boolean)AuthUtils.GetAutoCredentials(Collections.emptyMap()).isEmpty());
        Assert.assertEquals((long)AuthUtils.GetAutoCredentials(map).size(), (long)1L);
    }

    @Test
    public void getNimbusAutoCredPluginTest() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        map.put("nimbus.autocredential.plugins.classes", Arrays.asList("org.apache.storm.security.auth.AuthUtilsTestMock"));
        Assert.assertTrue((boolean)AuthUtils.getNimbusAutoCredPlugins(Collections.emptyMap()).isEmpty());
        Assert.assertEquals((long)AuthUtils.getNimbusAutoCredPlugins(map).size(), (long)1L);
    }

    @Test
    public void GetCredentialRenewersTest() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        map.put("nimbus.credential.renewers.classes", Arrays.asList("org.apache.storm.security.auth.AuthUtilsTestMock"));
        Assert.assertTrue((boolean)AuthUtils.GetCredentialRenewers(Collections.emptyMap()).isEmpty());
        Assert.assertEquals((long)AuthUtils.GetCredentialRenewers(map).size(), (long)1L);
    }

    @Test
    public void populateSubjectTest() {
        AuthUtilsTestMock autoCred = (AuthUtilsTestMock)Mockito.mock(AuthUtilsTestMock.class);
        Subject subject = new Subject();
        HashMap<String, String> cred = new HashMap<String, String>();
        List<IAutoCredentials> autos = Arrays.asList(autoCred);
        AuthUtils.populateSubject((Subject)subject, autos, cred);
        ((AuthUtilsTestMock)Mockito.verify((Object)autoCred, (VerificationMode)Mockito.times((int)1))).populateSubject(subject, cred);
    }

    @Test
    public void makeDigestPayloadTest() throws NoSuchAlgorithmException {
        String section = "user-pass-section";
        HashMap<String, String> optionMap = new HashMap<String, String>();
        String user = "user";
        String pass = "pass";
        optionMap.put("username", user);
        optionMap.put("password", pass);
        AppConfigurationEntry entry = (AppConfigurationEntry)Mockito.mock(AppConfigurationEntry.class);
        Mockito.when(entry.getOptions()).thenReturn(optionMap);
        Configuration mockConfig = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)mockConfig.getAppConfigurationEntry(section)).thenReturn((Object)new AppConfigurationEntry[]{entry});
        MessageDigest digest = MessageDigest.getInstance("SHA-512");
        byte[] output = digest.digest((user + ":" + pass).getBytes());
        String sha = Hex.encodeHexString((byte[])output);
        StringBuilder builder = new StringBuilder();
        for (byte b : output) {
            builder.append(String.format("%02x", b));
        }
        String stringFormatMethod = builder.toString();
        Assert.assertEquals((Object)AuthUtils.makeDigestPayload((Configuration)mockConfig, (String)"user-pass-section"), (Object)sha);
        Assert.assertEquals((Object)sha, (Object)stringFormatMethod);
    }

    @Test(expected=RuntimeException.class)
    public void invalidConfigResultsInIOException() throws RuntimeException {
        HashMap<String, String> conf = new HashMap<String, String>();
        conf.put("java.security.auth.login.config", "__FAKE_FILE__");
        Assert.assertNotNull((Object)AuthUtils.GetConfiguration(conf));
    }

    @Test
    public void validConfigResultsInNotNullConfigurationTest() throws IOException {
        File file1 = this.folder.newFile("mockfile.txt");
        HashMap<String, String> conf = new HashMap<String, String>();
        conf.put("java.security.auth.login.config", file1.getAbsolutePath());
        Assert.assertNotNull((Object)AuthUtils.GetConfiguration(conf));
    }

    @Test
    public void uiHttpCredentialsPluginTest() {
        HashMap<String, String> conf = new HashMap<String, String>();
        conf.put("ui.http.creds.plugin", "org.apache.storm.security.auth.AuthUtilsTestMock");
        conf.put("drpc.http.creds.plugin", "org.apache.storm.security.auth.AuthUtilsTestMock");
        conf.put("storm.principal.tolocal", "org.apache.storm.security.auth.AuthUtilsTestMock");
        conf.put("storm.group.mapping.service", "org.apache.storm.security.auth.AuthUtilsTestMock");
        Assert.assertTrue((AuthUtils.GetUiHttpCredentialsPlugin(conf).getClass() == AuthUtilsTestMock.class ? 1 : 0) != 0);
        Assert.assertTrue((AuthUtils.GetDrpcHttpCredentialsPlugin(conf).getClass() == AuthUtilsTestMock.class ? 1 : 0) != 0);
        Assert.assertTrue((AuthUtils.GetPrincipalToLocalPlugin(conf).getClass() == AuthUtilsTestMock.class ? 1 : 0) != 0);
        Assert.assertTrue((AuthUtils.GetGroupMappingServiceProviderPlugin(conf).getClass() == AuthUtilsTestMock.class ? 1 : 0) != 0);
    }

    @Test(expected=RuntimeException.class)
    public void updateSubjectWithNullThrowsTest() {
        AuthUtils.updateSubject(null, null, null);
    }

    @Test(expected=RuntimeException.class)
    public void updateSubjectWithNullAutosThrowsTest() {
        AuthUtils.updateSubject((Subject)new Subject(), null, null);
    }

    @Test
    public void updateSubjectWithNullAutosTest() {
        AuthUtilsTestMock mock = (AuthUtilsTestMock)Mockito.mock(AuthUtilsTestMock.class);
        List<IAutoCredentials> autos = Arrays.asList(mock);
        Subject s = new Subject();
        AuthUtils.updateSubject((Subject)s, autos, null);
        ((AuthUtilsTestMock)Mockito.verify((Object)mock, (VerificationMode)Mockito.times((int)1))).updateSubject(s, null);
    }
}

