/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.security.auth;

import com.google.common.collect.ImmutableSet;
import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import org.apache.storm.security.auth.DefaultHttpCredentialsPlugin;
import org.apache.storm.security.auth.ReqContext;
import org.apache.storm.security.auth.SingleUserPrincipal;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class DefaultHttpCredentialsPluginTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test_getUserName() {
        DefaultHttpCredentialsPlugin handler = new DefaultHttpCredentialsPlugin();
        handler.prepare(new HashMap());
        Assert.assertNull((String)"returns null when request is null", (Object)handler.getUserName(null));
        Assert.assertNull((String)"returns null when user principal is null", (Object)handler.getUserName((HttpServletRequest)Mockito.mock(HttpServletRequest.class)));
        HttpServletRequest mockRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)mockRequest.getUserPrincipal()).thenReturn((Object)new SingleUserPrincipal(""));
        Assert.assertNull((String)"returns null when user is blank", (Object)handler.getUserName(mockRequest));
        String expName = "Alice";
        mockRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)mockRequest.getUserPrincipal()).thenReturn((Object)new SingleUserPrincipal(expName));
        Assert.assertEquals((String)"returns correct user from requests principal", (Object)expName, (Object)handler.getUserName(mockRequest));
        try {
            String doAsUserName = "Bob";
            mockRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)mockRequest.getUserPrincipal()).thenReturn((Object)new SingleUserPrincipal(expName));
            Mockito.when((Object)mockRequest.getHeader("doAsUser")).thenReturn((Object)doAsUserName);
            ReqContext context = handler.populateContext(ReqContext.context(), mockRequest);
            Assert.assertTrue((boolean)context.isImpersonating());
            Assert.assertEquals((Object)expName, (Object)context.realPrincipal().getName());
            Assert.assertEquals((Object)doAsUserName, (Object)context.principal().getName());
        }
        finally {
            ReqContext.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test_populate_req_context_on_null_user() {
        try {
            DefaultHttpCredentialsPlugin handler = new DefaultHttpCredentialsPlugin();
            handler.prepare(new HashMap());
            Subject subject = new Subject(false, (Set<? extends Principal>)ImmutableSet.of((Object)new SingleUserPrincipal("test")), new HashSet(), new HashSet());
            ReqContext context = new ReqContext(subject);
            Assert.assertEquals((long)0L, (long)handler.populateContext(context, (HttpServletRequest)Mockito.mock(HttpServletRequest.class)).subject().getPrincipals().size());
        }
        finally {
            ReqContext.reset();
        }
    }
}

