/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.security.auth;

import com.google.common.collect.ImmutableSet;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Principal;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.storm.security.auth.ReqContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ReqContextTest {
    private ReqContext rc;

    @Before
    public void setup() {
        this.rc = ReqContext.context();
    }

    @Test
    public void testSubject() {
        Subject expected = new Subject();
        Assert.assertFalse((boolean)expected.isReadOnly());
        this.rc.setSubject(expected);
        Assert.assertEquals((Object)expected, (Object)this.rc.subject());
        expected.setReadOnly();
        this.rc.setSubject(expected);
        Assert.assertEquals((Object)expected, (Object)this.rc.subject());
    }

    @Test
    public void testRemoteAddress() throws UnknownHostException {
        InetAddress expected = InetAddress.getByAddress("ABCD".getBytes());
        this.rc.setRemoteAddress(expected);
        Assert.assertEquals((Object)expected, (Object)this.rc.remoteAddress());
    }

    @Test
    public void testPrincipalReturnsNullWhenNoSubject() {
        this.rc.setSubject(new Subject());
        Assert.assertNull((Object)this.rc.principal());
    }

    @Test
    public void testPrincipal() {
        String principalName = "Test Principal";
        Principal testPrincipal = new Principal(){

            @Override
            public String getName() {
                return "Test Principal";
            }
        };
        ImmutableSet principals = ImmutableSet.of((Object)testPrincipal);
        Subject subject = new Subject(false, (Set<? extends Principal>)principals, new HashSet(), new HashSet());
        this.rc.setSubject(subject);
        Assert.assertNotNull((Object)this.rc.principal());
        Assert.assertEquals((Object)"Test Principal", (Object)this.rc.principal().getName());
        this.rc.setSubject(null);
    }
}

