/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.security.auth;

import java.util.Map;
import org.apache.storm.security.auth.ThriftClient;
import org.apache.storm.security.auth.ThriftConnectionType;
import org.apache.storm.utils.ThrowableNestedCauseMatcher;
import org.apache.storm.utils.Utils;
import org.apache.thrift.transport.TTransportException;
import org.hamcrest.Matcher;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ThriftClientTest {
    private int NIMBUS_TIMEOUT = 3000;
    private Map<String, Object> conf;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void setup() {
        this.conf = Utils.readDefaultConfig();
        this.conf.put("storm.nimbus.retry.times", 0);
    }

    @Test
    public void testConstructorThrowsIfPortNegative() {
        this.expectedException.expect((Matcher)ThrowableNestedCauseMatcher.isCausedBy(IllegalArgumentException.class));
        new ThriftClient(this.conf, ThriftConnectionType.DRPC, "bogushost", Integer.valueOf(-1), Integer.valueOf(this.NIMBUS_TIMEOUT));
    }

    @Test
    public void testConstructorThrowsIfPortZero() {
        this.expectedException.expect((Matcher)ThrowableNestedCauseMatcher.isCausedBy(IllegalArgumentException.class));
        new ThriftClient(this.conf, ThriftConnectionType.DRPC, "bogushost", Integer.valueOf(0), Integer.valueOf(this.NIMBUS_TIMEOUT));
    }

    @Test
    public void testConstructorThrowsIfHostNull() {
        this.expectedException.expect((Matcher)ThrowableNestedCauseMatcher.isCausedBy(IllegalArgumentException.class));
        new ThriftClient(this.conf, ThriftConnectionType.DRPC, null, Integer.valueOf(4242), Integer.valueOf(this.NIMBUS_TIMEOUT));
    }

    @Test
    public void testConstructorThrowsIfHostEmpty() {
        this.expectedException.expect((Matcher)ThrowableNestedCauseMatcher.isCausedBy(TTransportException.class));
        new ThriftClient(this.conf, ThriftConnectionType.DRPC, "", Integer.valueOf(4242), Integer.valueOf(this.NIMBUS_TIMEOUT));
    }
}

