/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.security.auth.authorizer;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import org.apache.storm.security.auth.IAuthorizer;
import org.apache.storm.security.auth.KerberosPrincipalToLocal;
import org.apache.storm.security.auth.ReqContext;
import org.apache.storm.security.auth.SingleUserPrincipal;
import org.apache.storm.security.auth.authorizer.DRPCSimpleACLAuthorizer;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;

public class DRPCSimpleACLAuthorizerTest {
    private static IAuthorizer strictHandler;
    private static IAuthorizer permissiveHandler;
    private static final String function = "jump";
    private static final String partialFunction = "partial";
    private static final String wrongFunction = "wrongFunction";
    private static final String aclFile = "drpc-simple-acl-test-scenario.yaml";
    private static final ReqContext aliceContext;
    private static final ReqContext aliceKerbContext;
    private static final ReqContext bobContext;
    private static final ReqContext charlieContext;

    @BeforeClass
    public static void setup() {
        strictHandler = new DRPCSimpleACLAuthorizer();
        strictHandler.prepare((Map)ImmutableMap.of((Object)"drpc.authorizer.acl.strict", (Object)true, (Object)"drpc.authorizer.acl.filename", (Object)aclFile, (Object)"storm.principal.tolocal", (Object)KerberosPrincipalToLocal.class.getName()));
        permissiveHandler = new DRPCSimpleACLAuthorizer();
        permissiveHandler.prepare((Map)ImmutableMap.of((Object)"drpc.authorizer.acl.strict", (Object)false, (Object)"drpc.authorizer.acl.filename", (Object)aclFile, (Object)"storm.principal.tolocal", (Object)KerberosPrincipalToLocal.class.getName()));
    }

    @Test
    public void test_partial_authorization() {
        Assert.assertFalse((String)"Deny execute to unauthroized user", (boolean)this.isPermitted(strictHandler, ReqContext.context(), "execute", partialFunction));
        Assert.assertTrue((String)"Allow execute to authorized kerb user for correct function", (boolean)this.isPermitted(strictHandler, aliceKerbContext, "execute", partialFunction));
        Assert.assertFalse((String)"Deny fetchRequest to unauthorized user for correct function", (boolean)this.isPermitted(strictHandler, aliceKerbContext, "fetchRequest", partialFunction));
    }

    @Test
    public void test_client_authorization_strict() {
        Assert.assertFalse((String)"Deny execute to unauthroized user", (boolean)this.isPermitted(strictHandler, ReqContext.context(), "execute", function));
        Assert.assertFalse((String)"Deny execute to valid user for incorrect function", (boolean)this.isPermitted(strictHandler, aliceContext, "execute", wrongFunction));
        Assert.assertTrue((String)"Allow execute to authorized kerb user for correct function", (boolean)this.isPermitted(strictHandler, aliceKerbContext, "execute", function));
        Assert.assertTrue((String)"Allow execute to authorized user for correct function", (boolean)this.isPermitted(strictHandler, aliceContext, "execute", function));
    }

    @Test
    public void test_client_authorization_permissive() {
        Assert.assertFalse((String)"deny execute to unauthorized user for correct function", (boolean)this.isPermitted(permissiveHandler, ReqContext.context(), "execute", function));
        Assert.assertTrue((String)"allow execute for user for incorrect function when permissive", (boolean)this.isPermitted(permissiveHandler, aliceContext, "execute", wrongFunction));
        Assert.assertTrue((String)"allow execute for user for incorrect function when permissive", (boolean)this.isPermitted(permissiveHandler, aliceKerbContext, "execute", wrongFunction));
        Assert.assertTrue((String)"allow execute to authorized user for correct function", (boolean)this.isPermitted(permissiveHandler, bobContext, "execute", function));
    }

    @Test
    public void test_invocation_authorization_strict() {
        for (String operation : new String[]{"fetchRequest", "failRequest", "result"}) {
            Assert.assertFalse((String)("Deny " + operation + " to unauthorized user for correct function"), (boolean)this.isPermitted(strictHandler, aliceContext, operation, function));
            Assert.assertFalse((String)("Deny " + operation + " to user for incorrect function when strict"), (boolean)this.isPermitted(strictHandler, charlieContext, operation, wrongFunction));
            Assert.assertTrue((String)("allow " + operation + " to authorized user for correct function"), (boolean)this.isPermitted(strictHandler, charlieContext, operation, function));
        }
    }

    @Test
    public void test_invocation_authorization_permissive() {
        for (String operation : new String[]{"fetchRequest", "failRequest", "result"}) {
            Assert.assertFalse((String)("Deny " + operation + " to unauthorized user for correct function"), (boolean)this.isPermitted(permissiveHandler, bobContext, operation, function));
            Assert.assertTrue((String)("Allow " + operation + " to user for incorrect function when permissive"), (boolean)this.isPermitted(permissiveHandler, charlieContext, operation, wrongFunction));
            Assert.assertTrue((String)("allow " + operation + " to authorized user"), (boolean)this.isPermitted(permissiveHandler, charlieContext, operation, function));
        }
    }

    @Test
    public void test_deny_when_no_function_given() {
        Assert.assertFalse((boolean)strictHandler.permit(aliceContext, "execute", new HashMap()));
        Assert.assertFalse((boolean)this.isPermitted(strictHandler, aliceContext, "execute", null));
        Assert.assertFalse((boolean)permissiveHandler.permit(bobContext, "execute", new HashMap()));
        Assert.assertFalse((boolean)this.isPermitted(permissiveHandler, bobContext, "execute", null));
    }

    @Test
    public void test_deny_when_invalid_user_given() {
        Assert.assertFalse((boolean)this.isPermitted(strictHandler, (ReqContext)Mockito.mock(ReqContext.class), "execute", function));
        Assert.assertFalse((boolean)this.isPermitted(strictHandler, null, "execute", function));
        Assert.assertFalse((boolean)this.isPermitted(permissiveHandler, (ReqContext)Mockito.mock(ReqContext.class), "execute", function));
        Assert.assertFalse((boolean)this.isPermitted(permissiveHandler, null, "execute", function));
    }

    private static ReqContext makeMockContext(String user) {
        ReqContext mockContext = (ReqContext)Mockito.mock(ReqContext.class);
        Mockito.when((Object)mockContext.principal()).thenReturn((Object)new SingleUserPrincipal(user));
        return mockContext;
    }

    private boolean isPermitted(IAuthorizer authorizer, ReqContext context, String operation, String function) {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("function.name", function);
        return authorizer.permit(context, operation, config);
    }

    static {
        aliceContext = DRPCSimpleACLAuthorizerTest.makeMockContext("alice");
        aliceKerbContext = DRPCSimpleACLAuthorizerTest.makeMockContext("alice@SOME.RELM");
        bobContext = DRPCSimpleACLAuthorizerTest.makeMockContext("bob");
        charlieContext = DRPCSimpleACLAuthorizerTest.makeMockContext("charlie");
    }
}

