/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.security.serialization;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.storm.security.serialization.BlowfishTupleSerializer;
import org.apache.storm.utils.ListDelegate;
import org.junit.Assert;
import org.junit.Test;

public class BlowfishTupleSerializerTest {
    @Test(expected=RuntimeException.class)
    public void testConstructorThrowsOnNullKey() {
        new BlowfishTupleSerializer(null, new HashMap());
    }

    @Test(expected=RuntimeException.class)
    public void testConstructorThrowsOnInvalidKey() {
        new BlowfishTupleSerializer(null, (Map)ImmutableMap.of((Object)"topology.tuple.serializer.blowfish.key", (Object)"0123456789abcdefg"));
    }

    @Test
    public void testEncryptsAndDecryptsMessage() {
        String testText = "Tetraodontidae is a family of primarily marine and estuarine fish of the order Tetraodontiformes. The family includes many familiar species, which are variously called pufferfish, puffers, balloonfish, blowfish, bubblefish, globefish, swellfish, toadfish, toadies, honey toads, sugar toads, and sea squab.[1] They are morphologically similar to the closely related porcupinefish, which have large external spines (unlike the thinner, hidden spines of Tetraodontidae, which are only visible when the fish has puffed up). The scientific name refers to the four large teeth, fused into an upper and lower plate, which are used for crushing the shells of crustaceans and mollusks, their natural prey.";
        Kryo kryo = new Kryo();
        String arbitraryKey = "7dd6fb3203878381b08f9c89d25ed105";
        ImmutableMap topoConf = ImmutableMap.of((Object)"topology.tuple.serializer.blowfish.key", (Object)arbitraryKey);
        BlowfishTupleSerializer writerBTS = new BlowfishTupleSerializer(kryo, (Map)topoConf);
        BlowfishTupleSerializer readerBTS = new BlowfishTupleSerializer(kryo, (Map)topoConf);
        int bufferSize = 1024;
        Output output = new Output(bufferSize, bufferSize);
        Input input = new Input(bufferSize);
        String[] stringList = testText.split(" ");
        ListDelegate delegate = new ListDelegate();
        delegate.addAll(Arrays.asList(stringList));
        writerBTS.write(kryo, output, delegate);
        input.setBuffer(output.getBuffer());
        ListDelegate outDelegate = readerBTS.read(kryo, input, ListDelegate.class);
        Assert.assertEquals((Object)testText, (Object)Joiner.on((String)" ").join(outDelegate.toArray()));
    }
}

