/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.serialization;

import java.io.Serializable;
import org.apache.storm.serialization.DefaultSerializationDelegate;
import org.apache.storm.serialization.GzipBridgeSerializationDelegate;
import org.apache.storm.serialization.GzipSerializationDelegate;
import org.apache.storm.serialization.SerializationDelegate;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GzipBridgeSerializationDelegateTest {
    SerializationDelegate testDelegate;

    @Before
    public void setUp() throws Exception {
        this.testDelegate = new GzipBridgeSerializationDelegate();
    }

    @Test
    public void testDeserialize_readingFromGzip() throws Exception {
        TestPojo pojo = new TestPojo();
        pojo.name = "foo";
        pojo.age = 100;
        byte[] serialized = new GzipSerializationDelegate().serialize((Object)pojo);
        TestPojo pojo2 = (TestPojo)this.testDelegate.deserialize(serialized, TestPojo.class);
        Assert.assertEquals((Object)pojo2.name, (Object)pojo.name);
        Assert.assertEquals((long)pojo2.age, (long)pojo.age);
    }

    @Test
    public void testDeserialize_readingFromGzipBridge() throws Exception {
        TestPojo pojo = new TestPojo();
        pojo.name = "bar";
        pojo.age = 200;
        byte[] serialized = new GzipBridgeSerializationDelegate().serialize((Object)pojo);
        TestPojo pojo2 = (TestPojo)this.testDelegate.deserialize(serialized, TestPojo.class);
        Assert.assertEquals((Object)pojo2.name, (Object)pojo.name);
        Assert.assertEquals((long)pojo2.age, (long)pojo.age);
    }

    @Test
    public void testDeserialize_readingFromDefault() throws Exception {
        TestPojo pojo = new TestPojo();
        pojo.name = "baz";
        pojo.age = 300;
        byte[] serialized = new DefaultSerializationDelegate().serialize((Object)pojo);
        TestPojo pojo2 = (TestPojo)this.testDelegate.deserialize(serialized, TestPojo.class);
        Assert.assertEquals((Object)pojo2.name, (Object)pojo.name);
        Assert.assertEquals((long)pojo2.age, (long)pojo.age);
    }

    static class TestPojo
    implements Serializable {
        String name;
        int age;

        TestPojo() {
        }
    }
}

