/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.trident.TridentTopology;
import org.apache.storm.trident.operation.CombinerAggregator;
import org.apache.storm.trident.operation.Function;
import org.apache.storm.trident.operation.builtin.Count;
import org.apache.storm.trident.operation.builtin.Sum;
import org.apache.storm.trident.spout.IBatchSpout;
import org.apache.storm.trident.testing.FixedBatchSpout;
import org.apache.storm.trident.testing.Split;
import org.apache.storm.trident.testing.StringLength;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Values;
import org.junit.Assert;
import org.junit.Test;

public class TestTridentTopology {
    private StormTopology buildTopology() {
        FixedBatchSpout spout = new FixedBatchSpout(new Fields(new String[]{"sentence"}), 3, new List[]{new Values(new Object[]{"the cow jumped over the moon"}), new Values(new Object[]{"the man went to the store and bought some candy"}), new Values(new Object[]{"four score and seven years ago"}), new Values(new Object[]{"how many apples can you eat"})});
        spout.setCycle(true);
        TridentTopology topology = new TridentTopology();
        topology.newStream("spout", (IBatchSpout)spout).each(new Fields(new String[]{"sentence"}), (Function)new Split(), new Fields(new String[]{"word"})).partitionBy(new Fields(new String[]{"word"})).name("abc").each(new Fields(new String[]{"word"}), (Function)new StringLength(), new Fields(new String[]{"length"})).partitionBy(new Fields(new String[]{"length"})).name("def").aggregate(new Fields(new String[]{"length"}), (CombinerAggregator)new Count(), new Fields(new String[]{"count"})).partitionBy(new Fields(new String[]{"count"})).name("ghi").aggregate(new Fields(new String[]{"count"}), (CombinerAggregator)new Sum(), new Fields(new String[]{"sum"}));
        return topology.build();
    }

    @Test
    public void testGenBoltId() {
        Set pre = null;
        for (int i = 0; i < 100; ++i) {
            StormTopology topology = this.buildTopology();
            Map cur = topology.get_bolts();
            System.out.println(cur.keySet());
            if (pre != null) {
                Assert.assertTrue((String)"bold id not consistent with group name", (boolean)pre.equals(cur.keySet()));
            }
            pre = cur.keySet();
        }
    }
}

