/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident;

import java.util.concurrent.TimeUnit;
import org.apache.storm.topology.base.BaseWindowedBolt;
import org.apache.storm.trident.windowing.InMemoryWindowsStore;
import org.apache.storm.trident.windowing.config.SlidingCountWindow;
import org.apache.storm.trident.windowing.config.SlidingDurationWindow;
import org.apache.storm.trident.windowing.config.TumblingCountWindow;
import org.apache.storm.trident.windowing.config.TumblingDurationWindow;
import org.apache.storm.trident.windowing.strategy.SlidingCountWindowStrategy;
import org.apache.storm.trident.windowing.strategy.SlidingDurationWindowStrategy;
import org.apache.storm.trident.windowing.strategy.TumblingCountWindowStrategy;
import org.apache.storm.trident.windowing.strategy.TumblingDurationWindowStrategy;
import org.apache.storm.trident.windowing.strategy.WindowStrategy;
import org.junit.Assert;
import org.junit.Test;

public class TridentWindowingTest {
    @Test
    public void testWindowStrategyInstances() throws Exception {
        WindowStrategy tumblingCountStrategy = TumblingCountWindow.of((int)10).getWindowStrategy();
        Assert.assertTrue((boolean)(tumblingCountStrategy instanceof TumblingCountWindowStrategy));
        WindowStrategy slidingCountStrategy = SlidingCountWindow.of((int)100, (int)10).getWindowStrategy();
        Assert.assertTrue((boolean)(slidingCountStrategy instanceof SlidingCountWindowStrategy));
        WindowStrategy tumblingDurationStrategy = TumblingDurationWindow.of((BaseWindowedBolt.Duration)new BaseWindowedBolt.Duration(10, TimeUnit.SECONDS)).getWindowStrategy();
        Assert.assertTrue((boolean)(tumblingDurationStrategy instanceof TumblingDurationWindowStrategy));
        WindowStrategy slidingDurationStrategy = SlidingDurationWindow.of((BaseWindowedBolt.Duration)new BaseWindowedBolt.Duration(10, TimeUnit.SECONDS), (BaseWindowedBolt.Duration)new BaseWindowedBolt.Duration(2, TimeUnit.SECONDS)).getWindowStrategy();
        Assert.assertTrue((boolean)(slidingDurationStrategy instanceof SlidingDurationWindowStrategy));
    }

    @Test
    public void testWindowConfig() {
        int windowLength = 9;
        TumblingCountWindow tumblingCountWindow = TumblingCountWindow.of((int)windowLength);
        Assert.assertTrue((tumblingCountWindow.getWindowLength() == windowLength ? 1 : 0) != 0);
        Assert.assertTrue((tumblingCountWindow.getSlidingLength() == windowLength ? 1 : 0) != 0);
        windowLength = 10;
        int slidingLength = 2;
        SlidingCountWindow slidingCountWindow = SlidingCountWindow.of((int)10, (int)2);
        Assert.assertTrue((slidingCountWindow.getWindowLength() == windowLength ? 1 : 0) != 0);
        Assert.assertTrue((slidingCountWindow.getSlidingLength() == slidingLength ? 1 : 0) != 0);
        windowLength = 20;
        TumblingDurationWindow tumblingDurationWindow = TumblingDurationWindow.of((BaseWindowedBolt.Duration)new BaseWindowedBolt.Duration(windowLength, TimeUnit.SECONDS));
        Assert.assertTrue((tumblingDurationWindow.getWindowLength() == windowLength * 1000 ? 1 : 0) != 0);
        Assert.assertTrue((tumblingDurationWindow.getSlidingLength() == windowLength * 1000 ? 1 : 0) != 0);
        windowLength = 50;
        slidingLength = 10;
        SlidingDurationWindow slidingDurationWindow = SlidingDurationWindow.of((BaseWindowedBolt.Duration)new BaseWindowedBolt.Duration(windowLength, TimeUnit.SECONDS), (BaseWindowedBolt.Duration)new BaseWindowedBolt.Duration(slidingLength, TimeUnit.SECONDS));
        Assert.assertTrue((slidingDurationWindow.getWindowLength() == windowLength * 1000 ? 1 : 0) != 0);
        Assert.assertTrue((slidingDurationWindow.getSlidingLength() == slidingLength * 1000 ? 1 : 0) != 0);
    }

    @Test
    public void testInMemoryWindowStore() {
        int i;
        InMemoryWindowsStore store = new InMemoryWindowsStore();
        String keyPrefix = "key";
        String valuePrefix = "valuePrefix";
        int ct = 10;
        for (i = 0; i < ct; ++i) {
            store.put(keyPrefix + i, (Object)(valuePrefix + i));
        }
        for (i = 0; i < ct; ++i) {
            Assert.assertTrue((boolean)(valuePrefix + i).equals(store.get(keyPrefix + i)));
        }
        store.remove(keyPrefix + 1);
        Assert.assertNull((Object)store.get(keyPrefix + 1));
    }
}

