/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.apache.storm.multilang.BoltMsg;
import org.apache.storm.utils.ShellBoltMessageQueue;
import org.junit.Test;

public class ShellBoltMessageQueueTest
extends TestCase {
    @Test
    public void testPollTaskIdsFirst() throws InterruptedException {
        ShellBoltMessageQueue queue = new ShellBoltMessageQueue();
        queue.putBoltMsg(new BoltMsg());
        ArrayList taskIds = Lists.newArrayList((Object[])new Integer[]{1, 2, 3});
        queue.putTaskIds((List)taskIds);
        Object msg = queue.poll(10L, TimeUnit.SECONDS);
        ShellBoltMessageQueueTest.assertTrue((boolean)(msg instanceof List));
        ShellBoltMessageQueueTest.assertEquals((Object)msg, (Object)taskIds);
    }

    @Test
    public void testPollWhileThereAreNoDataAvailable() throws InterruptedException {
        ShellBoltMessageQueue queue = new ShellBoltMessageQueue();
        long start = System.currentTimeMillis();
        Object msg = queue.poll(1L, TimeUnit.SECONDS);
        long finish = System.currentTimeMillis();
        long waitDuration = finish - start;
        ShellBoltMessageQueueTest.assertNull((Object)msg);
        ShellBoltMessageQueueTest.assertTrue((String)("wait duration should be equal or greater than 1000, current: " + waitDuration), (waitDuration >= 1000L ? 1 : 0) != 0);
    }

    @Test
    public void testPollShouldReturnASAPWhenDataAvailable() throws InterruptedException {
        final ShellBoltMessageQueue queue = new ShellBoltMessageQueue();
        final ArrayList taskIds = Lists.newArrayList((Object[])new Integer[]{1, 2, 3});
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                queue.putTaskIds(taskIds);
            }
        });
        t.start();
        long start = System.currentTimeMillis();
        Object msg = queue.poll(10L, TimeUnit.SECONDS);
        long finish = System.currentTimeMillis();
        ShellBoltMessageQueueTest.assertEquals((Object)msg, (Object)taskIds);
        ShellBoltMessageQueueTest.assertTrue((finish - start < 10000L ? 1 : 0) != 0);
    }
}

