/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.utils;

import org.apache.storm.utils.Utils;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;

public class ThrowableNestedCauseMatcher
extends BaseMatcher<Throwable> {
    private Class<? extends Throwable> exceptionCause;

    public ThrowableNestedCauseMatcher(Class<? extends Throwable> exceptionCause) {
        this.exceptionCause = exceptionCause;
    }

    public boolean matches(Object throwable) {
        return Utils.exceptionCauseIsInstanceOf(this.exceptionCause, (Throwable)((Throwable)throwable));
    }

    public void describeTo(Description description) {
        description.appendText(this.exceptionCause.getName());
    }

    public static ThrowableNestedCauseMatcher isCausedBy(Class<? extends Throwable> exceptionCause) {
        return new ThrowableNestedCauseMatcher(exceptionCause);
    }
}

