/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm;

import com.esotericsoftware.kryo.Serializer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.storm.networktopography.DNSToSwitchMapping;
import org.apache.storm.scheduler.resource.strategies.scheduling.IStrategy;
import org.apache.storm.serialization.IKryoDecorator;
import org.apache.storm.serialization.IKryoFactory;
import org.apache.storm.validation.ConfigValidation;
import org.apache.storm.validation.ConfigValidationAnnotations;

public class Config
extends HashMap<String, Object> {
    private static final long serialVersionUID = -1550278723792864455L;
    @ConfigValidationAnnotations.isString
    public static final String TOPOLOGY_TUPLE_SERIALIZER = "topology.tuple.serializer";
    @ConfigValidationAnnotations.isBoolean
    @ConfigValidationAnnotations.NotNull
    public static final String TOPOLOGY_DISABLE_LOADAWARE_MESSAGING = "topology.disable.loadaware.messaging";
    @ConfigValidationAnnotations.isBoolean
    public static final String TOPOLOGY_TESTING_ALWAYS_TRY_SERIALIZE = "topology.testing.always.try.serialize";
    @ConfigValidationAnnotations.CustomValidator(validatorClass=ConfigValidation.MapOfStringToMapOfStringToObjectValidator.class)
    public static final String TOPOLOGY_BLOBSTORE_MAP = "topology.blobstore.map";
    @ConfigValidationAnnotations.isInteger
    @ConfigValidationAnnotations.isPositiveNumber
    public static final String WORKER_LOG_LEVEL_RESET_POLL_SECS = "worker.log.level.reset.poll.secs";
    @ConfigValidationAnnotations.isInteger
    @ConfigValidationAnnotations.isPositiveNumber
    public static final String TASK_CREDENTIALS_POLL_SECS = "task.credentials.poll.secs";
    @ConfigValidationAnnotations.isInteger
    @ConfigValidationAnnotations.isPositiveNumber
    public static final String TASK_BACKPRESSURE_POLL_SECS = "task.backpressure.poll.secs";
    @ConfigValidationAnnotations.isBoolean
    public static final String TOPOLOGY_BACKPRESSURE_ENABLE = "topology.backpressure.enable";
    @ConfigValidationAnnotations.isPositiveNumber
    public static final String BACKPRESSURE_DISRUPTOR_HIGH_WATERMARK = "backpressure.disruptor.high.watermark";
    @ConfigValidationAnnotations.isPositiveNumber
    public static final String BACKPRESSURE_DISRUPTOR_LOW_WATERMARK = "backpressure.disruptor.low.watermark";
    @ConfigValidationAnnotations.isStringList
    public static final String TOPOLOGY_USERS = "topology.users";
    @ConfigValidationAnnotations.isStringList
    public static final String TOPOLOGY_GROUPS = "topology.groups";
    @ConfigValidationAnnotations.isBoolean
    public static final String TOPOLOGY_ENABLE_MESSAGE_TIMEOUTS = "topology.enable.message.timeouts";
    @ConfigValidationAnnotations.isBoolean
    public static final String TOPOLOGY_DEBUG = "topology.debug";
    @ConfigValidationAnnotations.isString
    public static final String TOPOLOGY_MULTILANG_SERIALIZER = "topology.multilang.serializer";
    @ConfigValidationAnnotations.isInteger
    @ConfigValidationAnnotations.isPositiveNumber
    public static final String TOPOLOGY_WORKERS = "topology.workers";
    @ConfigValidationAnnotations.isInteger
    @ConfigValidationAnnotations.isPositiveNumber(includeZero=true)
    public static final String TOPOLOGY_TASKS = "topology.tasks";
    @ConfigValidationAnnotations.isPositiveNumber(includeZero=true)
    public static final String TOPOLOGY_COMPONENT_RESOURCES_ONHEAP_MEMORY_MB = "topology.component.resources.onheap.memory.mb";
    @ConfigValidationAnnotations.isPositiveNumber(includeZero=true)
    public static final String TOPOLOGY_COMPONENT_RESOURCES_OFFHEAP_MEMORY_MB = "topology.component.resources.offheap.memory.mb";
    @ConfigValidationAnnotations.isPositiveNumber(includeZero=true)
    public static final String TOPOLOGY_COMPONENT_CPU_PCORE_PERCENT = "topology.component.cpu.pcore.percent";
    @ConfigValidationAnnotations.isString
    public static final String TOPOLOGY_STATE_PROVIDER = "topology.state.provider";
    @ConfigValidationAnnotations.isString
    public static final String TOPOLOGY_STATE_PROVIDER_CONFIG = "topology.state.provider.config";
    @ConfigValidationAnnotations.isInteger
    @ConfigValidationAnnotations.isPositiveNumber
    public static final String TOPOLOGY_STATE_CHECKPOINT_INTERVAL = "topology.state.checkpoint.interval.ms";
    @ConfigValidationAnnotations.isPositiveNumber
    public static final String TOPOLOGY_WORKER_MAX_HEAP_SIZE_MB = "topology.worker.max.heap.size.mb";
    @ConfigValidationAnnotations.NotNull
    @ConfigValidationAnnotations.isImplementationOfClass(implementsClass=IStrategy.class)
    public static final String TOPOLOGY_SCHEDULER_STRATEGY = "topology.scheduler.strategy";
    @ConfigValidationAnnotations.isInteger
    @ConfigValidationAnnotations.isPositiveNumber(includeZero=true)
    public static final String TOPOLOGY_ACKER_EXECUTORS = "topology.acker.executors";
    @ConfigValidationAnnotations.isInteger
    @ConfigValidationAnnotations.isPositiveNumber(includeZero=true)
    public static final String TOPOLOGY_EVENTLOGGER_EXECUTORS = "topology.eventlogger.executors";
    @ConfigValidationAnnotations.isInteger
    @ConfigValidationAnnotations.isPositiveNumber
    @ConfigValidationAnnotations.NotNull
    public static final String TOPOLOGY_MESSAGE_TIMEOUT_SECS = "topology.message.timeout.secs";
    @ConfigValidationAnnotations.isKryoReg
    public static final String TOPOLOGY_KRYO_REGISTER = "topology.kryo.register";
    @ConfigValidationAnnotations.isStringList
    public static final String TOPOLOGY_KRYO_DECORATORS = "topology.kryo.decorators";
    @ConfigValidationAnnotations.isString
    public static final String TOPOLOGY_KRYO_FACTORY = "topology.kryo.factory";
    @ConfigValidationAnnotations.isBoolean
    public static final String TOPOLOGY_SKIP_MISSING_KRYO_REGISTRATIONS = "topology.skip.missing.kryo.registrations";
    @ConfigValidationAnnotations.isListEntryCustom(entryValidatorClasses={ConfigValidation.MetricRegistryValidator.class})
    public static final String TOPOLOGY_METRICS_CONSUMER_REGISTER = "topology.metrics.consumer.register";
    @ConfigValidationAnnotations.isMapEntryType(keyType=String.class, valueType=String.class)
    public static final String TOPOLOGY_WORKER_METRICS = "topology.worker.metrics";
    @ConfigValidationAnnotations.isMapEntryType(keyType=String.class, valueType=String.class)
    public static final String WORKER_METRICS = "worker.metrics";
    @ConfigValidationAnnotations.isInteger
    @ConfigValidationAnnotations.isPositiveNumber
    public static final String TOPOLOGY_MAX_TASK_PARALLELISM = "topology.max.task.parallelism";
    @ConfigValidationAnnotations.isInteger
    @ConfigValidationAnnotations.isPositiveNumber
    public static final String TOPOLOGY_MAX_SPOUT_PENDING = "topology.max.spout.pending";
    @ConfigValidationAnnotations.isString
    public static final String TOPOLOGY_SPOUT_WAIT_STRATEGY = "topology.spout.wait.strategy";
    @ConfigValidationAnnotations.isInteger
    @ConfigValidationAnnotations.isPositiveNumber(includeZero=true)
    public static final String TOPOLOGY_SLEEP_SPOUT_WAIT_STRATEGY_TIME_MS = "topology.sleep.spout.wait.strategy.time.ms";
    @ConfigValidationAnnotations.isInteger
    @ConfigValidationAnnotations.isPositiveNumber
    @ConfigValidationAnnotations.NotNull
    public static final String TOPOLOGY_STATE_SYNCHRONIZATION_TIMEOUT_SECS = "topology.state.synchronization.timeout.secs";
    @ConfigValidationAnnotations.isPositiveNumber
    public static final String TOPOLOGY_STATS_SAMPLE_RATE = "topology.stats.sample.rate";
    @ConfigValidationAnnotations.isInteger
    public static final String TOPOLOGY_BUILTIN_METRICS_BUCKET_SIZE_SECS = "topology.builtin.metrics.bucket.size.secs";
    @ConfigValidationAnnotations.isBoolean
    public static final String TOPOLOGY_FALL_BACK_ON_JAVA_SERIALIZATION = "topology.fall.back.on.java.serialization";
    @ConfigValidationAnnotations.isStringOrStringList
    public static final String TOPOLOGY_WORKER_CHILDOPTS = "topology.worker.childopts";
    @ConfigValidationAnnotations.isStringOrStringList
    public static final String TOPOLOGY_WORKER_GC_CHILDOPTS = "topology.worker.gc.childopts";
    @ConfigValidationAnnotations.isStringOrStringList
    public static final String TOPOLOGY_WORKER_LOGWRITER_CHILDOPTS = "topology.worker.logwriter.childopts";
    @ConfigValidationAnnotations.isStringOrStringList
    public static final String TOPOLOGY_CLASSPATH = "topology.classpath";
    @ConfigValidationAnnotations.isStringOrStringList
    public static final String TOPOLOGY_CLASSPATH_BEGINNING = "topology.classpath.beginning";
    @ConfigValidationAnnotations.isMapEntryType(keyType=String.class, valueType=String.class)
    public static final String TOPOLOGY_ENVIRONMENT = "topology.environment";
    @ConfigValidationAnnotations.isBoolean
    public static final String TOPOLOGY_BOLTS_OUTGOING_OVERFLOW_BUFFER_ENABLE = "topology.bolts.outgoing.overflow.buffer.enable";
    @ConfigValidationAnnotations.isInteger
    @ConfigValidationAnnotations.isPositiveNumber
    public static final String TOPOLOGY_BOLTS_WINDOW_LENGTH_COUNT = "topology.bolts.window.length.count";
    @ConfigValidationAnnotations.isInteger
    @ConfigValidationAnnotations.isPositiveNumber
    public static final String TOPOLOGY_BOLTS_WINDOW_LENGTH_DURATION_MS = "topology.bolts.window.length.duration.ms";
    @ConfigValidationAnnotations.isInteger
    @ConfigValidationAnnotations.isPositiveNumber
    public static final String TOPOLOGY_BOLTS_SLIDING_INTERVAL_COUNT = "topology.bolts.window.sliding.interval.count";
    @ConfigValidationAnnotations.isInteger
    @ConfigValidationAnnotations.isPositiveNumber
    public static final String TOPOLOGY_BOLTS_SLIDING_INTERVAL_DURATION_MS = "topology.bolts.window.sliding.interval.duration.ms";
    @ConfigValidationAnnotations.isString
    public static final String TOPOLOGY_BOLTS_LATE_TUPLE_STREAM = "topology.bolts.late.tuple.stream";
    @ConfigValidationAnnotations.isInteger
    @ConfigValidationAnnotations.isPositiveNumber
    public static final String TOPOLOGY_BOLTS_TUPLE_TIMESTAMP_MAX_LAG_MS = "topology.bolts.tuple.timestamp.max.lag.ms";
    @ConfigValidationAnnotations.isInteger
    @ConfigValidationAnnotations.isPositiveNumber
    public static final String TOPOLOGY_BOLTS_WATERMARK_EVENT_INTERVAL_MS = "topology.bolts.watermark.event.interval.ms";
    @ConfigValidationAnnotations.isString
    public static final String TOPOLOGY_BOLTS_MESSAGE_ID_FIELD_NAME = "topology.bolts.message.id.field.name";
    @ConfigValidationAnnotations.isString
    public static final String TOPOLOGY_TRANSACTIONAL_ID = "topology.transactional.id";
    @ConfigValidationAnnotations.isStringList
    public static final String TOPOLOGY_AUTO_TASK_HOOKS = "topology.auto.task.hooks";
    @ConfigValidationAnnotations.isPowerOf2
    public static final String TOPOLOGY_EXECUTOR_RECEIVE_BUFFER_SIZE = "topology.executor.receive.buffer.size";
    @ConfigValidationAnnotations.isPowerOf2
    public static final String TOPOLOGY_EXECUTOR_SEND_BUFFER_SIZE = "topology.executor.send.buffer.size";
    @ConfigValidationAnnotations.isInteger
    @ConfigValidationAnnotations.isPowerOf2
    public static final String TOPOLOGY_TRANSFER_BUFFER_SIZE = "topology.transfer.buffer.size";
    @ConfigValidationAnnotations.isInteger
    public static final String TOPOLOGY_TICK_TUPLE_FREQ_SECS = "topology.tick.tuple.freq.secs";
    @Deprecated
    @ConfigValidationAnnotations.isString
    public static final String TOPOLOGY_DISRUPTOR_WAIT_STRATEGY = "topology.disruptor.wait.strategy";
    @ConfigValidationAnnotations.isInteger
    public static final String TOPOLOGY_WORKER_SHARED_THREAD_POOL_SIZE = "topology.worker.shared.thread.pool.size";
    @ConfigValidationAnnotations.isInteger
    public static final String TOPOLOGY_ERROR_THROTTLE_INTERVAL_SECS = "topology.error.throttle.interval.secs";
    @ConfigValidationAnnotations.isInteger
    @ConfigValidationAnnotations.isPositiveNumber
    public static final String TOPOLOGY_MAX_ERROR_REPORT_PER_INTERVAL = "topology.max.error.report.per.interval";
    @ConfigValidationAnnotations.isInteger
    @ConfigValidationAnnotations.isPositiveNumber
    public static final String TOPOLOGY_TRIDENT_BATCH_EMIT_INTERVAL_MILLIS = "topology.trident.batch.emit.interval.millis";
    @ConfigValidationAnnotations.isInteger
    @ConfigValidationAnnotations.isPositiveNumber
    public static final String TOPOLOGY_TRIDENT_WINDOWING_INMEMORY_CACHE_LIMIT = "topology.trident.windowing.cache.tuple.limit";
    @ConfigValidationAnnotations.isString
    public static final String STORM_ID = "storm.id";
    @ConfigValidationAnnotations.isString
    public static final String TOPOLOGY_NAME = "topology.name";
    @ConfigValidationAnnotations.isString
    public static final String TOPOLOGY_SUBMITTER_PRINCIPAL = "topology.submitter.principal";
    @ConfigValidationAnnotations.isString
    public static final String TOPOLOGY_SUBMITTER_USER = "topology.submitter.user";
    @ConfigValidationAnnotations.isStringList
    public static final String TOPOLOGY_SPREAD_COMPONENTS = "topology.spread.components";
    @ConfigValidationAnnotations.isStringList
    public static final String TOPOLOGY_AUTO_CREDENTIALS = "topology.auto-credentials";
    @ConfigValidationAnnotations.NotNull
    @ConfigValidationAnnotations.isInteger
    @ConfigValidationAnnotations.isPositiveNumber
    public static final String TOPOLOGY_SHELLBOLT_MAX_PENDING = "topology.shellbolt.max.pending";
    @ConfigValidationAnnotations.isInteger
    @ConfigValidationAnnotations.isPositiveNumber
    public static final String TOPOLOGY_SUBPROCESS_TIMEOUT_SECS = "topology.subprocess.timeout.secs";
    @ConfigValidationAnnotations.isString(acceptedValues={"S0", "S1", "S2", "S3"})
    public static final String TOPOLOGY_LOGGING_SENSITIVITY = "topology.logging.sensitivity";
    @ConfigValidationAnnotations.isInteger
    @ConfigValidationAnnotations.isPositiveNumber(includeZero=true)
    public static final String TOPOLOGY_PRIORITY = "topology.priority";
    @ConfigValidationAnnotations.isString
    public static final String TRANSACTIONAL_ZOOKEEPER_ROOT = "transactional.zookeeper.root";
    @ConfigValidationAnnotations.isStringList
    public static final String TRANSACTIONAL_ZOOKEEPER_SERVERS = "transactional.zookeeper.servers";
    @ConfigValidationAnnotations.isInteger
    @ConfigValidationAnnotations.isPositiveNumber
    public static final String TRANSACTIONAL_ZOOKEEPER_PORT = "transactional.zookeeper.port";
    @ConfigValidationAnnotations.isString
    public static final String STORM_DO_AS_USER = "storm.doAsUser";
    @ConfigValidationAnnotations.isInteger
    @ConfigValidationAnnotations.isPositiveNumber
    public static final String TOPOLOGY_ISOLATED_MACHINES = "topology.isolate.machines";
    @ConfigValidationAnnotations.isInteger
    @ConfigValidationAnnotations.NotNull
    public static final String TOPOLOGY_DISRUPTOR_WAIT_TIMEOUT_MILLIS = "topology.disruptor.wait.timeout.millis";
    @ConfigValidationAnnotations.isInteger
    @ConfigValidationAnnotations.isPositiveNumber
    @ConfigValidationAnnotations.NotNull
    public static final String TOPOLOGY_DISRUPTOR_BATCH_SIZE = "topology.disruptor.batch.size";
    @ConfigValidationAnnotations.isInteger
    @ConfigValidationAnnotations.isPositiveNumber
    @ConfigValidationAnnotations.NotNull
    public static final String TOPOLOGY_DISRUPTOR_BATCH_TIMEOUT_MILLIS = "topology.disruptor.batch.timeout.millis";
    @ConfigValidationAnnotations.isNumber
    public static final String TOPOLOGY_MIN_REPLICATION_COUNT = "topology.min.replication.count";
    @ConfigValidationAnnotations.isNumber
    public static final String TOPOLOGY_MAX_REPLICATION_WAIT_TIME_SEC = "topology.max.replication.wait.time.sec";
    @ConfigValidationAnnotations.isInteger
    public static final String STORM_WORKER_DISRUPTOR_FLUSHER_MAX_POOL_SIZE = "storm.worker.disruptor.flusher.max.pool.size";
    @ConfigValidationAnnotations.isStringList
    public static final String PACEMAKER_SERVERS = "pacemaker.servers";
    @ConfigValidationAnnotations.isNumber
    @ConfigValidationAnnotations.isPositiveNumber
    public static final String PACEMAKER_PORT = "pacemaker.port";
    @ConfigValidationAnnotations.CustomValidator(validatorClass=ConfigValidation.PacemakerAuthTypeValidator.class)
    public static final String PACEMAKER_AUTH_METHOD = "pacemaker.auth.method";
    @ConfigValidationAnnotations.isInteger
    public static final String STORM_GROUP_MAPPING_SERVICE_CACHE_DURATION_SECS = "storm.group.mapping.service.cache.duration.secs";
    @ConfigValidationAnnotations.isStringList
    public static final String DRPC_SERVERS = "drpc.servers";
    @ConfigValidationAnnotations.isInteger
    @ConfigValidationAnnotations.isPositiveNumber
    public static final String DRPC_INVOCATIONS_PORT = "drpc.invocations.port";
    @ConfigValidationAnnotations.isNumber
    public static final String STORM_NIMBUS_RETRY_TIMES = "storm.nimbus.retry.times";
    @ConfigValidationAnnotations.isNumber
    public static final String STORM_NIMBUS_RETRY_INTERVAL = "storm.nimbus.retry.interval.millis";
    @ConfigValidationAnnotations.isNumber
    public static final String STORM_NIMBUS_RETRY_INTERVAL_CEILING = "storm.nimbus.retry.intervalceiling.millis";
    @ConfigValidationAnnotations.isString
    public static final String NIMBUS_THRIFT_TRANSPORT_PLUGIN = "nimbus.thrift.transport";
    @ConfigValidationAnnotations.isInteger
    @ConfigValidationAnnotations.isPositiveNumber
    public static final String NIMBUS_THRIFT_PORT = "nimbus.thrift.port";
    @ConfigValidationAnnotations.isInteger
    @ConfigValidationAnnotations.isPositiveNumber
    public static final String NIMBUS_QUEUE_SIZE = "nimbus.queue.size";
    @ConfigValidationAnnotations.isInteger
    @ConfigValidationAnnotations.isPositiveNumber
    public static final String NIMBUS_THRIFT_THREADS = "nimbus.thrift.threads";
    @ConfigValidationAnnotations.isInteger
    @ConfigValidationAnnotations.isPositiveNumber
    public static final String NIMBUS_THRIFT_MAX_BUFFER_SIZE = "nimbus.thrift.max_buffer_size";
    @ConfigValidationAnnotations.isInteger
    public static final String STORM_THRIFT_SOCKET_TIMEOUT_MS = "storm.thrift.socket.timeout.ms";
    @ConfigValidationAnnotations.isString
    public static final String DRPC_THRIFT_TRANSPORT_PLUGIN = "drpc.thrift.transport";
    @ConfigValidationAnnotations.isInteger
    @ConfigValidationAnnotations.isPositiveNumber
    public static final String DRPC_PORT = "drpc.port";
    @ConfigValidationAnnotations.isInteger
    @ConfigValidationAnnotations.isPositiveNumber
    public static final String DRPC_QUEUE_SIZE = "drpc.queue.size";
    @ConfigValidationAnnotations.isInteger
    @ConfigValidationAnnotations.isPositiveNumber
    public static final String DRPC_WORKER_THREADS = "drpc.worker.threads";
    @ConfigValidationAnnotations.isNumber
    @ConfigValidationAnnotations.isPositiveNumber
    public static final String DRPC_MAX_BUFFER_SIZE = "drpc.max_buffer_size";
    @ConfigValidationAnnotations.isString
    public static final String DRPC_INVOCATIONS_THRIFT_TRANSPORT_PLUGIN = "drpc.invocations.thrift.transport";
    @ConfigValidationAnnotations.isInteger
    @ConfigValidationAnnotations.isPositiveNumber
    public static final String DRPC_INVOCATIONS_THREADS = "drpc.invocations.threads";
    @ConfigValidationAnnotations.isString
    public static final String STORM_THRIFT_TRANSPORT_PLUGIN = "storm.thrift.transport";
    @ConfigValidationAnnotations.isInteger
    @ConfigValidationAnnotations.isPositiveNumber
    @ConfigValidationAnnotations.NotNull
    public static final String SUPERVISOR_WORKER_TIMEOUT_SECS = "supervisor.worker.timeout.secs";
    @ConfigValidationAnnotations.isStringList
    public static final String STORM_ZOOKEEPER_SERVERS = "storm.zookeeper.servers";
    @ConfigValidationAnnotations.isInteger
    @ConfigValidationAnnotations.isPositiveNumber
    public static final String STORM_ZOOKEEPER_PORT = "storm.zookeeper.port";
    @ConfigValidationAnnotations.isString
    public static final String STORM_ZOOKEEPER_SUPERACL = "storm.zookeeper.superACL";
    @ConfigValidationAnnotations.isString
    public static final String STORM_ZOOKEEPER_TOPOLOGY_AUTH_SCHEME = "storm.zookeeper.topology.auth.scheme";
    @ConfigValidationAnnotations.isString
    public static final String STORM_META_SERIALIZATION_DELEGATE = "storm.meta.serialization.delegate";
    @ConfigValidationAnnotations.isString
    public static final String CLIENT_BLOBSTORE = "client.blobstore.class";
    @ConfigValidationAnnotations.isString
    public static final String BLOBSTORE_SUPERUSER = "blobstore.superuser";
    @ConfigValidationAnnotations.isString
    public static final String BLOBSTORE_DIR = "blobstore.dir";
    @ConfigValidationAnnotations.isBoolean
    public static final String BLOBSTORE_CLEANUP_ENABLE = "blobstore.cleanup.enable";
    @ConfigValidationAnnotations.isString
    public static final String BLOBSTORE_HDFS_PRINCIPAL = "blobstore.hdfs.principal";
    @ConfigValidationAnnotations.isString
    public static final String BLOBSTORE_HDFS_KEYTAB = "blobstore.hdfs.keytab";
    @ConfigValidationAnnotations.isPositiveNumber
    @ConfigValidationAnnotations.isInteger
    public static final String STORM_BLOBSTORE_REPLICATION_FACTOR = "storm.blobstore.replication.factor";
    @ConfigValidationAnnotations.isString
    public static final String STORM_LOCAL_HOSTNAME = "storm.local.hostname";
    @Deprecated
    @ConfigValidationAnnotations.isString
    public static final String NIMBUS_HOST = "nimbus.host";
    @ConfigValidationAnnotations.isStringList
    public static final String NIMBUS_SEEDS = "nimbus.seeds";
    @ConfigValidationAnnotations.isStringList
    public static final String NIMBUS_USERS = "nimbus.users";
    @ConfigValidationAnnotations.isStringList
    public static final String NIMBUS_GROUPS = "nimbus.groups";
    @ConfigValidationAnnotations.isString
    public static final String STORM_CLUSTER_MODE = "storm.cluster.mode";
    @ConfigValidationAnnotations.isString
    public static final String STORM_ZOOKEEPER_ROOT = "storm.zookeeper.root";
    @ConfigValidationAnnotations.isString
    public static final String STORM_ZOOKEEPER_TOPOLOGY_AUTH_PAYLOAD = "storm.zookeeper.topology.auth.payload";
    @ConfigValidationAnnotations.isString
    public static final String STORM_ZOOKEEPER_AUTH_SCHEME = "storm.zookeeper.auth.scheme";
    @ConfigValidationAnnotations.isString
    public static final String STORM_ZOOKEEPER_AUTH_PAYLOAD = "storm.zookeeper.auth.payload";
    @ConfigValidationAnnotations.NotNull
    @ConfigValidationAnnotations.isImplementationOfClass(implementsClass=DNSToSwitchMapping.class)
    public static final String STORM_NETWORK_TOPOGRAPHY_PLUGIN = "storm.network.topography.plugin";
    @ConfigValidationAnnotations.isStringOrStringList
    public static final String WORKER_GC_CHILDOPTS = "worker.gc.childopts";
    @ConfigValidationAnnotations.isStringOrStringList
    public static final String WORKER_CHILDOPTS = "worker.childopts";
    @ConfigValidationAnnotations.isInteger
    @ConfigValidationAnnotations.isPositiveNumber
    public static final String WORKER_HEAP_MEMORY_MB = "worker.heap.memory.mb";
    @ConfigValidationAnnotations.isPositiveNumber
    public static final String SUPERVISOR_MEMORY_CAPACITY_MB = "supervisor.memory.capacity.mb";
    @ConfigValidationAnnotations.isPositiveNumber
    public static final String SUPERVISOR_CPU_CAPACITY = "supervisor.cpu.capacity";
    @ConfigValidationAnnotations.isBoolean
    public static final String STORM_LOCAL_MODE_ZMQ = "storm.local.mode.zmq";
    @ConfigValidationAnnotations.isString
    public static final String STORM_MESSAGING_TRANSPORT = "storm.messaging.transport";
    @ConfigValidationAnnotations.isBoolean
    public static final String STORM_MESSAGING_NETTY_AUTHENTICATION = "storm.messaging.netty.authentication";
    @ConfigValidationAnnotations.isInteger
    @ConfigValidationAnnotations.isPositiveNumber
    public static final String STORM_MESSAGING_NETTY_BUFFER_SIZE = "storm.messaging.netty.buffer_size";
    @ConfigValidationAnnotations.isInteger
    @ConfigValidationAnnotations.isPositiveNumber
    public static final String STORM_MESSAGING_NETTY_SOCKET_BACKLOG = "storm.messaging.netty.socket.backlog";
    @ConfigValidationAnnotations.isInteger
    @ConfigValidationAnnotations.isPositiveNumber(includeZero=true)
    public static final String STORM_MESSAGING_NETTY_SERVER_WORKER_THREADS = "storm.messaging.netty.server_worker_threads";
    @ConfigValidationAnnotations.isInteger
    public static final String STORM_NETTY_MESSAGE_BATCH_SIZE = "storm.messaging.netty.transfer.batch.size";
    @Deprecated
    @ConfigValidationAnnotations.isInteger
    public static final String STORM_MESSAGING_NETTY_MAX_RETRIES = "storm.messaging.netty.max_retries";
    @ConfigValidationAnnotations.isInteger
    @ConfigValidationAnnotations.isPositiveNumber(includeZero=true)
    public static final String STORM_MESSAGING_NETTY_MIN_SLEEP_MS = "storm.messaging.netty.min_wait_ms";
    @ConfigValidationAnnotations.isInteger
    @ConfigValidationAnnotations.isPositiveNumber(includeZero=true)
    public static final String STORM_MESSAGING_NETTY_MAX_SLEEP_MS = "storm.messaging.netty.max_wait_ms";
    @ConfigValidationAnnotations.isInteger
    public static final String STORM_MESSAGING_NETTY_CLIENT_WORKER_THREADS = "storm.messaging.netty.client_worker_threads";
    @ConfigValidationAnnotations.isBoolean
    public static final String SUPERVISOR_RUN_WORKER_AS_USER = "supervisor.run.worker.as.user";
    @ConfigValidationAnnotations.isBoolean
    public static final String DISABLE_SYMLINKS = "storm.disable.symlinks";
    @ConfigValidationAnnotations.isString
    public static final String STORM_PRINCIPAL_TO_LOCAL_PLUGIN = "storm.principal.tolocal";
    @ConfigValidationAnnotations.isString
    public static final String STORM_GROUP_MAPPING_SERVICE_PROVIDER_PLUGIN = "storm.group.mapping.service";
    @ConfigValidationAnnotations.isStringList
    public static final String NIMBUS_CREDENTIAL_RENEWERS = "nimbus.credential.renewers.classes";
    @ConfigValidationAnnotations.isStringList
    public static final String NIMBUS_AUTO_CRED_PLUGINS = "nimbus.autocredential.plugins.classes";
    @ConfigValidationAnnotations.isString
    public static final String UI_HTTP_CREDS_PLUGIN = "ui.http.creds.plugin";
    @ConfigValidationAnnotations.isString
    public static final String DRPC_HTTP_CREDS_PLUGIN = "drpc.http.creds.plugin";
    @ConfigValidationAnnotations.isStringList
    public static final String NIMBUS_SUPERVISOR_USERS = "nimbus.supervisor.users";
    @ConfigValidationAnnotations.isStringList
    public static final String NIMBUS_ADMINS = "nimbus.admins";
    @ConfigValidationAnnotations.isBoolean
    public static final String STORM_BLOBSTORE_ACL_VALIDATION_ENABLED = "storm.blobstore.acl.validation.enabled";
    @ConfigValidationAnnotations.isPositiveNumber
    @ConfigValidationAnnotations.isInteger
    public static final String STORM_BLOBSTORE_INPUTSTREAM_BUFFER_SIZE_BYTES = "storm.blobstore.inputstream.buffer.size.bytes";
    @ConfigValidationAnnotations.isString
    public static final String STORM_TOPOLOGY_SUBMISSION_NOTIFIER_PLUGIN = "storm.topology.submission.notifier.plugin.class";
    @ConfigValidationAnnotations.isMapEntryCustom(keyValidatorClasses={ConfigValidation.StringValidator.class}, valueValidatorClasses={ConfigValidation.ImpersonationAclUserEntryValidator.class})
    public static final String NIMBUS_IMPERSONATION_ACL = "nimbus.impersonation.acl";
    @ConfigValidationAnnotations.isString
    public static final String SUPERVISOR_WORKER_LAUNCHER = "supervisor.worker.launcher";
    @ConfigValidationAnnotations.isString
    public static final String STORM_LOCAL_DIR = "storm.local.dir";
    @ConfigValidationAnnotations.isString
    public static final String STORM_WORKERS_ARTIFACTS_DIR = "storm.workers.artifacts.dir";
    @ConfigValidationAnnotations.isStringList
    public static final String STORM_EXHIBITOR_SERVERS = "storm.exhibitor.servers";
    @ConfigValidationAnnotations.isInteger
    @ConfigValidationAnnotations.isPositiveNumber
    public static final String STORM_EXHIBITOR_PORT = "storm.exhibitor.port";
    @ConfigValidationAnnotations.isString
    public static final String STORM_EXHIBITOR_URIPATH = "storm.exhibitor.poll.uripath";
    @ConfigValidationAnnotations.isInteger
    public static final String STORM_EXHIBITOR_POLL = "storm.exhibitor.poll.millis";
    @ConfigValidationAnnotations.isInteger
    public static final String STORM_EXHIBITOR_RETRY_TIMES = "storm.exhibitor.retry.times";
    @ConfigValidationAnnotations.isInteger
    public static final String STORM_EXHIBITOR_RETRY_INTERVAL = "storm.exhibitor.retry.interval";
    @ConfigValidationAnnotations.isInteger
    public static final String STORM_EXHIBITOR_RETRY_INTERVAL_CEILING = "storm.exhibitor.retry.intervalceiling.millis";
    @ConfigValidationAnnotations.isInteger
    public static final String STORM_ZOOKEEPER_CONNECTION_TIMEOUT = "storm.zookeeper.connection.timeout";
    @ConfigValidationAnnotations.isInteger
    public static final String STORM_ZOOKEEPER_SESSION_TIMEOUT = "storm.zookeeper.session.timeout";
    @ConfigValidationAnnotations.isInteger
    public static final String STORM_ZOOKEEPER_RETRY_INTERVAL = "storm.zookeeper.retry.interval";
    @ConfigValidationAnnotations.isInteger
    public static final String STORM_ZOOKEEPER_RETRY_INTERVAL_CEILING = "storm.zookeeper.retry.intervalceiling.millis";
    @ConfigValidationAnnotations.isInteger
    public static final String STORM_ZOOKEEPER_RETRY_TIMES = "storm.zookeeper.retry.times";
    @ConfigValidationAnnotations.isString
    public static final String STORM_CLUSTER_STATE_STORE = "storm.cluster.state.store";
    @ConfigValidationAnnotations.isInteger
    @ConfigValidationAnnotations.isPositiveNumber
    public static final String WORKER_HEARTBEAT_FREQUENCY_SECS = "worker.heartbeat.frequency.secs";
    @ConfigValidationAnnotations.isInteger
    @ConfigValidationAnnotations.isPositiveNumber
    public static final String TASK_HEARTBEAT_FREQUENCY_SECS = "task.heartbeat.frequency.secs";
    @ConfigValidationAnnotations.isInteger
    @ConfigValidationAnnotations.isPositiveNumber
    public static final String TASK_REFRESH_POLL_SECS = "task.refresh.poll.secs";
    @ConfigValidationAnnotations.isType(type=Map.class)
    public static final String DRPC_AUTHORIZER_ACL = "drpc.authorizer.acl";
    @ConfigValidationAnnotations.isString
    public static final String DRPC_AUTHORIZER_ACL_FILENAME = "drpc.authorizer.acl.filename";
    @ConfigValidationAnnotations.isBoolean
    public static final String DRPC_AUTHORIZER_ACL_STRICT = "drpc.authorizer.acl.strict";
    @ConfigValidationAnnotations.isString
    public static final String STORM_CGROUP_HIERARCHY_DIR = "storm.cgroup.hierarchy.dir";
    @ConfigValidationAnnotations.isInteger
    @ConfigValidationAnnotations.isPositiveNumber
    public static final String NUM_STAT_BUCKETS = "num.stat.buckets";

    public static void setClasspath(Map<String, Object> conf, String cp) {
        conf.put(TOPOLOGY_CLASSPATH, cp);
    }

    public void setClasspath(String cp) {
        Config.setClasspath(this, cp);
    }

    public static void setEnvironment(Map<String, Object> conf, Map env) {
        conf.put(TOPOLOGY_ENVIRONMENT, env);
    }

    public void setEnvironment(Map env) {
        Config.setEnvironment(this, env);
    }

    public static void setDebug(Map<String, Object> conf, boolean isOn) {
        conf.put(TOPOLOGY_DEBUG, isOn);
    }

    public void setDebug(boolean isOn) {
        Config.setDebug(this, isOn);
    }

    public static void setNumWorkers(Map<String, Object> conf, int workers) {
        conf.put(TOPOLOGY_WORKERS, workers);
    }

    public void setNumWorkers(int workers) {
        Config.setNumWorkers(this, workers);
    }

    public static void setNumAckers(Map<String, Object> conf, int numExecutors) {
        conf.put(TOPOLOGY_ACKER_EXECUTORS, numExecutors);
    }

    public void setNumAckers(int numExecutors) {
        Config.setNumAckers(this, numExecutors);
    }

    public static void setNumEventLoggers(Map<String, Object> conf, int numExecutors) {
        conf.put(TOPOLOGY_EVENTLOGGER_EXECUTORS, numExecutors);
    }

    public void setNumEventLoggers(int numExecutors) {
        Config.setNumEventLoggers(this, numExecutors);
    }

    public static void setMessageTimeoutSecs(Map<String, Object> conf, int secs) {
        conf.put(TOPOLOGY_MESSAGE_TIMEOUT_SECS, secs);
    }

    public void setMessageTimeoutSecs(int secs) {
        Config.setMessageTimeoutSecs(this, secs);
    }

    public static void registerSerialization(Map<String, Object> conf, Class klass) {
        Config.getRegisteredSerializations(conf).add(klass.getName());
    }

    public void registerSerialization(Class klass) {
        Config.registerSerialization(this, klass);
    }

    public static void registerSerialization(Map<String, Object> conf, Class klass, Class<? extends Serializer> serializerClass) {
        HashMap<String, String> register = new HashMap<String, String>();
        register.put(klass.getName(), serializerClass.getName());
        Config.getRegisteredSerializations(conf).add(register);
    }

    public void registerSerialization(Class klass, Class<? extends Serializer> serializerClass) {
        Config.registerSerialization(this, klass, serializerClass);
    }

    public static void registerMetricsConsumer(Map<String, Object> conf, Class klass, Object argument, long parallelismHint) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("class", klass.getCanonicalName());
        m.put("parallelism.hint", parallelismHint);
        m.put("argument", argument);
        ArrayList l = (ArrayList)conf.get(TOPOLOGY_METRICS_CONSUMER_REGISTER);
        if (l == null) {
            l = new ArrayList();
        }
        l.add(m);
        conf.put(TOPOLOGY_METRICS_CONSUMER_REGISTER, l);
    }

    public void registerMetricsConsumer(Class klass, Object argument, long parallelismHint) {
        Config.registerMetricsConsumer(this, klass, argument, parallelismHint);
    }

    public static void registerMetricsConsumer(Map<String, Object> conf, Class klass, long parallelismHint) {
        Config.registerMetricsConsumer(conf, klass, null, parallelismHint);
    }

    public void registerMetricsConsumer(Class klass, long parallelismHint) {
        Config.registerMetricsConsumer(this, klass, parallelismHint);
    }

    public static void registerMetricsConsumer(Map<String, Object> conf, Class klass) {
        Config.registerMetricsConsumer(conf, klass, null, 1L);
    }

    public void registerMetricsConsumer(Class klass) {
        Config.registerMetricsConsumer(this, klass);
    }

    public static void registerDecorator(Map<String, Object> conf, Class<? extends IKryoDecorator> klass) {
        Config.getRegisteredDecorators(conf).add(klass.getName());
    }

    public void registerDecorator(Class<? extends IKryoDecorator> klass) {
        Config.registerDecorator(this, klass);
    }

    public static void setKryoFactory(Map<String, Object> conf, Class<? extends IKryoFactory> klass) {
        conf.put(TOPOLOGY_KRYO_FACTORY, klass.getName());
    }

    public void setKryoFactory(Class<? extends IKryoFactory> klass) {
        Config.setKryoFactory(this, klass);
    }

    public static void setSkipMissingKryoRegistrations(Map<String, Object> conf, boolean skip) {
        conf.put(TOPOLOGY_SKIP_MISSING_KRYO_REGISTRATIONS, skip);
    }

    public void setSkipMissingKryoRegistrations(boolean skip) {
        Config.setSkipMissingKryoRegistrations(this, skip);
    }

    public static void setMaxTaskParallelism(Map<String, Object> conf, int max) {
        conf.put(TOPOLOGY_MAX_TASK_PARALLELISM, max);
    }

    public void setMaxTaskParallelism(int max) {
        Config.setMaxTaskParallelism(this, max);
    }

    public static void setMaxSpoutPending(Map<String, Object> conf, int max) {
        conf.put(TOPOLOGY_MAX_SPOUT_PENDING, max);
    }

    public void setMaxSpoutPending(int max) {
        Config.setMaxSpoutPending(this, max);
    }

    public static void setStatsSampleRate(Map<String, Object> conf, double rate) {
        conf.put(TOPOLOGY_STATS_SAMPLE_RATE, rate);
    }

    public void setStatsSampleRate(double rate) {
        Config.setStatsSampleRate(this, rate);
    }

    public static void setFallBackOnJavaSerialization(Map<String, Object> conf, boolean fallback) {
        conf.put(TOPOLOGY_FALL_BACK_ON_JAVA_SERIALIZATION, fallback);
    }

    public void setFallBackOnJavaSerialization(boolean fallback) {
        Config.setFallBackOnJavaSerialization(this, fallback);
    }

    private static List getRegisteredSerializations(Map<String, Object> conf) {
        ArrayList ret = !conf.containsKey(TOPOLOGY_KRYO_REGISTER) ? new ArrayList() : new ArrayList((List)conf.get(TOPOLOGY_KRYO_REGISTER));
        conf.put(TOPOLOGY_KRYO_REGISTER, ret);
        return ret;
    }

    private static List getRegisteredDecorators(Map<String, Object> conf) {
        ArrayList ret = !conf.containsKey(TOPOLOGY_KRYO_DECORATORS) ? new ArrayList() : new ArrayList((List)conf.get(TOPOLOGY_KRYO_DECORATORS));
        conf.put(TOPOLOGY_KRYO_DECORATORS, ret);
        return ret;
    }

    public void setTopologyWorkerMaxHeapSize(Number size) {
        if (size != null) {
            this.put(TOPOLOGY_WORKER_MAX_HEAP_SIZE_MB, size);
        }
    }

    public void setTopologyPriority(int priority) {
        this.put(TOPOLOGY_PRIORITY, priority);
    }

    public void setTopologyStrategy(Class<? extends IStrategy> clazz) {
        if (clazz != null) {
            this.put(TOPOLOGY_SCHEDULER_STRATEGY, clazz.getName());
        }
    }
}

