/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.blobstore;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import org.apache.commons.lang.StringUtils;
import org.apache.storm.blobstore.AtomicOutputStream;
import org.apache.storm.blobstore.BlobStoreFile;
import org.apache.storm.blobstore.InputStreamWithMeta;
import org.apache.storm.blobstore.KeyFilter;
import org.apache.storm.daemon.Shutdownable;
import org.apache.storm.generated.AuthorizationException;
import org.apache.storm.generated.KeyAlreadyExistsException;
import org.apache.storm.generated.KeyNotFoundException;
import org.apache.storm.generated.ReadableBlobMeta;
import org.apache.storm.generated.SettableBlobMeta;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.nimbus.NimbusInfo;
import org.apache.storm.utils.ConfigUtils;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BlobStore
implements Shutdownable {
    private static final Logger LOG = LoggerFactory.getLogger(BlobStore.class);
    private static final Pattern KEY_PATTERN = Pattern.compile("^[\\w \\t\\.:_-]+$", 256);
    protected static final String BASE_BLOBS_DIR_NAME = "blobs";
    private static final KeyFilter<String> TO_TOPO_ID = key -> ConfigUtils.getIdFromBlobKey(key);

    public abstract void prepare(Map<String, Object> var1, String var2, NimbusInfo var3);

    public abstract AtomicOutputStream createBlob(String var1, SettableBlobMeta var2, Subject var3) throws AuthorizationException, KeyAlreadyExistsException;

    public abstract AtomicOutputStream updateBlob(String var1, Subject var2) throws AuthorizationException, KeyNotFoundException;

    public abstract ReadableBlobMeta getBlobMeta(String var1, Subject var2) throws AuthorizationException, KeyNotFoundException;

    public abstract void setBlobMeta(String var1, SettableBlobMeta var2, Subject var3) throws AuthorizationException, KeyNotFoundException;

    public abstract void deleteBlob(String var1, Subject var2) throws AuthorizationException, KeyNotFoundException;

    public abstract InputStreamWithMeta getBlob(String var1, Subject var2) throws AuthorizationException, KeyNotFoundException;

    public abstract Iterator<String> listKeys();

    public abstract int getBlobReplication(String var1, Subject var2) throws Exception;

    public abstract int updateBlobReplication(String var1, int var2, Subject var3) throws AuthorizationException, KeyNotFoundException, IOException;

    public <R> Set<R> filterAndListKeys(KeyFilter<R> filter) {
        HashSet<R> ret = new HashSet<R>();
        Iterator<String> keys = this.listKeys();
        while (keys.hasNext()) {
            String key = keys.next();
            R filtered = filter.filter(key);
            if (filtered == null) continue;
            ret.add(filtered);
        }
        return ret;
    }

    public static final void validateKey(String key) throws AuthorizationException {
        if (StringUtils.isEmpty((String)key) || "..".equals(key) || ".".equals(key) || !KEY_PATTERN.matcher(key).matches()) {
            LOG.error("'{}' does not appear to be valid {}", (Object)key, (Object)KEY_PATTERN);
            throw new AuthorizationException(key + " does not appear to be a valid blob key");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createBlob(String key, byte[] data, SettableBlobMeta meta, Subject who) throws AuthorizationException, KeyAlreadyExistsException, IOException {
        AtomicOutputStream out = null;
        try {
            out = this.createBlob(key, meta, who);
            out.write(data);
            out.close();
            out = null;
        }
        finally {
            if (out != null) {
                out.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createBlob(String key, InputStream in, SettableBlobMeta meta, Subject who) throws AuthorizationException, KeyAlreadyExistsException, IOException {
        AtomicOutputStream out = null;
        try {
            out = this.createBlob(key, meta, who);
            byte[] buffer = new byte[2048];
            int len = 0;
            while ((len = in.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
            out.close();
        }
        catch (IOException | RuntimeException | AuthorizationException e) {
            if (out != null) {
                out.cancel();
            }
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readBlobTo(String key, OutputStream out, Subject who) throws IOException, KeyNotFoundException, AuthorizationException {
        InputStreamWithMeta in = this.getBlob(key, who);
        if (in == null) {
            throw new IOException("Could not find " + key);
        }
        byte[] buffer = new byte[2048];
        int len = 0;
        try {
            while ((len = in.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
        }
        finally {
            in.close();
            out.flush();
        }
    }

    public byte[] readBlob(String key, Subject who) throws IOException, KeyNotFoundException, AuthorizationException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.readBlobTo(key, out, who);
        byte[] bytes = out.toByteArray();
        out.close();
        return bytes;
    }

    public StormTopology readTopology(String topoId, Subject who) throws KeyNotFoundException, AuthorizationException, IOException {
        return Utils.deserialize(this.readBlob(ConfigUtils.masterStormCodeKey(topoId), who), StormTopology.class);
    }

    public Map<String, Object> readTopologyConf(String topoId, Subject who) throws KeyNotFoundException, AuthorizationException, IOException {
        return Utils.fromCompressedJsonConf(this.readBlob(ConfigUtils.masterStormConfKey(topoId), who));
    }

    public Set<String> storedTopoIds() {
        return this.filterAndListKeys(TO_TOPO_ID);
    }

    public static class KeyTranslationIterator
    implements Iterator<String> {
        private Iterator<String> it = null;
        private String next = null;
        private String prefix = null;

        public KeyTranslationIterator(Iterator<String> it, String prefix) throws IOException {
            this.it = it;
            this.prefix = prefix;
            this.primeNext();
        }

        private void primeNext() {
            this.next = null;
            while (this.it.hasNext()) {
                String tmp = this.it.next();
                if (!tmp.startsWith(this.prefix)) continue;
                this.next = tmp.substring(this.prefix.length());
                return;
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String current = this.next;
            this.primeNext();
            return current;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Delete Not Supported");
        }
    }

    protected class BlobStoreFileInputStream
    extends InputStreamWithMeta {
        private BlobStoreFile part;
        private InputStream in;

        public BlobStoreFileInputStream(BlobStoreFile part) throws IOException {
            this.part = part;
            this.in = part.getInputStream();
        }

        @Override
        public long getVersion() throws IOException {
            return this.part.getModTime();
        }

        @Override
        public int read() throws IOException {
            return this.in.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.in.read(b, off, len);
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.in.read(b);
        }

        @Override
        public int available() throws IOException {
            return this.in.available();
        }

        @Override
        public long getFileLength() throws IOException {
            return this.part.getFileLength();
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }
    }

    protected class BlobStoreFileOutputStream
    extends AtomicOutputStream {
        private BlobStoreFile part;
        private OutputStream out;

        public BlobStoreFileOutputStream(BlobStoreFile part) throws IOException {
            this.part = part;
            this.out = part.getOutputStream();
        }

        @Override
        public void close() throws IOException {
            try {
                this.out.close();
                this.part.commit();
            }
            catch (IOException | RuntimeException e) {
                this.cancel();
                throw e;
            }
        }

        @Override
        public void cancel() throws IOException {
            try {
                this.out.close();
            }
            finally {
                this.part.cancel();
            }
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.out.write(b);
        }

        @Override
        public void write(byte[] b, int offset, int len) throws IOException {
            this.out.write(b, offset, len);
        }
    }
}

