/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.cluster;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.storm.cluster.ClusterStateContext;
import org.apache.storm.cluster.ExecutorBeat;
import org.apache.storm.cluster.IStateStorage;
import org.apache.storm.cluster.IStormClusterState;
import org.apache.storm.cluster.StateStorageFactory;
import org.apache.storm.cluster.StormClusterStateImpl;
import org.apache.storm.generated.ClusterWorkerHeartbeat;
import org.apache.storm.generated.ExecutorInfo;
import org.apache.storm.generated.ExecutorStats;
import org.apache.storm.generated.ProfileAction;
import org.apache.storm.utils.Utils;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;
import org.apache.zookeeper.server.auth.DigestAuthenticationProvider;

public class ClusterUtils {
    public static final String ZK_SEPERATOR = "/";
    public static final String ASSIGNMENTS_ROOT = "assignments";
    public static final String CODE_ROOT = "code";
    public static final String STORMS_ROOT = "storms";
    public static final String SUPERVISORS_ROOT = "supervisors";
    public static final String WORKERBEATS_ROOT = "workerbeats";
    public static final String BACKPRESSURE_ROOT = "backpressure";
    public static final String ERRORS_ROOT = "errors";
    public static final String BLOBSTORE_ROOT = "blobstore";
    public static final String BLOBSTORE_MAX_KEY_SEQUENCE_NUMBER_ROOT = "blobstoremaxkeysequencenumber";
    public static final String NIMBUSES_ROOT = "nimbuses";
    public static final String CREDENTIALS_ROOT = "credentials";
    public static final String LOGCONFIG_ROOT = "logconfigs";
    public static final String PROFILERCONFIG_ROOT = "profilerconfigs";
    public static final String ASSIGNMENTS_SUBTREE = "/assignments";
    public static final String STORMS_SUBTREE = "/storms";
    public static final String SUPERVISORS_SUBTREE = "/supervisors";
    public static final String WORKERBEATS_SUBTREE = "/workerbeats";
    public static final String BACKPRESSURE_SUBTREE = "/backpressure";
    public static final String ERRORS_SUBTREE = "/errors";
    public static final String BLOBSTORE_SUBTREE = "/blobstore";
    public static final String BLOBSTORE_MAX_KEY_SEQUENCE_NUMBER_SUBTREE = "/blobstoremaxkeysequencenumber";
    public static final String NIMBUSES_SUBTREE = "/nimbuses";
    public static final String CREDENTIALS_SUBTREE = "/credentials";
    public static final String LOGCONFIG_SUBTREE = "/logconfigs";
    public static final String PROFILERCONFIG_SUBTREE = "/profilerconfigs";
    private static final ClusterUtils INSTANCE;
    private static ClusterUtils _instance;

    public static void setInstance(ClusterUtils u) {
        _instance = u;
    }

    public static void resetInstance() {
        _instance = INSTANCE;
    }

    public static List<ACL> mkTopoOnlyAcls(Map<String, Object> topoConf) throws NoSuchAlgorithmException {
        ArrayList<ACL> aclList = null;
        String payload = (String)topoConf.get("storm.zookeeper.topology.auth.payload");
        if (Utils.isZkAuthenticationConfiguredTopology(topoConf)) {
            aclList = new ArrayList<ACL>();
            ACL acl1 = (ACL)ZooDefs.Ids.CREATOR_ALL_ACL.get(0);
            aclList.add(acl1);
            ACL acl2 = new ACL(1, new Id("digest", DigestAuthenticationProvider.generateDigest((String)payload)));
            aclList.add(acl2);
        }
        return aclList;
    }

    public static String supervisorPath(String id) {
        return "/supervisors/" + id;
    }

    public static String assignmentPath(String id) {
        return "/assignments/" + id;
    }

    public static String blobstorePath(String key) {
        return "/blobstore/" + key;
    }

    public static String blobstoreMaxKeySequenceNumberPath(String key) {
        return "/blobstoremaxkeysequencenumber/" + key;
    }

    public static String nimbusPath(String id) {
        return "/nimbuses/" + id;
    }

    public static String stormPath(String id) {
        return "/storms/" + id;
    }

    public static String workerbeatStormRoot(String stormId) {
        return "/workerbeats/" + stormId;
    }

    public static String workerbeatPath(String stormId, String node, Long port) {
        return ClusterUtils.workerbeatStormRoot(stormId) + ZK_SEPERATOR + node + "-" + port;
    }

    public static String backpressureStormRoot(String stormId) {
        return "/backpressure/" + stormId;
    }

    public static String backpressurePath(String stormId, String node, Long port) {
        return ClusterUtils.backpressureStormRoot(stormId) + ZK_SEPERATOR + node + "-" + port;
    }

    public static String errorStormRoot(String stormId) {
        return "/errors/" + stormId;
    }

    public static String errorPath(String stormId, String componentId) {
        try {
            return ClusterUtils.errorStormRoot(stormId) + ZK_SEPERATOR + URLEncoder.encode(componentId, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw Utils.wrapInRuntime(e);
        }
    }

    public static String lastErrorPath(String stormId, String componentId) {
        return ClusterUtils.errorPath(stormId, componentId) + "-last-error";
    }

    public static String credentialsPath(String stormId) {
        return "/credentials/" + stormId;
    }

    public static String logConfigPath(String stormId) {
        return "/logconfigs/" + stormId;
    }

    public static String profilerConfigPath(String stormId) {
        return "/profilerconfigs/" + stormId;
    }

    public static String profilerConfigPath(String stormId, String host, Long port, ProfileAction requestType) {
        return ClusterUtils.profilerConfigPath(stormId) + ZK_SEPERATOR + host + "_" + port + "_" + (Object)((Object)requestType);
    }

    public static <T> T maybeDeserialize(byte[] serialized, Class<T> clazz) {
        if (serialized != null) {
            return Utils.deserialize(serialized, clazz);
        }
        return null;
    }

    public static Map<ExecutorInfo, ExecutorBeat> convertExecutorBeats(List<ExecutorInfo> executors, ClusterWorkerHeartbeat workerHeartbeat) {
        HashMap<ExecutorInfo, ExecutorBeat> executorWhb = new HashMap<ExecutorInfo, ExecutorBeat>();
        Map<ExecutorInfo, ExecutorStats> executorStatsMap = workerHeartbeat.get_executor_stats();
        for (ExecutorInfo executor : executors) {
            if (!executorStatsMap.containsKey(executor)) continue;
            int time = workerHeartbeat.get_time_secs();
            int uptime = workerHeartbeat.get_uptime_secs();
            ExecutorStats executorStats = workerHeartbeat.get_executor_stats().get(executor);
            ExecutorBeat executorBeat = new ExecutorBeat(time, uptime, executorStats);
            executorWhb.put(executor, executorBeat);
        }
        return executorWhb;
    }

    public IStormClusterState mkStormClusterStateImpl(Object stateStorage, List<ACL> acls, ClusterStateContext context) throws Exception {
        if (stateStorage instanceof IStateStorage) {
            return new StormClusterStateImpl((IStateStorage)stateStorage, acls, context, false);
        }
        IStateStorage Storage = _instance.mkStateStorageImpl((Map)stateStorage, (Map)stateStorage, acls, context);
        return new StormClusterStateImpl(Storage, acls, context, true);
    }

    public IStateStorage mkStateStorageImpl(Map<String, Object> config, Map auth_conf, List<ACL> acls, ClusterStateContext context) throws Exception {
        String className = null;
        IStateStorage stateStorage = null;
        className = config.get("storm.cluster.state.store") != null ? (String)config.get("storm.cluster.state.store") : "org.apache.storm.cluster.ZKStateStorageFactory";
        Class<?> clazz = Class.forName(className);
        StateStorageFactory storageFactory = (StateStorageFactory)clazz.newInstance();
        stateStorage = storageFactory.mkStore(config, auth_conf, acls, context);
        return stateStorage;
    }

    public static IStateStorage mkStateStorage(Map<String, Object> config, Map auth_conf, List<ACL> acls, ClusterStateContext context) throws Exception {
        return _instance.mkStateStorageImpl(config, auth_conf, acls, context);
    }

    public static IStormClusterState mkStormClusterState(Object StateStorage, List<ACL> acls, ClusterStateContext context) throws Exception {
        return _instance.mkStormClusterStateImpl(StateStorage, acls, context);
    }

    public static String stringifyError(Throwable error) {
        StringWriter result2 = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result2);
        error.printStackTrace(printWriter);
        return result2.toString();
    }

    static {
        _instance = INSTANCE = new ClusterUtils();
    }
}

