/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.container.cgroup.core;

import java.io.IOException;
import java.util.List;
import org.apache.storm.container.cgroup.CgroupUtils;
import org.apache.storm.container.cgroup.Device;
import org.apache.storm.container.cgroup.SubSystemType;
import org.apache.storm.container.cgroup.core.CgroupCore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DevicesCore
implements CgroupCore {
    private final String dir;
    private static final String DEVICES_ALLOW = "/devices.allow";
    private static final String DEVICES_DENY = "/devices.deny";
    private static final String DEVICES_LIST = "/devices.list";
    private static final char TYPE_ALL = 'a';
    private static final char TYPE_BLOCK = 'b';
    private static final char TYPE_CHAR = 'c';
    private static final int ACCESS_READ = 1;
    private static final int ACCESS_WRITE = 2;
    private static final int ACCESS_CREATE = 4;
    private static final char ACCESS_READ_CH = 'r';
    private static final char ACCESS_WRITE_CH = 'w';
    private static final char ACCESS_CREATE_CH = 'm';
    private static final Logger LOG = LoggerFactory.getLogger(DevicesCore.class);

    public DevicesCore(String dir) {
        this.dir = dir;
    }

    @Override
    public SubSystemType getType() {
        return SubSystemType.devices;
    }

    private void setPermission(String prop, char type, Device device, int accesses) throws IOException {
        Record record = new Record(type, device, accesses);
        CgroupUtils.writeFileByLine(CgroupUtils.getDir(this.dir, prop), record.toString());
    }

    public void setAllow(char type, Device device, int accesses) throws IOException {
        this.setPermission(DEVICES_ALLOW, type, device, accesses);
    }

    public void setDeny(char type, Device device, int accesses) throws IOException {
        this.setPermission(DEVICES_DENY, type, device, accesses);
    }

    public Record[] getList() throws IOException {
        List<String> output = CgroupUtils.readFileByLine(CgroupUtils.getDir(this.dir, DEVICES_LIST));
        return Record.parseRecordList(output);
    }

    public static class Record {
        Device device;
        char type;
        int accesses;

        public Record(char type, Device device, int accesses) {
            this.type = type;
            this.device = device;
            this.accesses = accesses;
        }

        public Record(String output) {
            if (output.contains("*")) {
                LOG.debug("Pre: {}", (Object)output);
                output = output.replaceAll("\\*", "-1");
                LOG.debug("After: {}", (Object)output);
            }
            String[] splits = output.split("[: ]");
            this.type = splits[0].charAt(0);
            int major = Integer.parseInt(splits[1]);
            int minor = Integer.parseInt(splits[2]);
            this.device = new Device(major, minor);
            this.accesses = 0;
            for (char c : splits[3].toCharArray()) {
                if (c == 'r') {
                    this.accesses |= 1;
                }
                if (c == 'm') {
                    this.accesses |= 4;
                }
                if (c != 'w') continue;
                this.accesses |= 2;
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.type);
            sb.append(' ');
            sb.append(this.device.major);
            sb.append(':');
            sb.append(this.device.minor);
            sb.append(' ');
            sb.append((CharSequence)Record.getAccessesFlag(this.accesses));
            return sb.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result2 = 1;
            result2 = 31 * result2 + this.accesses;
            result2 = 31 * result2 + (this.device == null ? 0 : this.device.hashCode());
            result2 = 31 * result2 + this.type;
            return result2;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Record other = (Record)obj;
            if (this.accesses != other.accesses) {
                return false;
            }
            if (this.device == null ? other.device != null : !this.device.equals(other.device)) {
                return false;
            }
            return this.type == other.type;
        }

        public static Record[] parseRecordList(List<String> output) {
            Record[] records = new Record[output.size()];
            int l = output.size();
            for (int i = 0; i < l; ++i) {
                records[i] = new Record(output.get(i));
            }
            return records;
        }

        public static StringBuilder getAccessesFlag(int accesses) {
            StringBuilder sb = new StringBuilder();
            if ((accesses & 1) != 0) {
                sb.append('r');
            }
            if ((accesses & 2) != 0) {
                sb.append('w');
            }
            if ((accesses & 4) != 0) {
                sb.append('m');
            }
            return sb;
        }
    }
}

