/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.container.cgroup.core;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.storm.container.cgroup.CgroupUtils;
import org.apache.storm.container.cgroup.SubSystemType;
import org.apache.storm.container.cgroup.core.CgroupCore;

public class NetPrioCore
implements CgroupCore {
    public static final String NET_PRIO_PRIOIDX = "/net_prio.prioidx";
    public static final String NET_PRIO_IFPRIOMAP = "/net_prio.ifpriomap";
    private final String dir;

    public NetPrioCore(String dir) {
        this.dir = dir;
    }

    @Override
    public SubSystemType getType() {
        return SubSystemType.net_prio;
    }

    public int getPrioId() throws IOException {
        return Integer.parseInt(CgroupUtils.readFileByLine(CgroupUtils.getDir(this.dir, NET_PRIO_PRIOIDX)).get(0));
    }

    public void setIfPrioMap(String iface, int priority) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(iface);
        sb.append(' ');
        sb.append(priority);
        CgroupUtils.writeFileByLine(CgroupUtils.getDir(this.dir, NET_PRIO_IFPRIOMAP), sb.toString());
    }

    public Map<String, Integer> getIfPrioMap() throws IOException {
        HashMap<String, Integer> result2 = new HashMap<String, Integer>();
        List<String> strs = CgroupUtils.readFileByLine(CgroupUtils.getDir(this.dir, NET_PRIO_IFPRIOMAP));
        for (String str : strs) {
            String[] strArgs = str.split(" ");
            result2.put(strArgs[0], Integer.valueOf(strArgs[1]));
        }
        return result2;
    }
}

