/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.coordination;

import java.util.HashMap;
import java.util.Map;
import org.apache.storm.coordination.BatchOutputCollectorImpl;
import org.apache.storm.coordination.CoordinatedBolt;
import org.apache.storm.coordination.IBatchBolt;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.FailedException;
import org.apache.storm.topology.IRichBolt;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.tuple.Tuple;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchBoltExecutor
implements IRichBolt,
CoordinatedBolt.FinishedCallback,
CoordinatedBolt.TimeoutCallback {
    public static final Logger LOG = LoggerFactory.getLogger(BatchBoltExecutor.class);
    byte[] _boltSer;
    Map<Object, IBatchBolt> _openTransactions;
    Map _conf;
    TopologyContext _context;
    BatchOutputCollectorImpl _collector;

    public BatchBoltExecutor(IBatchBolt bolt) {
        this._boltSer = Utils.javaSerialize(bolt);
    }

    @Override
    public void prepare(Map<String, Object> conf, TopologyContext context, OutputCollector collector) {
        this._conf = conf;
        this._context = context;
        this._collector = new BatchOutputCollectorImpl(collector);
        this._openTransactions = new HashMap<Object, IBatchBolt>();
    }

    @Override
    public void execute(Tuple input) {
        Object id = input.getValue(0);
        IBatchBolt bolt = this.getBatchBolt(id);
        try {
            bolt.execute(input);
            this._collector.ack(input);
        }
        catch (FailedException e) {
            LOG.error("Failed to process tuple in batch", (Throwable)e);
            this._collector.fail(input);
        }
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void finishedId(Object id) {
        IBatchBolt bolt = this.getBatchBolt(id);
        this._openTransactions.remove(id);
        bolt.finishBatch();
    }

    @Override
    public void timeoutId(Object attempt) {
        this._openTransactions.remove(attempt);
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        this.newTransactionalBolt().declareOutputFields(declarer);
    }

    @Override
    public Map<String, Object> getComponentConfiguration() {
        return this.newTransactionalBolt().getComponentConfiguration();
    }

    private IBatchBolt getBatchBolt(Object id) {
        IBatchBolt bolt = this._openTransactions.get(id);
        if (bolt == null) {
            bolt = this.newTransactionalBolt();
            bolt.prepare(this._conf, this._context, this._collector, id);
            this._openTransactions.put(id, bolt);
        }
        return bolt;
    }

    private IBatchBolt newTransactionalBolt() {
        return Utils.javaDeserialize(this._boltSer, IBatchBolt.class);
    }
}

