/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.metrics;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.storm.daemon.metrics.BuiltinBoltMetrics;
import org.apache.storm.daemon.metrics.BuiltinMetrics;
import org.apache.storm.daemon.metrics.BuiltinSpoutMetrics;
import org.apache.storm.metric.api.IMetric;
import org.apache.storm.metric.api.IStatefulObject;
import org.apache.storm.metric.api.StateMetric;
import org.apache.storm.stats.BoltExecutorStats;
import org.apache.storm.stats.CommonStats;
import org.apache.storm.stats.SpoutExecutorStats;
import org.apache.storm.task.TopologyContext;

public class BuiltinMetricsUtil {
    public static BuiltinMetrics mkData(String type, CommonStats stats) {
        if ("spout".equals(type)) {
            return new BuiltinSpoutMetrics((SpoutExecutorStats)stats);
        }
        if ("bolt".equals(type)) {
            return new BuiltinBoltMetrics((BoltExecutorStats)stats);
        }
        throw new RuntimeException("Invalid component type!");
    }

    public static void registerIconnectionServerMetric(Object server, Map<String, Object> topoConf, TopologyContext context) {
        if (server instanceof IStatefulObject) {
            BuiltinMetricsUtil.registerMetric("__recv-iconnection", new StateMetric((IStatefulObject)server), topoConf, context);
        }
    }

    public static void registerIconnectionClientMetrics(final Map nodePortToSocket, Map<String, Object> topoConf, TopologyContext context) {
        IMetric metric = new IMetric(){

            @Override
            public Object getValueAndReset() {
                HashMap ret = new HashMap();
                Iterator iterator = nodePortToSocket.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry o;
                    Map.Entry entry = o = iterator.next();
                    Object nodePort = entry.getKey();
                    Object connection = entry.getValue();
                    if (!(connection instanceof IStatefulObject)) continue;
                    ret.put(nodePort, ((IStatefulObject)connection).getState());
                }
                return ret;
            }
        };
        BuiltinMetricsUtil.registerMetric("__send-iconnection", metric, topoConf, context);
    }

    public static void registerQueueMetrics(Map queues, Map<String, Object> topoConf, TopologyContext context) {
        Iterator iterator = queues.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = iterator.next();
            String name = "__" + entry.getKey();
            StateMetric metric = new StateMetric((IStatefulObject)entry.getValue());
            BuiltinMetricsUtil.registerMetric(name, metric, topoConf, context);
        }
    }

    public static void registerMetric(String name, IMetric metric, Map<String, Object> topoConf, TopologyContext context) {
        int bucketSize = ((Number)topoConf.get("topology.builtin.metrics.bucket.size.secs")).intValue();
        context.registerMetric(name, metric, bucketSize);
    }
}

