/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.worker;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.storm.generated.LogConfig;
import org.apache.storm.generated.LogLevel;
import org.apache.storm.generated.LogLevelAction;
import org.apache.storm.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogConfigManager {
    private static final Logger LOG = LoggerFactory.getLogger(LogConfigManager.class);
    private final AtomicReference<TreeMap<String, LogLevel>> latestLogConfig;
    private final Map<String, Level> originalLogLevels;

    public LogConfigManager() {
        this(new AtomicReference<TreeMap<String, LogLevel>>(new TreeMap()));
    }

    public LogConfigManager(AtomicReference<TreeMap<String, LogLevel>> latestLogConfig) {
        this.latestLogConfig = latestLogConfig;
        this.originalLogLevels = this.getLoggerLevels();
        LOG.info("Started with log levels: {}", this.originalLogLevels);
    }

    public void processLogConfigChange(LogConfig logConfig) {
        if (null != logConfig) {
            LOG.debug("Processing received log config: {}", (Object)logConfig);
            TreeMap<String, LogLevel> loggers = new TreeMap<String, LogLevel>(logConfig.get_named_logger_level());
            LoggerContext logContext = (LoggerContext)LogManager.getContext((boolean)false);
            HashMap<String, LogLevel> newLogConfigs = new HashMap<String, LogLevel>();
            for (Map.Entry<String, LogLevel> entry : loggers.entrySet()) {
                String msgLoggerName = entry.getKey();
                String string = msgLoggerName = "ROOT".equalsIgnoreCase(msgLoggerName) ? "" : msgLoggerName;
                LogLevel loggerLevel = entry.getValue();
                if (!loggerLevel.is_set_reset_log_level_timeout_epoch()) continue;
                LogLevel copy = new LogLevel(loggerLevel);
                if (this.originalLogLevels.containsKey(msgLoggerName)) {
                    copy.set_reset_log_level(this.originalLogLevels.get(msgLoggerName).name());
                } else {
                    copy.set_reset_log_level(Level.INFO.name());
                }
                newLogConfigs.put(msgLoggerName, copy);
            }
            TreeMap<String, LogLevel> latestConf = this.latestLogConfig.get();
            if (latestConf != null) {
                for (String loggerName : latestConf.descendingKeySet()) {
                    if (newLogConfigs.containsKey(loggerName)) continue;
                    this.setLoggerLevel(logContext, loggerName, latestConf.get(loggerName).get_reset_log_level());
                }
            }
            for (String loggerName : new TreeSet<String>(logConfig.get_named_logger_level().keySet())) {
                LogLevel logLevel = logConfig.get_named_logger_level().get(loggerName);
                String string = loggerName = "ROOT".equalsIgnoreCase(loggerName) ? "" : loggerName;
                LogLevelAction action = logLevel.get_action();
                if (action != LogLevelAction.UPDATE) continue;
                this.setLoggerLevel(logContext, loggerName, logLevel.get_target_log_level());
            }
            logContext.updateLoggers();
            this.latestLogConfig.set(new TreeMap(newLogConfigs));
            LOG.debug("New merged log config is {}", this.latestLogConfig.get());
        }
    }

    public void resetLogLevels() {
        TreeMap<String, LogLevel> latestLogLevelMap = this.latestLogConfig.get();
        LoggerContext loggerContext = (LoggerContext)LogManager.getContext((boolean)false);
        for (String loggerName : latestLogLevelMap.descendingKeySet()) {
            LogLevel loggerSetting = latestLogLevelMap.get(loggerName);
            long timeout = loggerSetting.get_reset_log_level_timeout_epoch();
            String resetLogLevel = loggerSetting.get_reset_log_level();
            if (timeout < Time.currentTimeMillis()) {
                LOG.info("{}: Resetting level to {}", (Object)loggerName, (Object)resetLogLevel);
                this.setLoggerLevel(loggerContext, loggerName, resetLogLevel);
            }
            this.latestLogConfig.getAndUpdate(input -> {
                TreeMap result2 = new TreeMap(input);
                result2.remove(loggerName);
                return result2;
            });
        }
        loggerContext.updateLoggers();
    }

    public Map<String, Level> getLoggerLevels() {
        Configuration loggerConfig = ((LoggerContext)LogManager.getContext((boolean)false)).getConfiguration();
        HashMap<String, Level> logLevelMap = new HashMap<String, Level>();
        for (Map.Entry entry : loggerConfig.getLoggers().entrySet()) {
            logLevelMap.put((String)entry.getKey(), ((LoggerConfig)entry.getValue()).getLevel());
        }
        return logLevelMap;
    }

    public void setLoggerLevel(LoggerContext logContext, String loggerName, String newLevelStr) {
        Level newLevel = Level.getLevel((String)newLevelStr);
        Configuration configuration = logContext.getConfiguration();
        LoggerConfig loggerConfig = configuration.getLoggerConfig(loggerName);
        if (loggerConfig.getName().equalsIgnoreCase(loggerName)) {
            LOG.info("Setting {} log level to: {}", (Object)loggerConfig, (Object)newLevel);
            loggerConfig.setLevel(newLevel);
        } else {
            LoggerConfig newLoggerConfig = new LoggerConfig(loggerName, newLevel, true);
            LOG.info("Adding config for: {} with level: {}", (Object)newLoggerConfig, (Object)newLevel);
            configuration.addLogger(loggerName, newLoggerConfig);
        }
    }
}

