/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.drpc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import org.apache.storm.ILocalDRPC;
import org.apache.storm.drpc.DRPCInvocationsClient;
import org.apache.storm.generated.AuthorizationException;
import org.apache.storm.generated.DRPCRequest;
import org.apache.storm.generated.DistributedRPCInvocations;
import org.apache.storm.spout.SpoutOutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.topology.base.BaseRichSpout;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Values;
import org.apache.storm.utils.DRPCClient;
import org.apache.storm.utils.ExtendedThreadPoolExecutor;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.ServiceRegistry;
import org.apache.storm.utils.Utils;
import org.apache.thrift.TException;
import org.json.simple.JSONValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DRPCSpout
extends BaseRichSpout {
    static final long serialVersionUID = 2387848310969237877L;
    public static final Logger LOG = LoggerFactory.getLogger(DRPCSpout.class);
    SpoutOutputCollector _collector;
    List<DRPCInvocationsClient> _clients = new ArrayList<DRPCInvocationsClient>();
    transient LinkedList<Future<Void>> _futures = null;
    transient ExecutorService _backround = null;
    final String _function;
    final String _local_drpc_id;

    public DRPCSpout(String function) {
        this._function = function;
        this._local_drpc_id = DRPCClient.isLocalOverride() ? DRPCClient.getOverrideServiceId() : null;
    }

    public DRPCSpout(String function, ILocalDRPC drpc) {
        this._function = function;
        this._local_drpc_id = drpc.getServiceId();
    }

    public String get_function() {
        return this._function;
    }

    private void reconnectAsync(final DRPCInvocationsClient client) {
        this._futures.add(this._backround.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                client.reconnectClient();
                return null;
            }
        }));
    }

    private void reconnectSync(DRPCInvocationsClient client) {
        try {
            LOG.info("reconnecting... ");
            client.reconnectClient();
        }
        catch (TException e2) {
            LOG.error("Failed to connect to DRPC server", (Throwable)e2);
        }
    }

    private void checkFutures() {
        Iterator i = this._futures.iterator();
        while (i.hasNext()) {
            Future f = (Future)i.next();
            if (f.isDone()) {
                i.remove();
            }
            try {
                f.get();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void open(Map<String, Object> conf, TopologyContext context, SpoutOutputCollector collector) {
        this._collector = collector;
        if (this._local_drpc_id == null) {
            this._backround = new ExtendedThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
            this._futures = new LinkedList();
            int numTasks = context.getComponentTasks(context.getThisComponentId()).size();
            int index = context.getThisTaskIndex();
            int port = ObjectReader.getInt(conf.get("drpc.invocations.port"));
            List servers = (List)conf.get("drpc.servers");
            if (servers == null || servers.isEmpty()) {
                throw new RuntimeException("No DRPC servers configured for topology");
            }
            if (numTasks < servers.size()) {
                for (String s : servers) {
                    this._futures.add(this._backround.submit(new Adder(s, port, conf)));
                }
            } else {
                int i = index % servers.size();
                this._futures.add(this._backround.submit(new Adder((String)servers.get(i), port, conf)));
            }
        }
    }

    @Override
    public void close() {
        for (DRPCInvocationsClient client : this._clients) {
            client.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nextTuple() {
        boolean gotRequest = false;
        if (this._local_drpc_id == null) {
            int size = 0;
            List<DRPCInvocationsClient> list = this._clients;
            synchronized (list) {
                size = this._clients.size();
            }
            for (int i = 0; i < size; ++i) {
                DRPCInvocationsClient client;
                List<DRPCInvocationsClient> list2 = this._clients;
                synchronized (list2) {
                    client = this._clients.get(i);
                }
                if (!client.isConnected()) {
                    LOG.warn("DRPCInvocationsClient [{}:{}] is not connected.", (Object)client.getHost(), (Object)client.getPort());
                    this.reconnectAsync(client);
                    continue;
                }
                try {
                    DRPCRequest req = client.fetchRequest(this._function);
                    if (req.get_request_id().length() <= 0) continue;
                    HashMap<String, Object> returnInfo = new HashMap<String, Object>();
                    returnInfo.put("id", req.get_request_id());
                    returnInfo.put("host", client.getHost());
                    returnInfo.put("port", client.getPort());
                    gotRequest = true;
                    this._collector.emit(new Values(req.get_func_args(), JSONValue.toJSONString(returnInfo)), new DRPCMessageId(req.get_request_id(), i));
                    break;
                }
                catch (AuthorizationException aze) {
                    this.reconnectAsync(client);
                    LOG.error("Not authorized to fetch DRPC result from DRPC server", (Throwable)((Object)aze));
                    continue;
                }
                catch (TException e) {
                    this.reconnectAsync(client);
                    LOG.error("Failed to fetch DRPC result from DRPC server", (Throwable)e);
                    continue;
                }
                catch (Exception e) {
                    LOG.error("Failed to fetch DRPC result from DRPC server", (Throwable)e);
                }
            }
            this.checkFutures();
        } else {
            DistributedRPCInvocations.Iface drpc = (DistributedRPCInvocations.Iface)ServiceRegistry.getService(this._local_drpc_id);
            if (drpc != null) {
                try {
                    DRPCRequest req = drpc.fetchRequest(this._function);
                    if (req.get_request_id().length() > 0) {
                        HashMap<String, Object> returnInfo = new HashMap<String, Object>();
                        returnInfo.put("id", req.get_request_id());
                        returnInfo.put("host", this._local_drpc_id);
                        returnInfo.put("port", 0);
                        gotRequest = true;
                        this._collector.emit(new Values(req.get_func_args(), JSONValue.toJSONString(returnInfo)), new DRPCMessageId(req.get_request_id(), 0));
                    }
                }
                catch (AuthorizationException aze) {
                    throw new RuntimeException((Throwable)((Object)aze));
                }
                catch (TException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (!gotRequest) {
            Utils.sleep(1L);
        }
    }

    @Override
    public void ack(Object msgId) {
    }

    @Override
    public void fail(Object msgId) {
        DRPCMessageId did = (DRPCMessageId)msgId;
        DistributedRPCInvocations.Iface client = this._local_drpc_id == null ? (DistributedRPCInvocations.Iface)this._clients.get(did.index) : (DistributedRPCInvocations.Iface)ServiceRegistry.getService(this._local_drpc_id);
        int maxRetries = 3;
        for (int retryCnt = 0; retryCnt < maxRetries; ++retryCnt) {
            try {
                client.failRequest(did.id);
                break;
            }
            catch (AuthorizationException aze) {
                LOG.error("Not authorized to failRequest from DRPC server", (Throwable)((Object)aze));
                throw new RuntimeException((Throwable)((Object)aze));
            }
            catch (TException tex) {
                if (retryCnt >= maxRetries) {
                    LOG.error("Failed to fail request", (Throwable)tex);
                    break;
                }
                this.reconnectSync((DRPCInvocationsClient)client);
                continue;
            }
        }
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        declarer.declare(new Fields("args", "return-info"));
    }

    private class Adder
    implements Callable<Void> {
        private String server;
        private int port;
        private Map<String, Object> conf;

        public Adder(String server, int port, Map<String, Object> conf) {
            this.server = server;
            this.port = port;
            this.conf = conf;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            DRPCInvocationsClient c = new DRPCInvocationsClient(this.conf, this.server, this.port);
            List<DRPCInvocationsClient> list = DRPCSpout.this._clients;
            synchronized (list) {
                DRPCSpout.this._clients.add(c);
            }
            return null;
        }
    }

    private static class DRPCMessageId {
        String id;
        int index;

        public DRPCMessageId(String id, int index) {
            this.id = id;
            this.index = index;
        }
    }
}

