/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.executor.bolt;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.storm.ICredentialsListener;
import org.apache.storm.daemon.Task;
import org.apache.storm.daemon.metrics.BuiltinMetricsUtil;
import org.apache.storm.daemon.worker.WorkerState;
import org.apache.storm.executor.Executor;
import org.apache.storm.executor.bolt.BoltOutputCollectorImpl;
import org.apache.storm.generated.NodeInfo;
import org.apache.storm.hooks.info.BoltExecuteInfo;
import org.apache.storm.messaging.IConnection;
import org.apache.storm.stats.BoltExecutorStats;
import org.apache.storm.task.IBolt;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.tuple.TupleImpl;
import org.apache.storm.utils.ConfigUtils;
import org.apache.storm.utils.Time;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoltExecutor
extends Executor {
    private static final Logger LOG = LoggerFactory.getLogger(BoltExecutor.class);
    private final Callable<Boolean> executeSampler;

    public BoltExecutor(WorkerState workerData, List<Long> executorId, Map<String, String> credentials) {
        super(workerData, executorId, credentials);
        this.executeSampler = ConfigUtils.mkStatsSampler(this.topoConf);
    }

    public void init(Map<Integer, Task> idToTask) {
        while (!this.stormActive.get()) {
            Utils.sleep(100L);
        }
        LOG.info("Preparing bolt {}:{}", (Object)this.componentId, idToTask.keySet());
        for (Map.Entry<Integer, Task> entry : idToTask.entrySet()) {
            ImmutableMap map;
            Task taskData = entry.getValue();
            IBolt boltObject = (IBolt)taskData.getTaskObject();
            TopologyContext userContext = taskData.getUserContext();
            taskData.getBuiltInMetrics().registerAll(this.topoConf, userContext);
            if (boltObject instanceof ICredentialsListener) {
                ((ICredentialsListener)((Object)boltObject)).setCredentials(this.credentials);
            }
            if ("__system".equals(this.componentId)) {
                map = ImmutableMap.of((Object)"sendqueue", (Object)this.transferQueue, (Object)"receive", (Object)this.receiveQueue, (Object)"transfer", (Object)this.workerData.getTransferQueue());
                BuiltinMetricsUtil.registerQueueMetrics((Map)map, this.topoConf, userContext);
                Map<NodeInfo, IConnection> cachedNodePortToSocket = this.workerData.getCachedNodeToPortSocket().get();
                BuiltinMetricsUtil.registerIconnectionClientMetrics(cachedNodePortToSocket, this.topoConf, userContext);
                BuiltinMetricsUtil.registerIconnectionServerMetric(this.workerData.getReceiver(), this.topoConf, userContext);
            } else {
                map = ImmutableMap.of((Object)"sendqueue", (Object)this.transferQueue, (Object)"receive", (Object)this.receiveQueue);
                BuiltinMetricsUtil.registerQueueMetrics((Map)map, this.topoConf, userContext);
            }
            BoltOutputCollectorImpl outputCollector = new BoltOutputCollectorImpl(this, taskData, entry.getKey(), this.rand, this.hasEventLoggers, this.isDebug);
            boltObject.prepare(this.topoConf, userContext, new OutputCollector(outputCollector));
        }
        this.openOrPrepareWasCalled.set(true);
        LOG.info("Prepared bolt {}:{}", (Object)this.componentId, idToTask.keySet());
        this.setupMetrics();
    }

    public Callable<Object> call() throws Exception {
        this.init(this.idToTask);
        return new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                BoltExecutor.this.receiveQueue.consumeBatchWhenAvailable(BoltExecutor.this);
                return 0L;
            }
        };
    }

    @Override
    public void tupleActionFn(int taskId, TupleImpl tuple) throws Exception {
        String streamId = tuple.getSourceStreamId();
        if ("__credentials".equals(streamId)) {
            Object taskObject = ((Task)this.idToTask.get(taskId)).getTaskObject();
            if (taskObject instanceof ICredentialsListener) {
                ((ICredentialsListener)taskObject).setCredentials((Map)tuple.getValue(0));
            }
        } else if ("__metrics_tick".equals(streamId)) {
            this.metricsTick((Task)this.idToTask.get(taskId), tuple);
        } else {
            long delta;
            Long now;
            IBolt boltObject = (IBolt)((Task)this.idToTask.get(taskId)).getTaskObject();
            boolean isSampled = (Boolean)this.sampler.call();
            boolean isExecuteSampler = this.executeSampler.call();
            Long l = now = isSampled || isExecuteSampler ? Long.valueOf(Time.currentTimeMillis()) : null;
            if (isSampled) {
                tuple.setProcessSampleStartTime(now);
            }
            if (isExecuteSampler) {
                tuple.setExecuteSampleStartTime(now);
            }
            boltObject.execute(tuple);
            Long ms = tuple.getExecuteSampleStartTime();
            long l2 = delta = ms != null ? Time.deltaMs(ms) : 0L;
            if (this.isDebug.booleanValue()) {
                LOG.info("Execute done TUPLE {} TASK: {} DELTA: {}", new Object[]{tuple, taskId, delta});
            }
            new BoltExecuteInfo(tuple, taskId, delta).applyOn(((Task)this.idToTask.get(taskId)).getUserContext());
            if (delta >= 0L) {
                ((BoltExecutorStats)this.stats).boltExecuteTuple(tuple.getSourceComponent(), tuple.getSourceStreamId(), delta);
            }
        }
    }
}

