/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.grouping;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.storm.generated.GlobalStreamId;
import org.apache.storm.grouping.CustomStreamGrouping;
import org.apache.storm.task.WorkerTopologyContext;

public class ShuffleGrouping
implements CustomStreamGrouping,
Serializable {
    private Random random;
    private ArrayList<List<Integer>> choices;
    private AtomicInteger current;

    @Override
    public void prepare(WorkerTopologyContext context, GlobalStreamId stream, List<Integer> targetTasks) {
        this.random = new Random();
        this.choices = new ArrayList(targetTasks.size());
        for (Integer i : targetTasks) {
            this.choices.add(Arrays.asList(i));
        }
        Collections.shuffle(this.choices, this.random);
        this.current = new AtomicInteger(0);
    }

    @Override
    public List<Integer> chooseTasks(int taskId, List<Object> values) {
        int rightNow;
        int size = this.choices.size();
        do {
            if ((rightNow = this.current.incrementAndGet()) >= size) continue;
            return this.choices.get(rightNow);
        } while (rightNow != size);
        this.current.set(0);
        return this.choices.get(0);
    }
}

