/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.messaging;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.storm.daemon.worker.WorkerState;
import org.apache.storm.messaging.IConnectionCallback;
import org.apache.storm.messaging.TaskMessage;
import org.apache.storm.serialization.KryoTupleDeserializer;
import org.apache.storm.task.GeneralTopologyContext;
import org.apache.storm.tuple.AddressedTuple;

public class DeserializingConnectionCallback
implements IConnectionCallback {
    private final WorkerState.ILocalTransferCallback _cb;
    private final Map _conf;
    private final GeneralTopologyContext _context;
    private final ThreadLocal<KryoTupleDeserializer> _des = new ThreadLocal<KryoTupleDeserializer>(){

        @Override
        protected KryoTupleDeserializer initialValue() {
            return new KryoTupleDeserializer(DeserializingConnectionCallback.this._conf, DeserializingConnectionCallback.this._context);
        }
    };

    public DeserializingConnectionCallback(Map<String, Object> conf, GeneralTopologyContext context, WorkerState.ILocalTransferCallback callback) {
        this._conf = conf;
        this._context = context;
        this._cb = callback;
    }

    @Override
    public void recv(List<TaskMessage> batch) {
        KryoTupleDeserializer des = this._des.get();
        ArrayList<AddressedTuple> ret = new ArrayList<AddressedTuple>(batch.size());
        for (TaskMessage message : batch) {
            ret.add(new AddressedTuple(message.task(), des.deserialize(message.message())));
        }
        this._cb.transfer(ret);
    }
}

