/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.messaging.netty;

import java.util.ArrayList;
import org.apache.storm.messaging.TaskMessage;
import org.apache.storm.messaging.netty.ControlMessage;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferOutputStream;
import org.jboss.netty.buffer.ChannelBuffers;

class MessageBatch {
    private int buffer_size;
    private ArrayList<TaskMessage> msgs;
    private int encoded_length;

    MessageBatch(int buffer_size) {
        this.buffer_size = buffer_size;
        this.msgs = new ArrayList();
        this.encoded_length = ControlMessage.EOB_MESSAGE.encodeLength();
    }

    void add(TaskMessage msg) {
        if (msg == null) {
            throw new RuntimeException("null object forbidden in message batch");
        }
        this.msgs.add(msg);
        this.encoded_length += this.msgEncodeLength(msg);
    }

    private int msgEncodeLength(TaskMessage taskMsg) {
        if (taskMsg == null) {
            return 0;
        }
        int size = 6;
        if (taskMsg.message() != null) {
            size += taskMsg.message().length;
        }
        return size;
    }

    boolean isFull() {
        return this.encoded_length >= this.buffer_size;
    }

    boolean isEmpty() {
        return this.msgs.isEmpty();
    }

    int size() {
        return this.msgs.size();
    }

    ChannelBuffer buffer() throws Exception {
        ChannelBufferOutputStream bout = new ChannelBufferOutputStream(ChannelBuffers.directBuffer((int)this.encoded_length));
        for (TaskMessage msg : this.msgs) {
            this.writeTaskMessage(bout, msg);
        }
        ControlMessage.EOB_MESSAGE.write(bout);
        bout.close();
        return bout.buffer();
    }

    private void writeTaskMessage(ChannelBufferOutputStream bout, TaskMessage message) throws Exception {
        int task_id;
        int payload_len = 0;
        if (message.message() != null) {
            payload_len = message.message().length;
        }
        if ((task_id = message.task()) > Short.MAX_VALUE) {
            throw new RuntimeException("Task ID should not exceed 32767");
        }
        bout.writeShort((int)((short)task_id));
        bout.writeInt(payload_len);
        if (payload_len > 0) {
            bout.write(message.message());
        }
    }
}

