/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.messaging.netty;

import java.io.IOException;
import org.apache.storm.messaging.netty.INettySerializable;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferOutputStream;
import org.jboss.netty.buffer.ChannelBuffers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaslMessageToken
implements INettySerializable {
    public static final short IDENTIFIER = -500;
    private static final Logger LOG = LoggerFactory.getLogger(SaslMessageToken.class);
    private byte[] token;

    public SaslMessageToken() {
    }

    public SaslMessageToken(byte[] token) {
        this.token = token;
    }

    public byte[] getSaslToken() {
        return this.token;
    }

    public void setSaslToken(byte[] token) {
        this.token = token;
    }

    @Override
    public int encodeLength() {
        return 6 + this.token.length;
    }

    @Override
    public ChannelBuffer buffer() throws IOException {
        ChannelBufferOutputStream bout = new ChannelBufferOutputStream(ChannelBuffers.directBuffer((int)this.encodeLength()));
        int payload_len = 0;
        if (this.token != null) {
            payload_len = this.token.length;
        }
        bout.writeShort(-500);
        bout.writeInt(payload_len);
        if (payload_len > 0) {
            bout.write(this.token);
        }
        bout.close();
        return bout.buffer();
    }

    public static SaslMessageToken read(byte[] serial) {
        ChannelBuffer sm_buffer = ChannelBuffers.copiedBuffer((byte[])serial);
        short identifier = sm_buffer.readShort();
        int payload_len = sm_buffer.readInt();
        if (identifier != -500) {
            return null;
        }
        byte[] token = new byte[payload_len];
        sm_buffer.readBytes(token, 0, payload_len);
        return new SaslMessageToken(token);
    }
}

