/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.messaging.netty;

import java.io.IOException;
import org.apache.storm.messaging.netty.ControlMessage;
import org.apache.storm.messaging.netty.ISaslClient;
import org.apache.storm.messaging.netty.SaslMessageToken;
import org.apache.storm.messaging.netty.SaslNettyClient;
import org.apache.storm.messaging.netty.SaslNettyClientState;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaslStormClientHandler
extends SimpleChannelUpstreamHandler {
    private static final Logger LOG = LoggerFactory.getLogger(SaslStormClientHandler.class);
    private ISaslClient client;
    long start_time;
    private byte[] token;
    private String name;

    public SaslStormClientHandler(ISaslClient client) throws IOException {
        this.client = client;
        this.start_time = System.currentTimeMillis();
        this.getSASLCredentials();
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent event) {
        Channel channel = ctx.getChannel();
        this.client.channelConnected(channel);
        try {
            SaslNettyClient saslNettyClient = (SaslNettyClient)SaslNettyClientState.getSaslNettyClient.get(channel);
            if (saslNettyClient == null) {
                LOG.debug("Creating saslNettyClient now for channel: " + channel);
                saslNettyClient = new SaslNettyClient(this.name, this.token);
                SaslNettyClientState.getSaslNettyClient.set(channel, (Object)saslNettyClient);
            }
            LOG.debug("Sending SASL_TOKEN_MESSAGE_REQUEST");
            channel.write((Object)ControlMessage.SASL_TOKEN_MESSAGE_REQUEST);
        }
        catch (Exception e) {
            LOG.error("Failed to authenticate with server due to error: ", (Throwable)e);
        }
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent event) throws Exception {
        ControlMessage msg;
        LOG.debug("send/recv time (ms): {}", (Object)(System.currentTimeMillis() - this.start_time));
        Channel channel = ctx.getChannel();
        SaslNettyClient saslNettyClient = (SaslNettyClient)SaslNettyClientState.getSaslNettyClient.get(channel);
        if (saslNettyClient == null) {
            throw new Exception("saslNettyClient was unexpectedly null for channel: " + channel);
        }
        if (event.getMessage() instanceof ControlMessage && (msg = (ControlMessage)event.getMessage()) == ControlMessage.SASL_COMPLETE_REQUEST) {
            LOG.debug("Server has sent us the SaslComplete message. Allowing normal work to proceed.");
            if (!saslNettyClient.isComplete()) {
                LOG.error("Server returned a Sasl-complete message, but as far as we can tell, we are not authenticated yet.");
                throw new Exception("Server returned a Sasl-complete message, but as far as we can tell, we are not authenticated yet.");
            }
            ctx.getPipeline().remove((ChannelHandler)this);
            this.client.channelReady();
            Channels.fireMessageReceived((ChannelHandlerContext)ctx, (Object)msg);
            return;
        }
        SaslMessageToken saslTokenMessage = (SaslMessageToken)event.getMessage();
        LOG.debug("Responding to server's token of length: " + saslTokenMessage.getSaslToken().length);
        byte[] responseToServer = saslNettyClient.saslResponse(saslTokenMessage);
        if (responseToServer == null) {
            LOG.debug("Response to server is null: authentication should now be complete.");
            if (!saslNettyClient.isComplete()) {
                LOG.warn("Generated a null response, but authentication is not complete.");
                throw new Exception("Server response is null, but as far as we can tell, we are not authenticated yet.");
            }
            this.client.channelReady();
            return;
        }
        LOG.debug("Response to server token has length:" + responseToServer.length);
        SaslMessageToken saslResponse = new SaslMessageToken(responseToServer);
        channel.write((Object)saslResponse);
    }

    private void getSASLCredentials() throws IOException {
        this.name = this.client.name();
        String secretKey = this.client.secretKey();
        if (secretKey != null) {
            this.token = secretKey.getBytes();
        }
        LOG.debug("SASL credentials for storm topology " + this.name + " is " + secretKey);
    }
}

