/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.messaging.netty;

import java.io.IOException;
import java.net.ConnectException;
import java.util.List;
import java.util.Map;
import org.apache.storm.messaging.TaskMessage;
import org.apache.storm.messaging.netty.Client;
import org.apache.storm.messaging.netty.ControlMessage;
import org.apache.storm.serialization.KryoValuesDeserializer;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StormClientHandler
extends SimpleChannelUpstreamHandler {
    private static final Logger LOG = LoggerFactory.getLogger(StormClientHandler.class);
    private Client client;
    private KryoValuesDeserializer _des;

    StormClientHandler(Client client, Map<String, Object> conf) {
        this.client = client;
        this._des = new KryoValuesDeserializer(conf);
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent event) {
        Object message = event.getMessage();
        if (message instanceof ControlMessage) {
            ControlMessage msg = (ControlMessage)message;
            if (msg == ControlMessage.FAILURE_RESPONSE) {
                LOG.info("failure response:{}", (Object)msg);
            }
        } else if (message instanceof List) {
            try {
                List list = (List)message;
                if (list.size() < 1) {
                    throw new RuntimeException("Didn't see enough load metrics (" + this.client.getDstAddress() + ") " + list);
                }
                TaskMessage tm = (TaskMessage)((List)message).get(list.size() - 1);
                if (tm.task() != -1) {
                    throw new RuntimeException("Metrics messages are sent to the system task (" + this.client.getDstAddress() + ") " + tm);
                }
                List<Object> metrics = this._des.deserialize(tm.message());
                if (metrics.size() < 1) {
                    throw new RuntimeException("No metrics data in the metrics message (" + this.client.getDstAddress() + ") " + metrics);
                }
                if (!(metrics.get(0) instanceof Map)) {
                    throw new RuntimeException("The metrics did not have a map in the first slot (" + this.client.getDstAddress() + ") " + metrics);
                }
                this.client.setLoadMetrics((Map)metrics.get(0));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new RuntimeException("Don't know how to handle a message of type " + message + " (" + this.client.getDstAddress() + ")");
        }
    }

    public void channelInterestChanged(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.client.notifyInterestChanged(e.getChannel());
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent event) {
        Throwable cause = event.getCause();
        if (!(cause instanceof ConnectException)) {
            LOG.info("Connection to " + this.client.getDstAddress() + " failed:", cause);
        }
    }
}

