/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.metric;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.storm.metric.IEventLogger;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.utils.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBasedEventLogger
implements IEventLogger {
    private static final Logger LOG = LoggerFactory.getLogger(FileBasedEventLogger.class);
    private static final int FLUSH_INTERVAL_MILLIS = 1000;
    private Path eventLogPath;
    private BufferedWriter eventLogWriter;
    private volatile boolean dirty = false;

    private void initLogWriter(Path logFilePath) {
        try {
            LOG.info("logFilePath {}", (Object)logFilePath);
            this.eventLogPath = logFilePath;
            this.eventLogWriter = Files.newBufferedWriter(this.eventLogPath, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            LOG.error("Error setting up FileBasedEventLogger.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void setUpFlushTask() {
        ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    if (FileBasedEventLogger.this.dirty) {
                        FileBasedEventLogger.this.eventLogWriter.flush();
                        FileBasedEventLogger.this.dirty = false;
                    }
                }
                catch (IOException ex) {
                    LOG.error("Error flushing " + FileBasedEventLogger.this.eventLogPath, (Throwable)ex);
                    throw new RuntimeException(ex);
                }
            }
        };
        scheduler.scheduleAtFixedRate(task, 1000L, 1000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void prepare(Map<String, Object> topoConf, TopologyContext context) {
        String stormId = context.getStormId();
        int port = context.getThisWorkerPort();
        String workersArtifactRoot = ConfigUtils.workerArtifactsRoot(topoConf, stormId, port);
        Path path = Paths.get(workersArtifactRoot, "events.log");
        File dir = path.toFile().getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        this.initLogWriter(path);
        this.setUpFlushTask();
    }

    @Override
    public void log(IEventLogger.EventInfo event) {
        try {
            this.eventLogWriter.write(event.toString());
            this.eventLogWriter.newLine();
            this.dirty = true;
        }
        catch (IOException ex) {
            LOG.error("Error logging event {}", (Object)event, (Object)ex);
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void close() {
        try {
            this.eventLogWriter.close();
        }
        catch (IOException ex) {
            LOG.error("Error closing event log.", (Throwable)ex);
        }
    }
}

