/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.metric.filter;

import com.google.common.base.Function;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.storm.metric.api.IMetricsConsumer;
import org.apache.storm.metric.filter.MetricsFilter;

public class FilterByMetricName
implements MetricsFilter {
    private final Cache<String, Boolean> filterCache;
    private final List<Pattern> whitelistPattern;
    private final List<Pattern> blacklistPattern;
    private boolean noneSpecified = false;

    public FilterByMetricName(List<String> whitelistPattern, List<String> blacklistPattern) {
        this.whitelistPattern = whitelistPattern == null ? Collections.emptyList() : this.convertPatternStringsToPatternInstances(whitelistPattern);
        this.blacklistPattern = blacklistPattern == null ? Collections.emptyList() : this.convertPatternStringsToPatternInstances(blacklistPattern);
        if (this.whitelistPattern.isEmpty() && this.blacklistPattern.isEmpty()) {
            this.noneSpecified = true;
        } else if (!this.whitelistPattern.isEmpty() && !this.blacklistPattern.isEmpty()) {
            throw new IllegalArgumentException("You have to specify either includes or excludes, or none.");
        }
        this.filterCache = CacheBuilder.newBuilder().maximumSize(1000L).build();
    }

    public boolean apply(IMetricsConsumer.DataPoint dataPoint) {
        if (this.noneSpecified) {
            return true;
        }
        String metricName = dataPoint.name;
        Boolean cachedFilteredIn = (Boolean)this.filterCache.getIfPresent((Object)metricName);
        if (cachedFilteredIn != null) {
            return cachedFilteredIn;
        }
        boolean filteredIn = this.isFilteredIn(metricName);
        this.filterCache.put((Object)metricName, (Object)filteredIn);
        return filteredIn;
    }

    private ArrayList<Pattern> convertPatternStringsToPatternInstances(List<String> patterns) {
        return Lists.newArrayList((Iterator)Iterators.transform(patterns.iterator(), (Function)new Function<String, Pattern>(){

            public Pattern apply(String s) {
                return Pattern.compile(s);
            }
        }));
    }

    private boolean isFilteredIn(String metricName) {
        if (!this.whitelistPattern.isEmpty()) {
            return this.checkMatching(metricName, this.whitelistPattern, true);
        }
        if (!this.blacklistPattern.isEmpty()) {
            return this.checkMatching(metricName, this.blacklistPattern, false);
        }
        throw new IllegalStateException("Shouldn't reach here");
    }

    private boolean checkMatching(String metricName, List<Pattern> patterns, boolean valueWhenMatched) {
        for (Pattern pattern : patterns) {
            if (!pattern.matcher(metricName).find()) continue;
            return valueWhenMatched;
        }
        return !valueWhenMatched;
    }
}

