/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.nimbus;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.storm.utils.ObjectReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NimbusInfo
implements Serializable {
    private static final long serialVersionUID = 2161446155116099333L;
    private static final Logger LOG = LoggerFactory.getLogger(NimbusInfo.class);
    private String host;
    private int port;
    private boolean isLeader;
    private static final Pattern HOST_PORT_PATTERN = Pattern.compile("^(.*):([0-9]+)$");

    public NimbusInfo(String host, int port, boolean isLeader) {
        if (host == null) {
            throw new NullPointerException("Host cannot be null");
        }
        if (port < 0) {
            throw new IllegalArgumentException("Port cannot be negative");
        }
        this.host = host;
        this.port = port;
        this.isLeader = isLeader;
    }

    public static NimbusInfo parse(String nimbusInfo) {
        Matcher m = HOST_PORT_PATTERN.matcher(nimbusInfo);
        if (!m.matches()) {
            throw new RuntimeException("nimbusInfo should have format of host:port, invalid string " + nimbusInfo);
        }
        return new NimbusInfo(m.group(1), Integer.valueOf(m.group(2)), false);
    }

    public static NimbusInfo fromConf(Map<String, Object> conf) {
        try {
            String host = InetAddress.getLocalHost().getCanonicalHostName();
            if (conf.containsKey("storm.local.hostname")) {
                host = (String)conf.get("storm.local.hostname");
                LOG.info("Overriding nimbus host to storm.local.hostname -> {}", (Object)host);
            } else {
                LOG.info("Nimbus figures out its name to {}", (Object)host);
            }
            int port = ObjectReader.getInt(conf.get("nimbus.thrift.port"), 6627);
            return new NimbusInfo(host, port, false);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Something wrong with network/dns config, host cant figure out its name", e);
        }
    }

    public String toHostPortString() {
        return String.format("%s:%s", this.host, this.port);
    }

    public boolean isLeader() {
        return this.isLeader;
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public void setLeader(boolean isLeader) {
        this.isLeader = isLeader;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NimbusInfo)) {
            return false;
        }
        NimbusInfo that = (NimbusInfo)o;
        if (this.isLeader != that.isLeader) {
            return false;
        }
        if (this.port != that.port) {
            return false;
        }
        return this.host.equals(that.host);
    }

    public int hashCode() {
        int result2 = this.host.hashCode();
        result2 = 31 * result2 + this.port;
        result2 = 31 * result2 + (this.isLeader ? 1 : 0);
        return result2;
    }

    public String toString() {
        return "NimbusInfo{host='" + this.host + '\'' + ", port=" + this.port + ", isLeader=" + this.isLeader + '}';
    }
}

