/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.pacemaker;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.auth.login.Configuration;
import org.apache.storm.generated.HBMessage;
import org.apache.storm.messaging.netty.ISaslClient;
import org.apache.storm.messaging.netty.NettyRenameThreadFactory;
import org.apache.storm.pacemaker.PacemakerConnectionException;
import org.apache.storm.pacemaker.codec.ThriftNettyClientCodec;
import org.apache.storm.security.auth.AuthUtils;
import org.apache.storm.utils.StormBoundedExponentialBackoffRetry;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PacemakerClient
implements ISaslClient {
    private static final Logger LOG = LoggerFactory.getLogger(PacemakerClient.class);
    private String client_name;
    private String secret;
    private AtomicBoolean ready;
    private final ClientBootstrap bootstrap;
    private AtomicReference<Channel> channelRef;
    private InetSocketAddress remote_addr;
    private int maxPending = 100;
    private HBMessage[] messages;
    private LinkedBlockingQueue<Integer> availableMessageSlots;
    private ThriftNettyClientCodec.AuthMethod authMethod;
    private static Timer timer = new Timer(true);
    private StormBoundedExponentialBackoffRetry backoff = new StormBoundedExponentialBackoffRetry(100, 5000, 20);
    private int retryTimes = 0;

    public PacemakerClient() {
        this.bootstrap = new ClientBootstrap();
    }

    public PacemakerClient(Map<String, Object> config, String host) {
        ThriftNettyClientCodec.AuthMethod authMethod;
        String auth;
        int port = (Integer)config.get("pacemaker.port");
        this.client_name = (String)config.get("topology.name");
        if (this.client_name == null) {
            this.client_name = "pacemaker-client";
        }
        switch (auth = (String)config.get("pacemaker.auth.method")) {
            case "DIGEST": {
                Configuration login_conf = AuthUtils.GetConfiguration(config);
                authMethod = ThriftNettyClientCodec.AuthMethod.DIGEST;
                this.secret = AuthUtils.makeDigestPayload(login_conf, "PacemakerDigest");
                if (this.secret != null) break;
                LOG.error("Can't start pacemaker server without digest secret.");
                throw new RuntimeException("Can't start pacemaker server without digest secret.");
            }
            case "KERBEROS": {
                authMethod = ThriftNettyClientCodec.AuthMethod.KERBEROS;
                break;
            }
            case "NONE": {
                authMethod = ThriftNettyClientCodec.AuthMethod.NONE;
                break;
            }
            default: {
                authMethod = ThriftNettyClientCodec.AuthMethod.NONE;
                LOG.warn("Invalid auth scheme: '{}'. Falling back to 'NONE'", (Object)auth);
            }
        }
        this.ready = new AtomicBoolean(false);
        this.channelRef = new AtomicReference<Object>(null);
        this.setupMessaging();
        NettyRenameThreadFactory bossFactory = new NettyRenameThreadFactory("client-boss");
        NettyRenameThreadFactory workerFactory = new NettyRenameThreadFactory("client-worker");
        NioClientSocketChannelFactory factory = new NioClientSocketChannelFactory((Executor)Executors.newCachedThreadPool(bossFactory), (Executor)Executors.newCachedThreadPool(workerFactory));
        this.bootstrap = new ClientBootstrap((ChannelFactory)factory);
        this.bootstrap.setOption("tcpNoDelay", (Object)true);
        this.bootstrap.setOption("sendBufferSize", (Object)0x500000);
        this.bootstrap.setOption("keepAlive", (Object)true);
        this.remote_addr = new InetSocketAddress(host, port);
        ChannelPipelineFactory pipelineFactory = new ThriftNettyClientCodec(this, config, authMethod, host).pipelineFactory();
        this.bootstrap.setPipelineFactory(pipelineFactory);
        this.bootstrap.connect((SocketAddress)this.remote_addr);
    }

    private void setupMessaging() {
        this.messages = new HBMessage[this.maxPending];
        this.availableMessageSlots = new LinkedBlockingQueue();
        for (int i = 0; i < this.maxPending; ++i) {
            this.availableMessageSlots.add(i);
        }
    }

    @Override
    public synchronized void channelConnected(Channel channel) {
        Channel oldChannel = this.channelRef.get();
        if (oldChannel != null) {
            LOG.debug("Closing oldChannel is connected: {}", (Object)oldChannel.toString());
            this.close_channel();
        }
        LOG.debug("Channel is connected: {}", (Object)channel.toString());
        this.channelRef.set(channel);
        if (this.authMethod == ThriftNettyClientCodec.AuthMethod.NONE) {
            this.ready.set(true);
            this.notifyAll();
        }
        this.retryTimes = 0;
    }

    @Override
    public synchronized void channelReady() {
        LOG.debug("Channel is ready.");
        this.ready.set(true);
        this.notifyAll();
    }

    @Override
    public String name() {
        return this.client_name;
    }

    @Override
    public String secretKey() {
        return this.secret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HBMessage send(HBMessage m) throws PacemakerConnectionException {
        LOG.debug("Sending message: {}", (Object)m.toString());
        try {
            int next = this.availableMessageSlots.take();
            HBMessage hBMessage = m;
            synchronized (hBMessage) {
                m.set_message_id(next);
                this.messages[next] = m;
                LOG.debug("Put message in slot: {}", (Object)Integer.toString(next));
                do {
                    this.waitUntilReady();
                    Channel channel = this.channelRef.get();
                    if (channel == null) continue;
                    channel.write((Object)m);
                    m.wait(1000L);
                } while (this.messages[next] == m);
            }
            HBMessage ret = this.messages[next];
            if (ret == null) {
                this.send(m);
            }
            this.messages[next] = null;
            LOG.debug("Got Response: {}", (Object)ret);
            return ret;
        }
        catch (InterruptedException e) {
            LOG.error("PacemakerClient send interrupted: ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitUntilReady() throws PacemakerConnectionException {
        if (!this.ready.get() || this.channelRef.get() == null) {
            PacemakerClient pacemakerClient = this;
            synchronized (pacemakerClient) {
                if (!this.ready.get()) {
                    LOG.debug("Waiting for netty channel to be ready.");
                    try {
                        this.wait(1000L);
                        if (!this.ready.get() || this.channelRef.get() == null) {
                            throw new PacemakerConnectionException("Timed out waiting for channel ready.");
                        }
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gotMessage(HBMessage m) {
        int message_id = m.get_message_id();
        if (message_id >= 0 && message_id < this.maxPending) {
            LOG.debug("Pacemaker client got message: {}", (Object)m.toString());
            HBMessage request = this.messages[message_id];
            if (request == null) {
                LOG.debug("No message for slot: {}", (Object)Integer.toString(message_id));
            } else {
                HBMessage hBMessage = request;
                synchronized (hBMessage) {
                    this.messages[message_id] = m;
                    request.notifyAll();
                    this.availableMessageSlots.add(message_id);
                }
            }
        } else {
            LOG.error("Got Message with bad id: {}", (Object)m.toString());
        }
    }

    public void reconnect() {
        final PacemakerClient client = this;
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                client.doReconnect();
            }
        }, this.backoff.getSleepTimeMs(this.retryTimes++, 0L));
        this.ready.set(false);
        this.setupMessaging();
    }

    public synchronized void doReconnect() {
        this.close_channel();
        this.bootstrap.connect((SocketAddress)this.remote_addr);
    }

    public void shutdown() {
        this.bootstrap.shutdown();
    }

    private synchronized void close_channel() {
        if (this.channelRef.get() != null) {
            this.channelRef.get().close();
            LOG.debug("channel {} closed", (Object)this.remote_addr);
            this.channelRef.set(null);
        }
    }

    public void close() {
        this.close_channel();
    }
}

