/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.pacemaker.codec;

import org.apache.storm.generated.HBMessage;
import org.apache.storm.generated.HBServerMessageType;
import org.apache.storm.messaging.netty.ControlMessage;
import org.apache.storm.messaging.netty.SaslMessageToken;
import org.apache.storm.utils.Utils;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.frame.FrameDecoder;

public class ThriftDecoder
extends FrameDecoder {
    private static final int INTEGER_SIZE = 4;

    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buf) throws Exception {
        long available = buf.readableBytes();
        if (available < 4L) {
            return null;
        }
        buf.markReaderIndex();
        int thriftLen = buf.readInt();
        if ((available -= 4L) < (long)thriftLen) {
            buf.resetReaderIndex();
            return null;
        }
        byte[] serialized = new byte[thriftLen];
        buf.readBytes(serialized, 0, thriftLen);
        HBMessage m = Utils.thriftDeserialize(HBMessage.class, serialized);
        if (m.get_type() == HBServerMessageType.CONTROL_MESSAGE) {
            ControlMessage cm = ControlMessage.read(m.get_data().get_message_blob());
            return cm;
        }
        if (m.get_type() == HBServerMessageType.SASL_MESSAGE_TOKEN) {
            SaslMessageToken sm = SaslMessageToken.read(m.get_data().get_message_blob());
            return sm;
        }
        return m;
    }
}

